<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_tab_config extends Su_Data {

    function __construct() {
        parent::__construct();
    }
    static function get_config() {

        return array(
            'name'  => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TAB'),
            'type'  => 'wrap',
            'group' => 'box',
            'atts'  => array(
                'title' => array(
                    'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
                    'name'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
                    'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
                ),
                'disabled' => array(
                    'type'    => 'bool',
                    'default' => 'no',
                    'name'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DISABLE'),
                    'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DISABLE_DESC')
                ),
                'icon' => array(
                    'type'    => 'icon',
                    'default' => '',
                    'name'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
                    'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
                ),
                'anchor' => array(
                    'default' => '',
                    'name'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANCHOR'),
                    'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANCHOR_DESC')
                ),
                'url' => array(
                    'default' => '',
                    'name' => JText::_('URL'),
                    'desc' => JText::_('You can link this tab to any webpage. Enter here full URL to switch this tab into link'),
                    'child'		=> array(
                    	'target' => array(
                    	    'type' => 'select',
                    	    'values' => array(
                    	        'self'  => JText::_('Open link in same window/tab'),
                    	        'blank' => JText::_('Open link in new window/tab')
                    	    ),
                    	    'default' => 'blank',
                    	    'name' => JText::_('Link target'),
                    	    'desc' => JText::_('Choose how to open the custom tab link')
                    	)
                    )
                ),
                'class' => array(
                    'default' => '',
                    'name'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
                    'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
                )
            ),
            'content' => 'Tab content',
            'desc'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TAB_DESC'),
            'icon'    => 'list-alt'
        );
    }

}
