<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_section extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }   
    public static function section($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
            'background'  => '#ffffff',
            'image'       => '',
            'repeat'      => 'repeat',
            'parallax'    => 'yes',
            'speed'       => '10',
            'max_width'   => '960',
            'margin'      => '0px 0px 0px 0px',
            'padding'     => '30px 0px 30px 0px',
            'border'      => 'none',
            'color'       => '#333333',
            'text_align'  => 'inharit',
            'text_shadow' => 'none',
            'url'         => '',
            'class'       => ''
                ), $atts, 'section');


        $background = ( $atts['image'] ) ? sprintf('%s %s url(\'%s\') repeat %s', $atts['background'], '50% 0', image_media($atts['image']), ( $atts['parallax'] === 'yes' ) ? 'fixed' : 'scroll' ) : $atts['background'];

        if ($atts['image'] && $atts['parallax'] === 'yes') {
            $atts['class'] .= ' su-section-parallax';
        }
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
        }

        if ($atts['image'] && $atts['parallax'] === 'yes' or $atts['url']) {
            suAsset::addFile('js', 'section.js', __FUNCTION__);
        }
        suAsset::addFile('css', 'section.css', __FUNCTION__);

        $atts['text_align']  = ($atts['text_align'] !='inherit') ? 'text-align:' . $atts['text_align'].';' : '';
        $atts['text_shadow'] = ($atts['text_shadow']) ? ' -webkit-text-shadow:' . $atts['text_shadow'] . ';-moz-text-shadow:' . $atts['text_shadow'] . ';text-shadow:' . $atts['text_shadow'].';' : '';


        return '<div class="su-section' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" data-speed="' . $atts['speed'] . '" style="background:' . $background . ';margin:' . $atts['margin'] . ';padding:' . $atts['padding'] . ';border-top:' . $atts['border'] . ';border-bottom:' . $atts['border'] . '"><div class="su-section-content su-content-wrap" style="max-width:' . $atts['max_width'] . 'px; '.$atts['text_align'].' color:' . $atts['color'] . ';'.$atts['text_shadow'].'">' . su_do_shortcode($content) . '</div></div>';
    }
}
