<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_panel extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }   
    public static function panel($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
            'background' => '',
            'color'      => '',
            'shadow'     => '',
            'padding'    => '',
            'margin'     => '',
            'border'     => '',
            'radius'     => '',
            'text_align' => '',
            'url'        => '',
            'class'      => ''
        ), $atts, 'panel');

        $id = uniqid('supnl');
        $padding = '';
        $margin = '';
        $css = array();
        
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            suAsset::addFile('js', 'panel.js', __FUNCTION__);
        }
        if (substr($atts['padding'], -2)=='px' || substr($atts['padding'], -2)=='em') {
            if ($atts['padding']) {
                $padding = 'padding:'.$atts['padding'].';';
            }
        } else {
            if ($atts['padding'] != '') {
                $padding = 'padding:'.$atts['padding'].'px;';
            }
        }
        if ($atts['margin'] != '') {
            $margin = 'margin:'.$atts['margin'].';';
        }
        $radius =  ($atts['radius']) ? '-webkit-border-radius:' . $atts['radius'] . ';border-radius:' . $atts['radius'] . ';' : '';
        $border =  ($atts['border'] != '') ? 'border:' . $atts['border'] . ';' : '';
        $shadow = ($atts['shadow'] != '') ? '-webkit-box-shadow:' . $atts['shadow'] . ';box-shadow:' . $atts['shadow'] . ';' : '';
        $background = ($atts['background'] != '') ? 'background-color:' . $atts['background'] . ';' : '';
        $color = ($atts['color'] != '') ? 'color:' . $atts['color'] . ';' : '';

        if ($radius or $border or $shadow or $background or $color) 
            $css[] = '#'.$id.'.su-panel { '.$background. $color. $border . $radius. $margin. '}';

        if ($atts['text_align'])
            $css[] = '#'.$id.'.su-panel .su-panel-content { text-align:' . $atts['text_align'] . ';'.$padding.'}';

        suAsset::addFile('css', 'panel.css', __FUNCTION__);
        suAsset::addString('css', implode("\n", $css));
        $return = '<div id="'.$id.'" class="su-panel' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '"><div class="su-panel-content su-content-wrap">' . su_do_shortcode($content) . '</div></div>';
        return $return;
    }
}
