<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_member extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }   
    public static function member($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
            'style'       => '1',
            'background'   => '#ffffff',
            'color'        => '#333333',
            'shadow'       => '',
            'border'       => '1px solid #cccccc',
            'radius'       => '0',
            'text_align'   => 'left',
            'photo'        => BDT_SU_IMG.'sample/member.svg',
            'name'         => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME_DEFAULT'),
            'role'         => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROLE_DEFAULT'),
            'icon_1'       => '',
            'icon_1_url'   => '',
            'icon_1_color' => '#444444',
            'icon_1_title' => '',
            'icon_2'       => '',
            'icon_2_url'   => '',
            'icon_2_color' => '#444444',
            'icon_2_title' => '',
            'icon_3'       => '',
            'icon_3_url'   => '',
            'icon_3_color' => '#444444',
            'icon_3_title' => '',
            'icon_4'       => '',
            'icon_4_url'   => '',
            'icon_4_color' => '#444444',
            'icon_4_title' => '',
            'icon_5'       => '',
            'icon_5_url'   => '',
            'icon_5_color' => '#444444',
            'icon_5_title' => '',
            'icon_6'       => '',
            'icon_6_url'   => '',
            'icon_6_color' => '#444444',
            'icon_6_title' => '',
            'url'          => '',
            'class'        => ''
        ), $atts, 'member');
        
        $icons = array();
        $id = uniqid('sum');
        $css[] = '';

        $box_shadow = ($atts['shadow']) ? 'box-shadow:' . $atts['shadow'] . '; -webkit-box-shadow:' . $atts['shadow'] . ';' : '';
        $radius = ($atts['radius']) ? 'border-radius:' . $atts['radius'] . ';' : '';

        $css[] = '#'.$id.'.su-member {background-color:' . $atts['background'] . '; color:' . $atts['color'] . '; border:' . $atts['border'] .';'. $radius . $box_shadow .'}';
        
        for ($i = 1; $i <= 6; $i++) {
            if (!$atts['icon_' . $i] || !$atts['icon_' . $i . '_url'])
                continue;
            if (strpos($atts['icon_' . $i], 'icon:') !== false) { $icon = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon_' . $i])) . '" style="color:' . $atts['icon_' . $i . '_color'] . '"></i>';}
            else { $icon = '<img src="' . image_media($atts['icon_' . $i]) . '" width="16" height="16" alt="" />'; }
            $icons[] = '<a href="' . $atts['icon_' . $i . '_url'] . '" title="' . $atts['icon_' . $i . '_title'] . '" class="su-memeber-icon su-m-' . trim(str_replace('icon:', '', $atts['icon_' . $i])) . '" target="_blank">' . $icon . '</a>';
        }

        $icons = (count($icons)) ? '<div class="su-member-icons" style="text-align:' . $atts['text_align'] . ';"><div class="su-member-ic">' . implode('', $icons) . '</div></div>' : '';
        
        $multi_photo = array();
        $multi_photo = explode(',',$atts['photo'], 2);
        $member_photo ='';
        $member_photo = '<img src="' . image_media($multi_photo[0]) . '" alt="" />';

       if(isset($multi_photo[1]) )
        $member_photo .= '<img src="' . image_media($multi_photo[1]) . '" alt=""  />';

        $title = '<span class="su-member-name">' . $atts['name'] . '</span><span class="su-member-role">' . $atts['role'] . '</span>';



        // Adding asset
        suAsset::addFile('css', 'membar.css', __FUNCTION__);
        suAsset::addString('css', implode("\n", $css));

        // HTML Layout 
        $return = '<div id="'.$id.'" class="su-member su-member-style-'. $atts['style'] ." ". su_ecssc($atts) . '" data-url="' . $atts['url'] . '">';
            $return .= '<div class="su-member-photo">'. $member_photo;
                if ($atts['style'] == '2' or $atts['style'] == '4') { $return .= $icons; }
            $return .= '</div>';

            $return .= '<div class="su-member-info" style="text-align:' . $atts['text_align'] . '">';
                $return .= $title;
                $return .= '<div class="su-member-desc su-content-wrap">' . su_do_shortcode($content) . '</div>';
            $return .= '</div>';

            if ($atts['style'] != '2' and $atts['style'] != '4') { $return .= $icons; }

        $return .= '</div>';
        
        return $return;
    }
}
