<?php

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_icon extends Su_Shortcodes {
    function __construct() {
        parent::__construct();
    }
    public static function icon($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
            'icon'       => 'icon: heart',
            'background' => '#eeeeee',
            'color'      => '#333333',
            'size'       => '20',
            'shape_size' => '', // dep 1.6.7
            'padding'    => '15px',
            'radius'     => '3px',
            'border'     => 'none',
            'margin'     => '',
            'url'        => '',
            'target'     => 'blank',
            'class'      => ''
                ), $atts, 'icon');

        $id = uniqid('suico_');
        $css[] = '';

        // dep 1.6.7
        if ($atts['shape_size']) {
            $atts['padding'] = $atts['shape_size'];
        }


        if ($atts['margin']) {
            $css[] .= '#'.$id.'.su-icon{margin:' . $atts['margin'] .'}';
        }
        
        if (strpos($atts['icon'], '/') !== false) {
            $css[] .= '#'.$id.'.su-icon img{ width:' . $atts['size'] . 'px;height:' . $atts['size'] . 'px;background:' . $atts['background'] . ';-webkit-border-radius:' . $atts['radius'] . ';border-radius:' . $atts['radius'] . ';border: '. $atts['border'].';padding:' . $atts['padding'] . '; }';
        } 
        else if (strpos($atts['icon'], 'icon:') !== false) {
            $css[] .= '#'.$id.'.su-icon i{ font-size:' . $atts['size'] . 'px;line-height:' . $atts['size'] . 'px;background:' . $atts['background'] . ';color:' . $atts['color'] . ';-webkit-border-radius:' . $atts['radius'] . ';border-radius:' . $atts['radius'] . ';border: '. $atts['border'].'; padding:' . $atts['padding'] . '; }';
        }


        if (strpos($atts['icon'], '/') !== false) {
            $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" alt="" width="' . $atts['size'] . '" height="' . $atts['size'] . '" />';
        }
        // Font-Awesome icon
        else if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '"></i>';
            
        }

        // Prepare text
        if ($content)
            $content = '<span class="su-icon-text">' . $content . '</span>';

        if (!$atts['url']) {
            $icon = '<span id="'.$id.'" class="su-icon' . su_ecssc($atts) . '">' . $atts['icon'] . su_do_shortcode($content) . '</span>';
        } else {
            $icon = '<a id="'.$id.'" href="' . $atts['url'] . '" class="su-icon' . su_ecssc($atts) . '" target="_' . $atts['target'] . '">' . $atts['icon'] . su_do_shortcode($content) . '</a>';
        }
        
        // Asset added
        suAsset::addFile('css', 'icon.css', __FUNCTION__);
        suAsset::addString('css', implode("\n", $css));

        return $icon;
    }

}
