<?php

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_heading extends Su_Shortcodes {

  function __construct() {
      parent::__construct();
  }

  public static function heading( $atts = null, $content = null ) {
    $atts = su_shortcode_atts(array(
          'style'   => 'default',
          'size'    => 16,
          'align'   => 'center',
          'margin'  => '20',
          'width'   => '',
          'heading' => 'h3',
          'color'   => '#666',
          'class'   => ''
        ), $atts, 'heading');

      suAsset::addFile('css', 'heading.css', __FUNCTION__);

      $heading_wrapper_style = 'style="';
      if ($atts["width"]) {
        $heading_wrapper_style .= 'width: ' . intVal($atts['width']) . '%;';
      }

      if ($atts["align"] == 'center') {
        $heading_wrapper_style .= 'margin-left: auto; margin-right: auto;';
      } elseif ($atts["align"] == 'left') {
        $heading_wrapper_style .= 'margin-right: auto;';
      } elseif ($atts["align"] == 'right') {
        $heading_wrapper_style .= 'margin-left: auto;';
      }
      $heading_wrapper_style .= 'margin-bottom: ' . intVal($atts['margin']) . 'px;';
      $heading_wrapper_style .= '"';

      $heading_style = 'style="';
      $heading_style .= 'font-size: ' . intVal($atts['size']) . 'px;';
      $heading_style .= ($atts['color']) ? ' color: ' . $atts['color'] . ';' : '';
      $heading_style .= '"';

    return '<div class="su-heading su-heading-style-' . $atts['style'] . ' su-heading-align-' . $atts['align'] . su_ecssc($atts) . '" '.$heading_wrapper_style.'><'.$atts['heading'].' class="su-heading-inner" '.$heading_style.'>' . su_do_shortcode($content) . '</'.$atts['heading'].'></div>';
  }
}
