<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_counter extends Su_Shortcodes {

    function __construct() {
      parent::__construct();
    }

    public static function counter($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
            'align'                    => 'top',
            'count_start'              => 1,
            'count_end'                => 5000,
            'counter_refresh_interval' => 50,
            'counter_speed'            => 5,
            'separator'                => 'no',
            'decimal'                  => 'no',
            'prefix'                   => '',
            'suffix'                   => '',
            'count_color'              => '',
            'count_size'               => '32px',
            'text_color'               => '',
            'text_size'                => '14px',
            'icon'                     => '',
            'icon_color'               => '',
            'icon_size'                => '24',
            'border'                   => '',
            'background'               => '',
            'class'                    => ''
            ), $atts);       

        $id = uniqid('suc');
        $css = array();

        if (strpos($atts['icon'], '/') !== false) {
            $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" style="width:' . $atts['count_size'] . ';" alt="" />';
        }
        else if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '"></i>';         
        }

        $icon = ($atts['icon']) ? '<div class="su-counter-icon">'. $atts['icon'] .'</div>' : '';
        $border = ($atts['border']) ? 'border:'.$atts['border'].';' : '';
        $background = ($atts['background']) ? 'background-color:'.$atts['background'].';' : '';

        if ($border or $background) {
            $css[] = '#'.$id.' {' .$background.$border.'}';
        }

        $count_color = ($atts['count_color']) ? 'color:' . $atts['count_color'] . ';' : '';
        $text_color = ($atts['text_color']) ? 'color:' . $atts['text_color'] . ';' : '';
        $icon_color = ($atts['icon_color']) ? 'color:' . $atts['icon_color'] . ';' : '';

        $css[] = '#'.$id.' .su-counter-number {font-size: '.$atts['count_size'].'; '. $count_color .' }';
        $css[] = '#'.$id.' .su-counter-text {'. $text_color .' font-size: '.$atts['text_size'].';}';
        $css[] = '#'.$id.' .su-counter-icon i {' . $icon_color .'' . 'font-size:' . $atts['count_size'] . ';}';


        suAsset::addString('css', implode("\n", $css));
        suAsset::addFile('js', 'jquery.appear.js');
        suAsset::addFile('js', 'countUp.js', __FUNCTION__);
        suAsset::addFile('css', 'counter.css', __FUNCTION__);


        $return = '<div id="'. $id .'" class="su-counter-wrapper clearfix su-counter-'.$atts['align'].' '. su_ecssc($atts) . '" data-id="'.$id.'" data-from="'.$atts['count_start'].'" data-to="'.$atts['count_end'].'" data-speed="'.$atts['counter_speed'].'" data-separator="'.$atts['separator'].'" data-prefix="'.$atts['prefix'].'" data-suffix="'.$atts['suffix'].'">';
        $return .= $icon;
        $return .= '<div class="su-counter-desc">
                <div id="'. $id .'_count"  class="su-counter-number">
                </div>
                <div class="su-counter-text">'. su_do_shortcode($content) .'</div>                
            </div>
        </div>';

        return $return;
    }
}
