<?php 

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_contact_form extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }
    
    public static function contact_form( $atts = null, $content = null ) {
        $atts = su_shortcode_atts(array(
            'style'              => 'default',
            'email'              => '',
            'name'               => 'yes',
            'subject'            => 'yes',
            'submit_button_text' => '',
            'label_show'         => 'yes',
            'textarea_height'    => 120,
            'reset'              => 'yes',
            'margin'             => '',
            'class'              => ''
        ), $atts, 'contact_form');

        $config = JFactory::getConfig();

        $margin = ($atts['margin'] != '') ? 'margin: '. $atts['margin'] : ' margin: 0 0 25px 0';
        
        suAsset::addFile('css', 'contact_form.css', __FUNCTION__);
        suAsset::addFile('js', 'contact_form.js', __FUNCTION__);

        $validation_name    = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_NAME');
        $validation_email   = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_EMAIL');
        $validation_subject = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_SUBJECT');
        $validation_message = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_MESSAGE');
        $validation_vemail  = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_VALID_EMAIL_ADDRESS');

        $fields = "";

        if ($atts['name']=='yes' && $atts['subject']=='yes') {
            $fields .= 'name-email-subject';
        } elseif ($atts['name']=='yes') {
           $fields .= 'name-email';
        }  elseif ($atts['subject']=='yes') {
           $fields .= 'email-subject';
        } else {
            $fields .= 'email';
        }        

        if (isset($_POST['email'])) {
            $name = $_POST['name'];
            $email = $_POST['email'];
            $subject = $_POST['subject'];
            $message = $_POST['message'];

            $to = ($atts['email']) ? $atts['email'] :  $config->get( 'mailfrom' );

            $headers = 'MIME-Version: 1.0' . "\r\n";
            $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";


            if(!empty($subject)){           
                $subject = $subject;
            } else {
                $subject =  $config->get( 'fromname' );
            }
            
            $message = $message . " \r\n \r\n " . $name . ", \r\n " . $email;

            if (!$email) {
                $erre = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_EMAIL');
            } elseif (!$message) {
                $errm = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_MESSAGE');
            } else {
                $email = trim($email);
                $_ename = "/^[-!#$%&\'*+\\.\/0-9=?A-Z^_'{|}~]+";
                $_host = "([0-9A-Z]+\.)+";
                $_tlds = "([0-9A-Z]){2,4}$/i";
                $mail_validate = FALSE;

                if (!preg_match($_ename . "@" . $_host . $_tlds, $email)) {
                    $mail_validate = TRUE;
                    $errev = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_VALID_EMAIL_ADDRESS');
                } else {

                    if (mail($to, $subject, $message, $headers)) {
                        echo 1;
                    } else
                        echo 1;

                    exit(0);
                }
            }
        }
        $str = '
        <div class="su-contact_form '.$fields . su_ecssc($atts) . '" style="'.$margin.'"> 
            <script type="text/javascript">
                validation_name="'.$validation_name.'";
                validation_email="'.$validation_email.'";
                validation_vemail="'.$validation_vemail.'";
                validation_subject="'.$validation_subject.'";
                validation_message="'.$validation_message.'";       
            </script>
            <div class="su-form-wrapper">                                
                <div class="su-form">
                    <div class="error-message">
                        <span class="text"></span>
                </div>
                <form name="contact_us_form" id="contact_us_form" class="form-horizontal" action="' . JURI::current() . '" method="POST">
                    <div class="su-form-fields">
                        ';
                        if($atts['name']=='yes'){
                        $str.='
                            <div class="form-group">
                                ';
                                if ($atts['label_show']=='yes') {$str.='<label for="name" class="su-form-label">'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTACT_NAME') .'</label>';}                    
                                $str.=' 
                                <div class="su-input-box">
                                    <input type="text" placeholder="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_NAME') .'" id="name" class="form-control" name="name" />
                                </div>
                            </div>';
                        }
                        $str.='
                        <div class="form-group">
                            ';
                            if ($atts['label_show']=='yes') {$str.='<label for="email" class="su-form-label">'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTACT_EMAIL') .'</label>';}                    
                            $str.='                             
                            <div class="su-input-box">                                    
                                <input type="text" placeholder="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_EMAIL') .'"  id="email" class="form-control" name="email" />
                            </div>
                        </div>';
                        if($atts['subject']=='yes'){
                        $str.='
                            <div class="form-group">
                                ';
                                if ($atts['label_show']=='yes') {$str.='<label for="subject" class="su-form-label">'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTACT_SUBJECT') .'</label>';}                    
                                $str.=' 
                                
                                <div class="su-input-box">
                                    <input type="text" placeholder="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_SUBJECT') .'"  id="subject" class="form-control" name="subject">
                                </div>
                            </div>
                    ';
                    }
                    $str.='
                    </div>
                    <div class="su-form-common-field">
                        <div class="form-group ">
                            ';
                            if ($atts['label_show']=='yes') {$str.='<label for="message" class="su-form-label">'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTACT_MESSAGE') .'</label>';}                    
                            $str.='                
                            <div class="su-input-box">
                                <textarea id="message"  placeholder="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_MESSAGE') .'"  class="form-control" name="message" style="height: '.$atts['textarea_height'].'px;"></textarea>
                            </div>
                        </div>

                        <div style="display: none;" id="contact_status" ></div>

                            <div class="form-group">
                                <div class=" submit-button">
                                    ';
                                    if ($atts['submit_button_text']) {$str.='<input name="contact_us_submit" class="btn btn-primary" type="button" name="contact_submit" value="'. $atts['submit_button_text'] .'" />';}   
                                    else{ $str.='<input name="contact_us_submit" class="btn btn-primary" type="button" name="contact_submit" value="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ENTER_SUBMIT') .'" />';}                 
                                   
                                    if($atts['reset']=='yes'){
                                        $str.='<input name="contact_us_reset" class="btn btn-warning" type="reset" name="contact_reset" value="'. JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESET') .'" />';
                                    }
                                    $str.='
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>';
        return $str;
    }


}
