var validation_name = '';
var validation_email = '';
var validation_vemail = '';
var validation_subject = '';
var validation_message = '';

function resetForm(id) {
	jQuery('#' + id).each(function() {
		this.reset();
	});
	if (jQuery('.error-message').is(':visible')) {
		jQuery('.error-message').slideUp(800);
	}
}

function isValidEmail(email) {
	var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	if (!filter.test(email)) {
		return false;
	} else {
		return true;
	}
}

function onErrorMessage(msgType, msgText) {
	jQuery('.error-message').removeClass('message-info');
	jQuery('.error-message').removeClass('message-warning');
	jQuery('.error-message').removeClass('message-success');
	jQuery('.error-message').removeClass('message-danger');

	if (msgType == 'info') {
		jQuery('.error-message').addClass('message-info');
	} else if (msgType == 'warning') {
		jQuery('.error-message').addClass('message-warning');
	} else if (msgType == 'success') {
		jQuery('.error-message').addClass('message-success');
	} else if (msgType == 'danger') {
		jQuery('.error-message').addClass('message-danger');
	}
	if (jQuery('.error-message').is(':visible')) {
		jQuery('.error-message .text').html(msgText);
	} else {
		jQuery('.error-message .text').html(msgText);
		jQuery('.error-message').slideDown(800);
	}
}

function onContactSubmit(formAction, formData) {
	jQuery.ajax({
		'type' : 'POST',
		'url' : formAction,
		'data' : formData,
		'success' : function(response) {
			if (response == 1) {
				jQuery('#contact_us_form').each(function() {
					this.reset();
				});
				onErrorMessage('success', 'Your Message Has been Sent Successfully');
				jQuery('body').animate({
					opacity : 1
				}, 1600, function() {
					if (jQuery('.error-message').is(':visible')) {
						jQuery('.error-message').slideUp(800);
					}
				});

			} else {
				onErrorMessage('warning', 'Server Processing Error');
			}
		}
	});
}


jQuery(document).ready(function() {

	jQuery(document).off('click', 'input[name="contact_us_submit"]');
	jQuery(document).on('click', 'input[name="contact_us_reset"]', function(e) {
		resetForm("contact_us_form");
	});
	jQuery(document).on('click', 'input[name="contact_us_submit"]', function(e) {
		//e.preventDefault;
		$ = jQuery;

		var form = jQuery('form[name="contact_us_form"]');
		var formData = form.serialize();
		var formAction = form.attr('action');

		var name = escape(jQuery('#name').val());
		var email = escape(jQuery('#email').val());
		var message = escape(jQuery('#message').val());
		var subject = escape(jQuery('#subject').val());

		isVal = false;
		vEmail = isValidEmail(email);
		if (name == '') {
			onErrorMessage('danger', validation_name);
		} else if (email == '') {
			onErrorMessage('danger', validation_email);
		} else if (!isNaN(email) || vEmail == false) {
			onErrorMessage('danger', validation_vemail);
		} else if (subject == '') {
			onErrorMessage('danger', validation_subject);
		} else if (message == '') {
			onErrorMessage('danger', validation_message);
		} else {
			isVal = true;
		}
		if (isVal != false) {
			onContactSubmit(formAction, formData);
		}
	});
});
