<?php

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_carousel extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }

    public static function carousel($atts = null, $content = null) {
        $return = '';
        $atts = su_shortcode_atts(array(
            'style'            => '1',
            'source'           => '',
            'limit'            => 5,
            'items'            => 4,
            'image'            => 'yes',
            'quality'          => 95,
            'title'            => 'yes',
            'title_link'       => 'yes',
            'title_limit'      => '',
            'intro_text'       => 'yes',
            'intro_text_limit' => '60',
            'background'       => '',
            'color'            => '',
            'title_color'      => '',
            'date'             => 'no',
            'category'         => 'no',
            'image_width'      => 360,
            'image_height'     => 320,
            'margin'           => 10,
            'scroll'           => 1,
            'arrows'           => 'no',
            'arrow_position'   => 'default',
            'pagination'       => 'yes',
            'autoplay'         => 'no',
            'delay'            => 4,
            'speed'            => 0.35,
            'hoverpause'       => 'no',
            'lazyload'         => 'no',
            'loop'             => 'yes',
            'class'            => ''
        ), $atts, 'carousel');

        $id = uniqid('suc');
        $title = "";
        $image = "";
        $intro_text='';
        $css[] = '';
        $background = '';
        $color = '';

        $lang = JFactory::getLanguage();
        $lang = ($lang->isRTL()) ? 'true' : 'false';

        $slides = (array) Su_Tools::get_slides($atts);


        if (($atts['background']) or ($atts['color'])) {

            $background = ($atts['background']) ? 'background-color:'.$atts['background'].';' : '';
            $color = ($atts['color']) ? 'color:'.$atts['color'].';' : '';

            $css[] = '#'.$id.' .su-carousel-slide {' . $background . $color .'}';

            if ($atts['style'] == 3) {
                $css[] = '#'.$id.'.su-carousel-style-3 .su-carousel-caption:after {border-bottom-color: '.$atts['background'].';}';
            }
            
        }

        if ($atts['title_color']) {
            $css[] = '#'.$id.' .su-carousel-slide .su-carousel-slide-title a {color: '.$atts['title_color'].';}';
            $css[] = '#'.$id.' .su-carousel-slide .su-carousel-slide-title a:hover {color: '.su_color::lighten($atts['title_color'],'10%').';}';
        }

        if (count($slides) and ($atts['title'] == 'yes' or $atts['image']  == 'yes' or  $atts['intro_text'] === 'yes')) {

            
            $source = substr($atts['source'], 0, 5);
            if ($source == 'media'){
                $atts['class'] .= ' su-carousel-media';
            }

            $return .= '<div id="' . $id . '" class="su-carousel su-carousel-style-'.$atts['style'].' su-carousel-title-' . $atts['title'] .' arrow-'. $atts['arrow_position'].' '. su_ecssc($atts). '" data-autoplay="' . $atts['autoplay'] .'" data-delay="' . $atts['delay'] . '" data-speed="' . $atts['speed'] . '" data-arrows="' . $atts['arrows'] .'" data-pagination="' . $atts['pagination'] . '" data-lazyload="' . $atts['lazyload'] . '" data-hoverpause="' . $atts['hoverpause'] . '" data-items="' . $atts['items'] . '" data-margin="' . $atts['margin'] . '" data-scroll="' . $atts['scroll'] . '" data-loop="' . $atts['loop'] . '" data-rtl="' . $lang . '" ><div class="su-carousel-slides">';
            $limit = 1;

            foreach ((array) $slides as $slide) {

                $image_url = su_image_resize($slide['image'], $atts['image_width'], $atts['image_height'], $atts['quality']);

                if($atts['title'] == 'yes' && $slide['title'] ) {

                    $title = stripslashes($slide['title']);

                    if ($atts['title_limit']) {
                        $title = su_char_limit($title, $atts['title_limit']);
                    }

                    if ($atts['title_link'] == "yes") {
                        $title = '<a href="'.$slide['link'].'">'.$title.'</a>';
                    }
                    $title = '<h3 class="su-carousel-slide-title">' . $title . '</h3>';
                }
                

                if ($atts['intro_text'] === 'yes' and isset($slide['introtext'])) {

                    $intro_text = $slide['introtext'];

                    if ($atts['intro_text_limit']) {
                        $intro_text = su_char_limit($intro_text, $atts['intro_text_limit']);
                    }

                    $intro_text =  '<div class="su-carousel-item-text">'.su_do_shortcode($intro_text).'</div>';
                }
                
                $return .= '<div class="su-carousel-slide">';

                    if (isset($image_url) && $atts['image']  == 'yes') {
                        $return .= '<div class="su-carousel-image">';

                            if (isset($image_url)) {
                                $return .= '<div class="su-carousel-links">
                                    <a class="su-lightbox-item" href="'. image_media($slide['image']) .'" title="'. strip_tags($title).'">
                                        <i class="fa fa-search"></i>
                                    </a>';

                                    if ($source != 'media') {
                                        $return .= '<a class="su-carousel-link" href="'.$slide['link'].'" title="'. strip_tags($title).'">
                                            <i class="fa fa-link"></i>
                                        </a>';
                                    }
                                $return .= '</div>';
                            }

                            $return .= '<img src="' . image_media($image_url['url']) . '" alt="' . strip_tags($title) . '" />';
                        $return .= '</div>';
                    }

                    if (($title) or ($intro_text)) {
                        $return .= '<div class="su-carousel-caption">'.$title . $intro_text.'</div>';
                    }
 

                $return .= '</div>';

                if ($limit++ == $atts['limit']) break;
            }

            $return .= '</div>';

            $return .= '</div>';

            suAsset::addString('css', implode("\n", $css));
            suAsset::addFile('css', 'magnific-popup.css');
            suAsset::addFile('js', 'magnific-popup.js');
            suAsset::addFile('css', 'owl.carousel.css');
            suAsset::addFile('js', 'owl.carousel.min.js');
            suAsset::addFile('css', 'carousel.css', __FUNCTION__);
            suAsset::addFile('js', 'carousel.js', __FUNCTION__);
        }

        else
            $return = alert_box(JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CAROUSEL_INF'), 'warning');
        return $return;
    }
}
