<?php

/**
* @package   Shortcode Ultimate
* @author    BdThemes http://www.bdthemes.com
* @copyright Copyright (C) BdThemes Ltd
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class Su_Shortcode_button2 extends Su_Shortcodes {

    function __construct() {
        parent::__construct();
    }
    public static function button2($atts = null, $content = null) {
        $atts = su_shortcode_atts(array(
          'url'         => JUri::root(),
          'link'        => null, // 3.x
          'target'      => 'self',
          'style'       => 'default',
          'background'  => '#2D89EF',
          'background_hover'  => '',
          'color'       => '#FFFFFF',
          'border'      => '0 solid #dddddd',
          'dark'        => null, // 3.x
          'size'        => 3,
          'wide'        => 'no',
          'center'      => 'no',
          'radius'      => '3',
          'icon'        => false,
          'icon_color'  => '#FFFFFF',
          'ts_color'    => null, // Dep. 4.3.2
          'ts_pos'      => null, // Dep. 4.3.2
          'text_shadow' => 'none',
          'desc'        => '',
          'onclick'     => '',
          'class'       => ''
        ), $atts, 'button2');


        $id = uniqid('subtn_');
        $css[] = '';
        $js[] = '';
        $color = new Color($atts['color']);
        $background = new Color($atts['background']);

        

        // CSS rules for <a> tag
        $css[] .= 'a#'.$id.' {color: '. $atts['color'] . '; background-color: ' .$atts['background']. '; border: ' .$atts['border']. '; border-radius: ' .$radius. '; }';
        $css[] .= 'a#'.$id.':hover {background-color: ' .$bg_hover. ';}';

        // Prepare icon
        if ($atts['icon']) {
          if (strpos($atts['icon'], 'icon:') !== false) {
              $icon = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $styles['size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
              
          } else
              $icon = '<img src="' . image_media($atts['icon']) . '" alt="' . esc_attr($content) . '" style="' . implode($img_css, ';') . '" />';
        } else
          $icon = '';
        

        suAsset::addFile('css', 'button2.css', __FUNCTION__);
        suAsset::addString('css', implode("\n", $css));

        return '<a id="'.$id.'" href="' . su_scattr($atts['url']) . '" class="' . implode($classes, ' ') . '" target="_' . $atts['target'] . '"' . $atts['onclick'] . '><span>' . su_do_shortcode($content) . $desc . '</span></a>';
    } 
}
