(function(dojo) {
    dojo.declare("NextendElementMixed", NextendElement, {
        constructor: function(args) {
            dojo.mixin(this, args);
            this.value = '';
            this.hidden = dojo.byId(this.hidden);
            for (var i = 0; i < this.elements.length; i++) {
                this.elements[i] = dojo.byId(this.elements[i]);
                dojo.connect(this.elements[i], 'change', this, 'change');
            }
            this.reset();
            dojo.connect(this.hidden, 'change', this, 'reset');
            this.hidden.nextendmixed = this;
        },

        reset: function() {
            if (this.value != this.hidden.value) {
                this.value = this.hidden.value;
                var parts = this.value.split(this.separator);
                for (var i = 0; i < this.elements.length; i++) {
                    if (typeof parts[i] != "undefined") {
                        this.elements[i].value = parts[i];
                    }
                }
                for (var i = 0; i < this.elements.length; i++) {
                    this.fireEvent(this.elements[i], 'change');
                }
            }
        },

        change: function() {
            var value = '';
            for (var i = 0; i < this.elements.length; i++) {
                if (i != 0) value += this.separator;
                value += this.elements[i].value;
            }
            this.value = this.hidden.value = value;
            this.fireEvent(this.hidden, 'change');
        }
    });
})(ndojo);