SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_logs_extensions` VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_log_config` VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE `#__acymailing_action` (
  `action_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `frequency` int(10) UNSIGNED NOT NULL,
  `nextdate` int(10) UNSIGNED NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `conditions` text,
  `actions` text,
  `report` text,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT '0',
  `senderfrom` tinyint(4) NOT NULL DEFAULT '0',
  `senderto` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_config` VALUES
('level', 'Starter'),
('version', '5.10.4'),
('from_name', 'Flatastic'),
('from_email', 'admin@admin.com'),
('mailer_method', 'mail'),
('sendmail_path', '/usr/sbin/sendmail'),
('smtp_secured', ''),
('smtp_auth', '0'),
('smtp_username', ''),
('smtp_password', ''),
('reply_name', 'Flatastic'),
('reply_email', 'admin@admin.com'),
('cron_sendto', 'admin@admin.com'),
('bounce_email', ''),
('add_names', '1'),
('encoding_format', '8bit'),
('charset', 'UTF-8'),
('word_wrapping', '150'),
('hostname', ''),
('embed_images', '0'),
('embed_files', '1'),
('editor', '0'),
('multiple_part', '1'),
('smtp_host', 'localhost'),
('smtp_port', ''),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_type', 'auto'),
('queue_try', '3'),
('queue_pause', '120'),
('allow_visitor', '1'),
('require_confirmation', '0'),
('priority_newsletter', '3'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('uploadfolder', 'media/com_acymailing/upload'),
('confirm_redirect', ''),
('subscription_message', '1'),
('notification_unsuball', ''),
('cron_next', '1251990901'),
('confirmation_message', '1'),
('welcome_message', '1'),
('unsub_message', '1'),
('cron_last', '0'),
('cron_fromip', ''),
('cron_report', ''),
('cron_frequency', '900'),
('cron_sendreport', '2'),
('cron_fullreport', '1'),
('cron_savereport', '2'),
('cron_savepath', 'media/com_acymailing/logs/report{year}_{month}.log'),
('notification_created', ''),
('notification_accept', ''),
('notification_refuse', ''),
('forward', '0'),
('description_starter', 'Joomla!™ E-mail Marketing'),
('description_essential', 'Joomla!™ Newsletter Extension'),
('description_business', 'Joomla!™ Marketing Campaign'),
('description_enterprise', 'Joomla!™ Mailing Extension'),
('priority_followup', '2'),
('unsub_redirect', ''),
('show_footer', '1'),
('use_sef', '0'),
('itemid', '0'),
('css_module', 'default'),
('css_frontend', 'default'),
('css_backend', ''),
('menu_position', 'under'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('installcomplete', '1'),
('Starter', '0'),
('Essential', '1'),
('Business', '2'),
('Enterprise', '3'),
('website', 'http://localhost/home/ver_2_2/'),
('module_redirect', '|localhost'),
('bootstrap_frontend', '0'),
('security_key', 'ZjWwtZk3iX00aT8hR8hvtMcB1JBFdZ'),
('acl_newsletters_lists', 'all'),
('acl_newsletters_attachments', 'all'),
('acl_newsletters_sender_informations', 'all'),
('acl_newsletters_meta_data', 'all'),
('acl_newsletters_abtesting', 'all'),
('captcha_plugin', 'no'),
('max_execution_time', '0'),
('description_sidekick', 'Joomla!® Mailing Extension'),
('Sidekick', '4'),
('latestversion', '5.10.4'),
('expirationdate', '0'),
('lastlicensecheck', '1540657841'),
('export_excelsecurity', '1'),
('pluginNeedUpdate', ''),
('gdpr_export', '0'),
('anonymous_tracking', '0'),
('anonymizeold', '0'),
('last_maxexec_check', '1528310013');

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE `#__acymailing_fields` (
  `fieldid` smallint(5) UNSIGNED NOT NULL,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` smallint(5) UNSIGNED DEFAULT '99',
  `options` text,
  `core` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `required` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `backend` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `frontcomp` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `default` text,
  `listing` tinyint(3) UNSIGNED DEFAULT NULL,
  `frontlisting` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaregistration` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `joomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT '0',
  `listingfilter` tinyint(4) DEFAULT NULL,
  `frontlistingfilter` tinyint(4) DEFAULT NULL,
  `frontform` tinyint(4) DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_fields` VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 0, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, '1', 1, 0, 0, 0, 0, 'all', 0, NULL, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE `#__acymailing_filter` (
  `filid` mediumint(8) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `lasttime` int(10) UNSIGNED DEFAULT NULL,
  `trigger` text,
  `report` text,
  `action` text,
  `filter` text,
  `daycron` int(10) UNSIGNED DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE `#__acymailing_forward` (
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE `#__acymailing_geolocation` (
  `geolocation_id` int(10) UNSIGNED NOT NULL,
  `geolocation_subid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE `#__acymailing_history` (
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text,
  `source` text,
  `mailid` mediumint(8) UNSIGNED DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_history` VALUES
(84, 1533238410, '127.0.0.1', 'created', '', 'HTTP_REFERER::http://localhost/home/ver_2_2/administrator/index.php\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:61.0) Gecko/20100101 Firefox/61.0\nHTTP_HOST::localhost\nSERVER_ADDR::127.0.0.1\nREMOTE_ADDR::127.0.0.1\nREQUEST_URI::/home/ver_2_2/administrator/index.php', 0);

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text,
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `listid` smallint(5) UNSIGNED NOT NULL,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_list` VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 120, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE `#__acymailing_listcampaign` (
  `campaignid` smallint(5) UNSIGNED NOT NULL,
  `listid` smallint(5) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE `#__acymailing_listmail` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE `#__acymailing_listsub` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `subdate` int(10) UNSIGNED DEFAULT NULL,
  `unsubdate` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_listsub` VALUES
(1, 1, 1390673568, NULL, 1),
(1, 34, 1457556659, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE `#__acymailing_mail` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subject` text,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT '1',
  `senddate` int(10) UNSIGNED DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action','article') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `tempid` smallint(6) NOT NULL DEFAULT '0',
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text,
  `sentby` int(10) UNSIGNED DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `filter` text,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `favicon` text,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `lastupdate` int(10) UNSIGNED DEFAULT NULL,
  `userlastupdate` int(10) UNSIGNED DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_mail` VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(5, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user has contacted you : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(6, 'A user confirm his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user has confirmed his subscription in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(7, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style=\"text-align: center; width: 100%; background-color: #ffffff;\">\r\n			<table style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" align=\"center\" bgcolor=\"#ebebeb\">\r\n			<tbody>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"38px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			<tr>\r\n			<td style=\"text-align:center\" width=\"600\">\r\n			<table style=\"margin:auto;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"520\">\r\n			<tbody>\r\n			<tr>\r\n			<td style=\"background-color: #ffffff; border: 1px solid #dbdbdb; padding: 20px; width: 500px; margin: 15px auto; text-align: left;\">\r\n			<h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style=\"text-align:center;\"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p>\r\n			</td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</td>\r\n			</tr>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"40px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, 1, 1, NULL, NULL, 'a:3:{s:6:\"action\";s:7:\"confirm\";s:13:\"actionbtntext\";s:28:\"{trans:CONFIRM_SUBSCRIPTION}\";s:9:\"actionurl\";s:19:\"{confirm}{/confirm}\";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(8, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(9, 'A Newsletter has been generated : \"{subject}\"', '<p>The Newsletter issue {issuenb} has been generated : </p><p>Subject : {subject}</p><p>{body}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_autonews', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(10, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(11, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(12, '{joomlacontent:current| type:title}', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n		<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width: 600px;\">\r\n			<tbody>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_2\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\" id=\"zone_3\"><img id=\"zone_29\" alt=\" - - - \" border=\"0\" src=\"http://localhost/home/ver_2_1//media/com_acymailing/templates/newsletter-4/images/top.png\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_4\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_5\"></td>\r\n					<td class=\"w520 acyeditor_text\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: #ebebeb;\" width=\"520\" id=\"zone_6\"><strong>​</strong>​​​​​​​​<img alt=\"-\" border=\"0\" src=\"http://localhost/home/ver_2_1//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float: left; margin-right: 10px;\">\r\n						<h3>{joomlacontent:current| type:title}<span style=\"display: none;\">&nbsp;</span></h3>\r\n					</td>\r\n					<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_7\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_8\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_9\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_10\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_11\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_12\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_13\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_14\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_15\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_16\"></td>\r\n					<td class=\"w480 pict acyeditor_text\" style=\"background-color: #fff; text-align: left;\" width=\"480\" id=\"zone_17\">{joomlacontent:current| type:intro| format:TOP_LEFT| pict:1| link}</td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_18\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_19\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_20\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_21\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_22\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_23\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_24\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_25\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_26\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #ebebeb;\" width=\"600\" id=\"zone_27\"><img id=\"zone_31\" alt=\" - - - \" border=\"0\" src=\"http://localhost/home/ver_2_1//media/com_acymailing/templates/newsletter-4/images/bottom.png\"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'article', 0, NULL, 'send-in-article', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL);

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE `#__acymailing_queue` (
  `senddate` int(10) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `priority` tinyint(3) UNSIGNED DEFAULT '3',
  `try` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `paramqueue` varchar(250) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE `#__acymailing_rules` (
  `ruleid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE `#__acymailing_stats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `senthtml` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senttext` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senddate` int(10) UNSIGNED NOT NULL,
  `openunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `opentotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `bounceunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `fail` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `clicktotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `clickunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `unsub` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `forward` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `bouncedetails` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE `#__acymailing_subscriber` (
  `subid` int(10) UNSIGNED NOT NULL,
  `email` varchar(200) NOT NULL,
  `userid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `accept` tinyint(4) NOT NULL DEFAULT '1',
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastclick_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastsent_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(250) NOT NULL DEFAULT '',
  `filterflags` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE `#__acymailing_tag` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE `#__acymailing_tagmail` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE `#__acymailing_template` (
  `tempid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `body` longtext,
  `altbody` longtext,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `premium` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `namekey` varchar(50) NOT NULL,
  `styles` text,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT '',
  `header` longtext
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_template` VALUES
(1, 'Notification template', '', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:\"tag_h1\";s:76:\"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;\";s:6:\"tag_h2\";s:106:\"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;\";s:6:\"tag_h3\";s:144:\"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;\";s:6:\"tag_h4\";s:117:\"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;\";s:5:\"tag_a\";s:71:\"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;\";s:19:\"acymailing_readmore\";s:90:\"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;\";s:17:\"acymailing_online\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:16:\"acymailing_unsub\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:8:\"color_bg\";s:7:\"#ffffff\";s:18:\"acymailing_content\";s:19:\"text-align:justify;\";}', NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (max-width:450px){\r\n	table[class=w600], td[class=w600],  table[class=w520], td[class=w520], table[class=w480], td[class=w480], img[class=w600]{ width:100% !important; }\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.pict img {max-width:240px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:450px) and (max-width:600px){\r\n	table[class=w600], td[class=w600],  table[class=w520], td[class=w520], table[class=w480], td[class=w480], img[class=w600]{ width:100% !important; }\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.pict img {max-width:390px;  height:auto !important;}\r\n}\r\n@media (min-width:600px){\r\n	body {width:600px !important; margin:auto !important;}\r\n	.pict img {max-width:480px !important;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', '', NULL),
(2, 'Newspaper', '', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n		<tr>\r\n			<td class=\"w600\">\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n					<tr class=\"acyeditor_delete\" >\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n						<h1><img alt=\"logo\" src=\"media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n						<h1>Your title here</h1>\r\n\r\n						<h3>your subtitle</h3>\r\n						</td>\r\n						<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text  pict w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n						<h2>Interviews and reports</h2>\r\n						<span class=\"dark\">Lorem ipsum dolor sit amet, consectLorem ipsum dolor sit amet.</span><br />\r\n						consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.ed elementum convallis mi. <a href=\"#\">Vivamus elementum</a>.Lorem ipsum dolor sit amet.<br />\r\n						<br />\r\n						cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.<br />\r\n						<br />\r\n						<span class=\"acymailing_readmore\">Read More</span><br />\r\n						&nbsp;\r\n						<h2>Journalism around the world</h2>\r\n						<span class=\"dark\">Lorem ipsum dolor sit amet, consectLorem. consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum.</span> consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.ed elementum convallis mi.<br />\r\n						Vivamus elementum.<a href=\"#\">Lorem ipsum dolor</a> sit amet.Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br />\r\n						<br />\r\n						<span class=\"acymailing_readmore\">Read More</span></td>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n					</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:\"tag_h1\";s:71:\"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;\";s:6:\"tag_h2\";s:145:\"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;\";s:6:\"tag_h3\";s:76:\"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;\";s:6:\"tag_h4\";s:67:\"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#9d0000; text-decoration:none; border:none;\";s:19:\"acymailing_readmore\";s:152:\"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;\";s:17:\"acymailing_online\";s:148:\"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;\";s:8:\"color_bg\";s:7:\"#454545\";s:18:\"acymailing_content\";s:0:\"\";s:16:\"acymailing_unsub\";s:131:\"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px\";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (max-width:450px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=w600]{ width:100% !important; }\r\n	td[class=w30] { width:20px !important; }\r\n	.pict img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width: 450px) and (max-width: 600px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=w600] { width:100% !important; }\r\n	td[class=w30] { width:20px !important; }\r\n	.pict img {max-width:410px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	body {width:600px !important; margin:auto !important;}\r\n	.pict img {max-width:540px !important;  height:auto !important;}\r\n}', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', '', NULL),
(3, 'Build Bio', '', '<div align=\"center\" style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#575757;\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr>\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\" width=\"600\"><img alt=\"mail\" class=\"w600\" height=\"41\" src=\"media/com_acymailing/templates/newsletter-6/images/header.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_picture w540 pict\" style=\"line-height:0px; background-color:#ffffff; text-align:center\" width=\"540\"><img alt=\"\" src=\"media/com_acymailing/templates/newsletter-6/images/banner.png\" style=\"width: 540px; height: 122px;\" /></td>\r\n					<td class=\"w30\" height=\"122\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text w540\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\" width=\"540\"><span class=\"hide\">Newsletter</span> {date:3}</td>\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w600\" colspan=\"3\" height=\"25\" style=\"background-color:#ffffff\" width=\"600\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text pict w540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\" width=\"540\"><span class=\"intro\">Hello {subtag:name},</span><br />\r\n					<br />\r\n					Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum Vivamus elementum. sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi.\r\n					<h2>Day One</h2>\r\n					<strong>Lorem ipsum dolor sit amet, consectLorem ipsum dolor sit amet.</strong><br />\r\n					consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed <a href=\"#\">elementum convallis</a> mi. Vivamus elementum.ed elementum convallis mi. Vivamus elementum.Lorem ipsum dolor sit amet.<br />\r\n					<br />\r\n					cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span>\r\n\r\n					<h2>How to build a green house</h2>\r\n					<img alt=\"picture\" height=\"160\" src=\"media/com_acymailing/templates/newsletter-6/images/picture.png\" style=\"float:left;\" width=\"193\" /> <strong>Lorem ipsum dolor sit amet, elit.</strong> Aenean sollicitudin orci sit amet . Sed <a href=\"#\">elementum convallis</a> mi. Vivamus elementum.ed elementum convallis mi. Vivamus elementum.Lorem ipsum dolor sit amet.<br />\r\n					<br />\r\n					cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span></td>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#efefef;\" valign=\"top\" width=\"600\"><img alt=\"--\" class=\"w600\" height=\"18\" src=\"media/com_acymailing/templates/newsletter-6/images/footer1.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n					<td class=\"acyfooter acyeditor_text w540\" style=\"text-align:right; background-color:#efefef; color:#575757;\" width=\"540\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">Contact</a><a href=\"#\"><img alt=\"message\" class=\"hide\" src=\"media/com_acymailing/templates/newsletter-6/images/mail.png\" style=\"border: medium none; width: 35px; height: 20px;\" /></a></td>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"background-color:#efefef; line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"--\" class=\"w600\" height=\"24\" src=\"media/com_acymailing/templates/newsletter-6/images/footer2.png\" width=\"600\" /></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\" >{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:\"tag_h1\";s:69:\"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;\";s:6:\"tag_h2\";s:129:\"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;\";s:6:\"tag_h3\";s:149:\"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;\";s:6:\"tag_h4\";s:84:\"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;\";s:8:\"color_bg\";s:7:\"#3c3c3c\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#a2b500; text-decoration:none; border:none;\";s:17:\"acymailing_online\";s:91:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px\";s:16:\"acymailing_unsub\";s:88:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px\";s:19:\"acymailing_readmore\";s:73:\"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;\";}', NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (max-width: 450px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=w600]{ width:100% !important; }\r\n	table[class=w30], td[class=w30]{ width:20px !important; }\r\n	.pict img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width: 450px) and (max-width: 600px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=w600]{ width:100% !important; }\r\n	table[class=w30], td[class=w30]{ width:20px !important; }\r\n	.pict img {max-width:410px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	body {width:600px !important; margin:auto !important;}\r\n	.pict img {max-width:540px !important;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', '', NULL),
(4, 'Technology', '', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540 pict\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Fresh and technologic news !</h1>\r\n\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent auctor.</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" class=\"w540\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540 pict\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Choose your smartphone</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec<a href=\"#\"> scelerisque quam</a>. Lore uctor posum ipsum dolor sit amesent auctor.<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Choose your device</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent auctor.<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" class=\"w540\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540 pict\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 4, 'technology_resp', 'a:9:{s:6:\"tag_h1\";s:104:\"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;\";s:6:\"tag_h2\";s:165:\"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;\";s:6:\"tag_h3\";s:104:\"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;\";s:6:\"tag_h4\";s:0:\"\";s:8:\"color_bg\";s:7:\"#575757\";s:5:\"tag_a\";s:62:\"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;\";s:17:\"acymailing_online\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:16:\"acymailing_unsub\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:19:\"acymailing_readmore\";s:88:\"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;\";}', NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (max-width:450px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=\"w600\"], img[class=\"w540\"]{ width:100% !important;}\r\n	td[class=w30] { width:20px !important;}\r\n	.pict img {max-width:260px}\r\n}\r\n\r\n@media (min-width: 450px) and (max-width: 600px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=\"w600\"], img[class=\"w540\"]{ width:100% !important;}\r\n	td[class=w30] { width:20px !important;}\r\n	.pict img {max-width:460px}\r\n}\r\n\r\n@media (min-width:600px){\r\n	body {width:600px !important; margin:auto !important;}\r\n	.pict img {max-width:540px !important;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '', NULL);

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE `#__acymailing_url` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE `#__acymailing_urlclick` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `click` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE `#__acymailing_userstats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `html` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `sent` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `senddate` int(10) UNSIGNED NOT NULL,
  `open` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT '0',
  `fail` tinyint(4) NOT NULL DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) UNSIGNED DEFAULT NULL,
  `is_mobile` tinyint(3) UNSIGNED DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__assets` VALUES
(1, 0, 1, 245, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 12, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 13, 14, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 15, 16, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 17, 18, 1, 'com_config', 'com_config', '{}'),
(7, 1, 19, 22, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(8, 1, 23, 26, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 27, 28, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 29, 30, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 31, 32, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 33, 34, 1, 'com_login', 'com_login', '{}'),
(13, 1, 35, 36, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 37, 38, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 39, 40, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 41, 42, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 43, 44, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 45, 162, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 163, 166, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(20, 1, 167, 168, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 169, 170, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 171, 172, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 173, 174, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 175, 178, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(25, 1, 179, 182, 1, 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(26, 1, 183, 184, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 24, 25, 2, 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(29, 7, 20, 21, 2, 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(30, 19, 164, 165, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(31, 25, 180, 181, 2, 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(32, 24, 176, 177, 1, 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(33, 1, 185, 186, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 187, 188, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(35, 1, 189, 190, 1, 'com_virtuemart', 'virtuemart', '{}'),
(36, 1, 191, 192, 1, 'com_virtuemart_allinone', 'virtuemart_allinone', '{}'),
(37, 1, 193, 194, 1, 'com_comparelist', 'comparelist', '{}'),
(38, 1, 195, 196, 1, 'com_wishlists', 'wishlists', '{}'),
(39, 3, 6, 7, 2, 'com_banners.category.8', 'Top banners', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(40, 3, 8, 9, 2, 'com_banners.category.9', 'Bottom banners', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(41, 1, 197, 198, 1, 'com_acymailing', 'acymailing', '{}'),
(42, 1, 199, 200, 1, 'com_k2', 'com_k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(43, 3, 10, 11, 2, 'com_banners.category.10', 'Sidebar banner', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(46, 1, 201, 202, 1, 'com_uniterevolution2', 'com_uniterevolution2', '{\"revolution2.slidersetting\":{\"7\":1},\"revolution2.slideroperations\":{\"7\":1},\"revolution2.slideoperations\":{\"7\":1},\"revolution2.editslide\":{\"7\":1} }'),
(47, 1, 203, 204, 1, 'com_rokcandy.category.11', 'Basic', ''),
(48, 1, 205, 206, 1, 'com_rokcandy.category.12', 'Typography', ''),
(49, 1, 207, 208, 1, 'com_rokcandy.category.13', 'Uncategorised', ''),
(52, 1, 209, 210, 1, 'com_smartslider2', 'smartslider2', '{}'),
(53, 1, 211, 212, 1, 'com_nextend_installer', 'nextend_installer', '{}'),
(57, 18, 46, 47, 2, 'com_modules.module.112', 'Contact Us', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(59, 18, 48, 49, 2, 'com_modules.module.97', 'Top menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(60, 18, 50, 51, 2, 'com_modules.module.100', 'Language Switcher', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(62, 18, 52, 53, 2, 'com_modules.module.95', 'Top Login', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(66, 18, 54, 55, 2, 'com_modules.module.172', 'Curency', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(67, 18, 56, 57, 2, 'com_modules.module.173', 'VirtueMart Shopping Cart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(69, 18, 58, 59, 2, 'com_modules.module.175', 'Featured Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(71, 18, 60, 61, 2, 'com_modules.module.127', 'Categories', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(74, 18, 62, 63, 2, 'com_modules.module.179', 'SP VirtueMart Category Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(75, 18, 64, 65, 2, 'com_modules.module.103', 'Wishlist Top', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(76, 18, 66, 67, 2, 'com_modules.module.102', 'Compare Header', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(77, 18, 68, 69, 2, 'com_modules.module.180', 'New Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(78, 18, 70, 71, 2, 'com_modules.module.181', 'Tags Cloud', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(79, 1, 213, 214, 1, 'com_cooltags', 'com_cooltags', '{}'),
(80, 18, 72, 73, 2, 'com_modules.module.182', 'Random Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(81, 18, 74, 75, 2, 'com_modules.module.183', 'Brands', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(82, 18, 76, 77, 2, 'com_modules.module.128', 'Compare Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(83, 18, 78, 79, 2, 'com_modules.module.129', 'Wishlist Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(85, 18, 80, 81, 2, 'com_modules.module.184', 'Bestsellers', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(86, 18, 82, 83, 2, 'com_modules.module.185', 'Specials', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(87, 18, 84, 85, 2, 'com_modules.module.137', 'Latest News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(88, 18, 86, 87, 2, 'com_modules.module.186', 'Custom HTML Bottom', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(89, 18, 88, 89, 2, 'com_modules.module.187', 'ITPFacebookLikeBox', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(91, 18, 90, 91, 2, 'com_modules.module.189', 'From Twitter', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(92, 18, 92, 93, 2, 'com_modules.module.190', 'Custom HTML top', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(93, 18, 94, 95, 2, 'com_modules.module.191', 'Contact Information', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(94, 18, 96, 97, 2, 'com_modules.module.141', 'Unite Revolution Slider', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(96, 1, 215, 216, 1, 'com_jcomments', 'jcomments', '{}'),
(97, 18, 98, 99, 2, 'com_modules.module.140', 'Breadcrumbs', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(98, 1, 217, 218, 1, 'com_tags', 'com_tags', '{}'),
(99, 1, 219, 220, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(100, 1, 221, 222, 1, 'com_ajax', 'com_ajax', '{}'),
(101, 1, 223, 224, 1, 'com_postinstall', 'com_postinstall', '{}'),
(102, 18, 100, 101, 2, 'com_modules.module.192', 'Megamenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(103, 18, 102, 103, 2, 'com_modules.module.193', 'Custom HTML Megamenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(104, 18, 104, 105, 2, 'com_modules.module.194', 'Filter', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(105, 1, 225, 226, 1, 'com_jmsmultiupload', 'jmsmultiupload', '{}'),
(106, 18, 106, 107, 2, 'com_modules.module.195', 'Latest Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(107, 18, 108, 109, 2, 'com_modules.module.101', 'Display all products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(109, 18, 110, 111, 2, 'com_modules.module.134', 'Deals of the day!', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(110, 18, 112, 113, 2, 'com_modules.module.197', 'Latest Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(111, 1, 227, 228, 1, 'com_bdthemes_shortcodes', 'bdthemes_shortcodes', '{}'),
(112, 18, 114, 115, 2, 'com_modules.module.143', 'JS Cookie Alert', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(113, 18, 116, 117, 2, 'com_modules.module.198', 'JS Cookie Alert Rus', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(114, 18, 118, 119, 2, 'com_modules.module.199', 'Tabs products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(115, 18, 120, 121, 2, 'com_modules.module.200', 'Custom HTML Bottom', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(116, 18, 122, 123, 2, 'com_modules.module.201', 'Module youtube video', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(117, 18, 124, 125, 2, 'com_modules.module.202', 'Unite Revolution Slider Wide', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(118, 18, 126, 127, 2, 'com_modules.module.203', 'Module Parallax', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(119, 18, 128, 129, 2, 'com_modules.module.204', 'Custom HTMl Full Width', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(120, 18, 130, 131, 2, 'com_modules.module.205', 'The Service', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(121, 18, 132, 133, 2, 'com_modules.module.151', 'Newsletter sign up', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(122, 18, 134, 135, 2, 'com_modules.module.206', 'Stay connected', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(123, 18, 136, 137, 2, 'com_modules.module.207', 'Categories', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(124, 18, 138, 139, 2, 'com_modules.module.208', 'Brands', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(125, 18, 140, 141, 2, 'com_modules.module.209', 'VirtueMart Search Product Velokorodnov', ''),
(126, 18, 142, 143, 2, 'com_modules.module.117', 'Newsletter popup', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(127, 18, 144, 145, 2, 'com_modules.module.210', 'Genius Virtuemart Ajax Search - VM3 Edition - Deluxe', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(128, 18, 146, 147, 2, 'com_modules.module.211', 'IsotopeMart layout for VirtueMart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(129, 1, 229, 230, 1, 'com_tcpdf', 'tcpdf', '{}'),
(131, 18, 148, 149, 2, 'com_modules.module.212', 'Contact Information', '{}'),
(132, 1, 231, 232, 1, 'com_fields', 'com_fields', '{}'),
(133, 1, 233, 234, 1, 'com_associations', 'com_associations', '{}'),
(134, 18, 150, 151, 2, 'com_modules.module.213', 'Donec ultricies', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(135, 18, 152, 153, 2, 'com_modules.module.214', 'Sed sapien sap', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(136, 18, 154, 155, 2, 'com_modules.module.215', 'Vestibulum faucibus', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(137, 1, 235, 236, 1, 'com_jch_optimize', 'JCH Optimize', '{}'),
(138, 1, 237, 238, 1, 'com_privacy', 'com_privacy', '{}'),
(139, 1, 239, 240, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(140, 1, 241, 244, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(141, 18, 156, 157, 2, 'com_modules.module.216', 'SP Page Builder', '{}'),
(142, 18, 158, 159, 2, 'com_modules.module.217', 'SP Page Builder', '{}'),
(143, 18, 160, 161, 2, 'com_modules.module.218', 'SP Page Builder Admin Menu', '{}'),
(144, 140, 242, 243, 2, 'com_sppagebuilder.page.1', 'Test Builder', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__associations` VALUES
(106, 'com_menus.item', 'fc4d7a56bcadbd3ed6230e704a1d980e'),
(107, 'com_menus.item', 'fc4d7a56bcadbd3ed6230e704a1d980e'),
(108, 'com_menus.item', 'fc4d7a56bcadbd3ed6230e704a1d980e'),
(109, 'com_menus.item', 'fc4d7a56bcadbd3ed6230e704a1d980e'),
(110, 'com_menus.item', 'fc4d7a56bcadbd3ed6230e704a1d980e');

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__banners` VALUES
(1, 0, 0, 'topban1', 'topban1', 0, 2392, 6, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 8, '', '', 0, 1, '', '{\"imageurl\":\"images\\/top_ban\\/top_ban1.png\",\"width\":360,\"height\":100,\"alt\":\"topban\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(2, 0, 0, 'topban2', 'topban2', 0, 2390, 5, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 8, '', '', 0, 2, '', '{\"imageurl\":\"images\\/top_ban\\/top_ban2.png\",\"width\":360,\"height\":100,\"alt\":\"topban\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(3, 0, 0, 'topban3', 'topban3', 0, 2390, 3, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 8, '', '', 0, 3, '', '{\"imageurl\":\"images\\/top_ban\\/top_ban3.png\",\"width\":360,\"height\":100,\"alt\":\"topban\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(4, 0, 0, 'botban1', 'botban1', 0, 1970, 1, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 9, '', '', 0, 4, '', '{\"imageurl\":\"images\\/bot_ban\\/bot_banner1.png\",\"width\":555,\"height\":220,\"alt\":\"botban\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(5, 0, 0, 'botban2', 'botban2', 0, 1970, 1, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 9, '', '', 0, 5, '', '{\"imageurl\":\"images\\/bot_ban\\/bot_banner2.png\",\"width\":555,\"height\":220,\"alt\":\"botban\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(6, 0, 0, 'Sidebar banner', 'sidebar-banner', 0, 3885, 1, 'http://themeforest.net/user/mad_velikorodnov/portfolio?WT.ac=item_portfolio&WT.seg_1=item_portfolio&WT.z_author=mad_velikorodnov', 1, 10, 'Sidebar banner', '', 0, 1, '', '{\"imageurl\":\"images\\/sidebar_ban\\/sidebar_ban.png\",\"width\":263,\"height\":262,\"alt\":\"Sidebar banner\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-06-21 21:16:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1);

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__categories` VALUES
(1, 0, 0, 0, 27, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 9, 10, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 39, 1, 13, 14, 1, 'top-banners', 'com_banners', 'Top banners', 'top-banners', '', 'Top banners', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 40, 1, 15, 16, 1, 'bottom-banners', 'com_banners', 'Bottom banners', 'bottom-banners', '', 'Bottom banners', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '2019-06-21 21:16:05', 0, '*', 1),
(10, 43, 1, 17, 18, 1, 'sidebar-banner', 'com_banners', 'Sidebar banner', 'sidebar-banner', '', 'Sidebar banner', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-06-21 21:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__contact_details` VALUES
(1, 'Contacts', 'contacts', '', 'Address: 123 Bajron Street\r\nNew York, NY 55555, 123 Bajron Street', '', '', '', '', 'Telephone: 444-223-555-555', 'Fax: 444-213-553-444', '', '', 'mad_caesar@bk.ru', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"0\",\"show_name\":\"0\",\"show_position\":\"0\",\"show_email\":\"0\",\"show_street_address\":\"0\",\"show_suburb\":\"0\",\"show_state\":\"0\",\"show_postcode\":\"0\",\"show_country\":\"0\",\"show_telephone\":\"0\",\"show_mobile\":\"0\",\"show_fax\":\"0\",\"show_webpage\":\"0\",\"show_misc\":\"0\",\"show_image\":\"0\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 4, 1, '', 'http://themeforest.net/user/mad_velikorodnov', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 51),
(2, 'demo', 'demo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oleg-dracon@mail.ru', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 860, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '0000-00-00 00:00:00', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(3, 'demo2', 'demo2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo2@demo2.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 861, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '0000-00-00 00:00:00', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'demo3', 'demo3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo3@demo3.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 862, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '0000-00-00 00:00:00', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(5, 'demo4', 'demo4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo4@demo4.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 863, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '0000-00-00 00:00:00', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'demo5', 'demo5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo5@demo5.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 864, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '0000-00-00 00:00:00', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(7, 'demo (2)', 'demo-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo@demo.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 504, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'afe', 'afe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'qqq@qqq.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 505, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(9, 'demon demon', 'demon-demon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demon@demon.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 506, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(10, 'demo (3)', 'demo-3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'demo@demo.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 507, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(11, 'test', 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 560, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(12, 'test (2)', 'test-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 561, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(13, 'sergii', 'sergii', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 562, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(14, 'test (3)', 'test-3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 563, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(15, 'test (4)', 'test-4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 564, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(16, 'Username', 'username', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'www@ww.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 565, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(17, 'www', 'www', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'www@ww.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 566, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(18, 'test (5)', 'test-5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'test@test.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 567, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(19, 'www (2)', 'www-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'www@ww.com', 0, 0, 0, '0000-00-00 00:00:00', 0, '', 568, 34, 1, '', '', '', '', '', '*', '2019-06-21 21:16:05', 0, '', '2019-06-21 21:16:05', 0, '', '', '', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_types` VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"url\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {}}', 'WeblinksHelperRoute::getWeblinkRoute', '{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(3, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(5, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\": {}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'WeblinksHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10000, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10001, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10002, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(10003, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10004, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__extensions` VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 801, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"0\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"debugUsers\":\"1\",\"debugGroups\":\"1\",\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"updatesource\":\"sts\",\"customurl\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 0, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"simplepie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"3027429891a392f651d7f14f5884bd21\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 801, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_weblinks\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 0, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2019\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"4.5.11\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 801, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":\"0\",\"automatic_change\":\"0\",\"menu_associations\":\"1\",\"remove_default_prefix\":\"0\",\"lang_cookie\":\"1\",\"alternate_meta\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 26, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 27, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 41, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 29, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 30, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 31, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 33, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 34, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 28, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 36, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"version\":\"2.0\",\"public_key\":\"11\",\"private_key\":\"11\",\"theme\":\"clean\",\"theme2\":\"light\",\"size\":\"normal\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 32, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 801, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1571737320}', '', '', 0, '0000-00-00 00:00:00', 14, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"c75dffc1a1d6086168b73bdf92683f0522ee16af\",\"interval\":12}', '', '', 0, '0000-00-00 00:00:00', 12, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 21, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1571686318}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(500, 0, 'atomic', 'template', 'atomic', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(502, 0, 'bluestork', 'template', 'bluestork', '', 1, 1, 1, 0, '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez_20', 'template', 'beez_20', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(505, 0, 'beez5', 'template', 'beez5', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 0, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.12\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 0, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.12\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.12\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(801, 0, 'pkg_weblinks', 'package', 'pkg_weblinks', '', 0, 1, 1, 0, '{\"name\":\"pkg_weblinks\",\"type\":\"package\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PKG_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pkg_weblinks\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10000, 0, 'VIRTUEMART', 'component', 'com_virtuemart', '', 1, 1, 0, 0, '{\"name\":\"VIRTUEMART\",\"type\":\"component\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"\",\"group\":\"\",\"filename\":\"virtuemart\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'VirtueMart_allinone', 'component', 'com_virtuemart_allinone', '', 1, 1, 0, 0, '{\"name\":\"VirtueMart_allinone\",\"type\":\"component\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 0, 'Standard', 'plugin', 'standard', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Standard\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"Standard payment plugin\",\"group\":\"\",\"filename\":\"standard\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10003, 0, 'Klarna', 'plugin', 'klarna', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"Klarna VirtueMart Payment Plugin\",\"group\":\"\",\"filename\":\"klarna\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10004, 0, 'KlarnaCheckout', 'plugin', 'klarnacheckout', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"\",\"group\":\"\",\"filename\":\"klarnacheckout\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10005, 0, 'Sofort Banking/Überweisung', 'plugin', 'sofort', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Sofort\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10006, 0, 'PayPal', 'plugin', 'paypal', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"PayPal\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"PayPal\",\"group\":\"\",\"filename\":\"paypal\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 0, 'Heidelpay', 'plugin', 'heidelpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Heidelpay\",\"type\":\"plugin\",\"creationDate\":\"12-Sep-2012\",\"author\":\"Heidelberger Payment GmbH\",\"copyright\":\"Copyright Heidelberger Payment GmbH\",\"authorEmail\":\"info@heidelpay.de\",\"authorUrl\":\"http:\\/\\/www.heidelpay.de\",\"version\":\"16.11.07\",\"description\":\"\\n        <h2>Virtuemart Plugin von:<\\/h2><p><a href=\\\"https:\\/\\/www.Heidelpay.de\\\" target=\\\"_blank\\\"><img src=\\\"https:\\/\\/www.heidelpay.de\\/gfx\\/logo.gif\\\" style=\\\"margin-right:20px;\\\"\\/><\\/a><\\/p> \",\"group\":\"\",\"filename\":\"heidelpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10017, 0, 'Authorize.net', 'plugin', 'authorizenet', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Authorize.net AIM\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"Authorize.net AIM\",\"group\":\"\",\"filename\":\"authorizenet\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10018, 0, 'Sofort iDeal', 'plugin', 'sofort_ideal', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Sofort Ideal\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10019, 0, 'By weight, ZIP and countries', 'plugin', 'weight_countries', 'vmshipment', 0, 1, 1, 0, '{\"name\":\"By weight, ZIP and countries\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"VMSHIPMENT_WEIGHT_COUNTRIES_PLUGIN_DESC\",\"group\":\"\",\"filename\":\"weight_countries\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'Customer text input', 'plugin', 'textinput', 'vmcustom', 0, 0, 1, 0, '{\"name\":\"VMCustom - textinput\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"text input plugin for product\",\"group\":\"\",\"filename\":\"textinput\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'Product specification', 'plugin', 'specification', 'vmcustom', 0, 0, 1, 0, '{\"name\":\"plgvm_specification\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"VMCustom - specification; text input plugin for product\",\"group\":\"\",\"filename\":\"specification\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'Stockable', 'plugin', 'stockable', 'vmcustom', 0, 0, 1, 0, '{\"legacy\":true,\"name\":\"Stockable\",\"type\":\"plugin\",\"creationDate\":\"April 07 2014\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.6.0\",\"description\":\"VMCUSTOM_STOCKABLE_DESC\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 0, 'Avalara Tax', 'plugin', 'avalara', 'vmcalculation', 0, 0, 1, 0, '{\"name\":\"VM - Calculation Avalara Tax\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"Max Milbers\",\"copyright\":\"Copyright (C) 2013 - 2019 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"VM - Calculation Avalara Tax; On demand tax calculation for whole U.S.A.\",\"group\":\"\",\"filename\":\"avalara\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 0, 'plg_search_virtuemart', 'plugin', 'virtuemart', 'search', 0, 1, 1, 0, '{\"name\":\"Search - VirtueMart\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"PLG_SEARCH_VIRTUEMART_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"virtuemart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10025, 0, 'mod_virtuemart_currencies', 'module', 'mod_virtuemart_currencies', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_currencies\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_CURRENCIES_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_currencies\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10026, 0, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_product\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_PRODUCT_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_product\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10027, 0, 'mod_virtuemart_search', 'module', 'mod_virtuemart_search', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_search\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_SEARCH_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10028, 0, 'mod_virtuemart_manufacturer', 'module', 'mod_virtuemart_manufacturer', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_manufacturer\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_MANUFACTURER_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_manufacturer\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10029, 0, 'VirtueMart Shopping Cart', 'module', 'mod_virtuemart_cart', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_cart\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_CART_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_cart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10030, 0, 'mod_virtuemart_category', 'module', 'mod_virtuemart_category', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_category\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VIRTUEMART_CATEGORY_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10031, 0, 'comparelist', 'component', 'com_comparelist', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"Comparelist\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2011 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"1.0.0\",\"description\":\"Component Compare products\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 0, 'mod_comparelist', 'module', 'mod_comparelist', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"mod_comparelist\",\"type\":\"module\",\"creationDate\":\"November 2010\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"mod_comparelist\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 0, 'mod_wishlist', 'module', 'mod_wishlist', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"mod_wishlist\",\"type\":\"module\",\"creationDate\":\"November 2010\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"mod_wishlist\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10034, 0, 'YJ Pop Login', 'module', 'mod_yj_pop_login', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"YJ Pop Login\",\"type\":\"module\",\"creationDate\":\"12-19-2011\",\"author\":\"Youjoomla\",\"copyright\":\"Youjoomla LLC.\",\"authorEmail\":\"youjoomla@gmail.com\",\"authorUrl\":\"www.youjoomla.com\",\"version\":\"1.0.1\",\"description\":\"\\n\\t\\t<style type=\\\"text\\/css\\\" media=\\\"all\\\">#wrap1 {padding:0px 0px 4px 0px;}h1 {clear:both;font-family: Arial Narrow,sans-serif;font-size:18px;margin:0px 0px 12px 0px;padding:0px 0px 1px 10px;color:#C64934;}.wrap2 {background:#F7F7F7;display:block;overflow:hidden;padding:15px;}<\\/style><div id=\\\"holdthem\\\"><h1>YJ Pop Login Module for Joomla 1.6x and UP<\\/h1><br \\/><div class=\\\"wrap2\\\"><a title=\\\"Visit the official website!\\\" href=\\\"http:\\/\\/www.youjoomla.com\\\"> <img style=\\\"float:left;border:1px solid #CFCFCF;margin:0px 15px 4px 22px;\\\" src=\\\"..\\/modules\\/mod_yj_pop_login\\/images\\/yj_extensions.jpg\\\" border=\\\"0\\\" alt=\\\"Logo\\\" \\/><\\/a>\\n\\t\",\"group\":\"\"}', '{\"cache\":\"1\",\"@spacer\":\"\",\"moduleclass_sfx\":\"\",\"pretext\":\"Welcome,Guest <br \\/> <br \\/><span> Please login or register<\\/span>\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10035, 10269, 'T3 Framework', 'plugin', 't3', 'system', 0, 1, 1, 0, '{\"name\":\"T3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Oct 21, 2019\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.7.5\",\"description\":\"\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2019 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"t3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 13, 0),
(10036, 0, 'plg_system_vm2_cart', 'plugin', 'vm2_cart', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_vm2_cart\",\"type\":\"plugin\",\"creationDate\":\"March 2012\",\"author\":\"xxx\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.1\",\"description\":\"Plg System VM2Cart\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 16, 0),
(10037, 0, 'wishlists', 'plugin', 'wishlists', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"wishlists\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"olejenya\",\"copyright\":\"\",\"authorEmail\":\"oleg@oleg.com\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_WISHLISTS_DESC\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10038, 10269, 't3_bs3_blank', 'template', 't3_bs3_blank', '', 0, 1, 1, 0, '{\"name\":\"t3_bs3_blank\",\"type\":\"template\",\"creationDate\":\"Sep 06 2017\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.2.7\",\"description\":\"\\n\\t\\t\\n\\t\\t<div align=\\\"center\\\">\\n\\t\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t\\t\\t<p> <\\/p>\\n\\t\\t\\t\\t<span style=\\\"color:#FF0000\\\">Note: T3 blank requires T3 plugin to be installed and enabled.<\\/span><p><\\/p>\\n\\t\\t\\t\\t<p>Copyright 2004 - 2017 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<style>table.adminform{width: 100%;}<\\/style>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10039, 0, 'wishlists', 'component', 'com_wishlists', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"Wishlists\",\"type\":\"component\",\"creationDate\":\"2007-02-22\",\"author\":\"John Doe\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"john.doe@example.org\",\"authorUrl\":\"http:\\/\\/www.example.org\",\"version\":\"0.01\",\"description\":\"Description of the Wishlists ...\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'GermanDE-CH-AT', 'language', 'de-DE', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"27.04.2013\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.11.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Frontend (Website)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.11\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Frontend (Website) translation for Joomla! 2.5.11\\n    \",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10041, 0, 'TinyMCE de-DE', 'file', 'file_tinymce_de-DE', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE de-DE\",\"type\":\"file\",\"creationDate\":\"27.04.2013\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.11.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Editor (TinyMCE)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.11\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Editor (TinyMCE) translation for Joomla! 2.5.11\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10042, 0, 'GermanDE-CH-AT', 'language', 'de-DE', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"27.04.2013\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.11.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Backend (Administrator)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.11\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Backend (Administrator) translation for Joomla! 2.5.11\\n    \",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'de-DE', 'package', 'pkg_de-DE', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"German Language Pack\",\"type\":\"package\",\"creationDate\":\"27.04.2013\",\"author\":\"J!German\",\"copyright\":\"\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.11.1\",\"description\":\"\\n    <div style=\\\"text-align: center;\\\">\\n      <h2>Deutsches \\u201eFull\\u201c-Sprachpaket f\\u00fcr Joomla! 2.5.11 von <a title=\\\"J!German\\\" href=\\\"http:\\/\\/www.jgerman.de\\\" target=\\\"_blank\\\">J!German<\\/a><\\/h2>\\n      <h3><span style=\\\"color: #008000;\\\">\\u00dcbersetzungsversion: 2.5.11v1<\\/span><\\/h3>\\n      <hr \\/>\\n      <table rules=\\\"all\\\" frame=\\\"border\\\" style=\\\"width: 90%; border-color: #000000; border-width: 1px; border-style: solid;\\\" align=\\\"center\\\" border=\\\"1\\\">\\n      <colgroup> <col width=\\\"30%\\\" \\/> <col width=\\\"60\\\" \\/> <\\/colgroup>\\n      <tbody>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Frontend (Website)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td rowspan=\\\"2\\\">\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Legen Sie die deutsche Sprache unter <a title=\\\"Language Manager\\\" href=\\\"index.php?option=com_languages\\\" target=\\\"_blank\\\">\\u201eExtensions\\u201c \\u2192 \\u201eLanguage Manager\\u201c<\\/a> als Standardsprache (\\u201eDefault\\u201c), sowohl f\\u00fcr die Website (\\u201eInstalled - Site\\u201c) als auch f\\u00fcr die Administration (\\u201eInstalled - Administrator\\u201c), fest.\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung:<\\/span>\\n                <br \\/>\\n                Es sind keine weiteren Schritte erforderlich.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Backend (Administrator)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Editor (TinyMCE)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td>\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Aktivieren Sie in den <a title=\\\"TinyMCE in der Pluginverwaltung\\\" href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\" target=\\\"_blank\\\">TinyMCE-Plugineinstellungen<\\/a> die automatische Sprachauswahl auf \\u201eJa\\u201c (\\u201eBasisoptionen\\u201c \\u2192 \\u201eAutom. Sprachauswahl\\u201c).\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung (nur wenn vor dieser Installation ein <strong>separates<\\/strong> TinyMCE-Sprachpaket installiert war):<\\/span>\\n                <br \\/>\\n                Deinstallieren Sie das alte TinyMCE-Sprachpaket \\u00fcber \\u201eErweiterungen\\u201c \\u2192 \\u201eErweiterungen\\u201c \\u2192 \\u201eVerwalten\\u201c \\u2192 \\u201eTinyMCE de-DE\\u201c. Danach installieren Sie dieses Paket erneut.<br \\/>Damit sorgen Sie daf\\u00fcr, dass der alte Aktualisierungsserver f\\u00fcr das einzelne TinyMCE-Sprachpaket aus Joomla! gel\\u00f6scht wird und so bei einer Aktualisierungsanfrage nicht unn\\u00f6tig gepr\\u00fcft wird.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n      <\\/tbody>\\n      <\\/table>\\n      <br \\/>\\n      <span style=\\\"text-decoration: underline;\\\">Hinweis:<\\/span> Dieses Paket unterst\\u00fctzt die Joomla! eigene <a title=\\\"Joomla!-Aktualisierungsfunktion\\\" href=\\\"index.php?option=com_installer&amp;view=update\\\" target=\\\"_blank\\\">Aktualisierungsfunktion<\\/a>!\\n    <\\/div>\\n    \",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10044, 0, 'Frenchfr-FR', 'language', 'fr-FR', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"fr-FR site language\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10045, 0, 'Frenchfr-FR', 'language', 'fr-FR', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"fr-FR administrator language\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'TinyMCE langue FR', 'file', 'TinyMCE_fr-FR', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE langue FR\",\"type\":\"file\",\"creationDate\":\"4 feb 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"(C) 2005-2013 French Translation Team\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"3.5.4.1\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installation du pack de langue FR de TinyMCE 3.5.4.1 pour Joomla 2.5 effectu\\u00e9e avec succ\\u00e8s<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tN\'oubliez pas de s\\u00e9lectionner la langue FR dans la \\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestion du plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n \\t\\tSi vous utilisez la d\\u00e9tection automatique, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants \\n \\t\\t\\u00e0 ceux install\\u00e9s pour Joomla!<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 0, 'fr-FR', 'package', 'pkg_fr-FR', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"French Language Pack\",\"type\":\"package\",\"creationDate\":\"19 mar 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.11.1\",\"description\":\"\\n\\t\\t\\n\\t\\t<h3>Joomla! Full French (fr-FR) Language Package version 2.5.11v1<\\/h3>\\n\\t\\t<h3>Paquet de langue fran\\u00e7ais complet Joomla! fr-FR version 2.5.11v1<\\/h3>\\n\\t\\t<div>Installation inclue du pack de langue fr-FR de TinyMCE 3.5.4 pour Joomla 2.5.11<\\/div><br>\\n\\t\\t<div style=\\\"font-weight: normal; padding-bottom:15px;\\\">N\'oubliez pas de s\\u00e9lectionner la langue FR dans les <a href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\"><strong>param\\u00e8tres du plug-in \'\\u00c9diteur - TinyMCE\'<\\/strong><\\/a> (param\\u00e8tre  \'Langue de l\'\\u00e9diteur\' = fr).<br>\\n \\t\\tSi vous utilisez la <strong>d\\u00e9tection automatique<\\/strong>, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants aux packs de langue install\\u00e9s pour Joomla!<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10048, 0, 'ItalianIT', 'language', 'it-IT', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"Italian (IT)\",\"type\":\"language\",\"creationDate\":\"2013-04-26\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters and Joomla.it. All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.11.1\",\"description\":\"Italian site language pack for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 0, 'ItalianIT', 'language', 'it-IT', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"Italian (IT)\",\"type\":\"language\",\"creationDate\":\"2013-04-26\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters and Joomla.it. All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.11.1\",\"description\":\"Italian administration language pack for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 0, 'TinyMCE lingua IT', 'file', 'TinyMCE_it-IT', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE lingua IT\",\"type\":\"file\",\"creationDate\":\"20 giugno 2012\",\"author\":\"Italian translation team : joomla.it\",\"copyright\":\"(C) 2005-2012 Italian Translation Team\",\"authorEmail\":\"info@joomla.it\",\"authorUrl\":\"www.joomla.it\",\"version\":\"3.5.2\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installazione del pacchetto lingua per TinyMCE 3.5.2 per  Joomla 2.5 effettuato correttamente<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tNon dimenticare di selezionare la lingua IT nella\\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestione del plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10051, 0, 'it-IT', 'package', 'pkg_it-IT', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Italian Language Pack\",\"type\":\"package\",\"creationDate\":\"26 aprile 2013\",\"author\":\"Italian translation team : joomla.it\",\"copyright\":\"Copyright (C) 2005 - 2012 joomla.it e Open Source Matters. Tutti i diritti riservati\",\"authorEmail\":\"info@joomla.it\",\"authorUrl\":\"www.joomla.it\",\"version\":\"2.5.11.1\",\"description\":\"Joomla! 2.5 Full Italian (it-IT) Language Package - Version 2.5.11v1\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10052, 0, 'Russian', 'language', 'ru-RU', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"Russian\",\"type\":\"language\",\"creationDate\":\"2013-07-26\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"2.5.13.1\",\"description\":\"Russian language pack (site) for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10053, 0, 'Russian', 'language', 'ru-RU', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"Russian\",\"type\":\"language\",\"creationDate\":\"2013-07-26\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"2.5.13.1\",\"description\":\"Russian language pack (administrator) for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10054, 0, 'TinyMCE ru-RU', 'file', 'tinymce_ru-ru', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE ru-RU\",\"type\":\"file\",\"creationDate\":\"2012-06-19\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"3.5.2.1\",\"description\":\"Russian Language Package for TinyMCE 3.5.2.1 in Joomla 2.5\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10055, 0, 'ru-RU', 'package', 'pkg_ru-RU', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Russian Language Pack\",\"type\":\"package\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.13.1\",\"description\":\"Joomla 2.5 Russian Language Package\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10056, 0, 'com_virtuemart_it-IT', 'file', 'com_virtuemart_it-IT', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"com_virtuemart_it-IT\",\"type\":\"file\",\"creationDate\":\"December 21 2012\",\"author\":\"The VirtueMart Development and Translation Team\",\"copyright\":\"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.0.16\",\"description\":\"This it-IT language pack for VirtueMart has been installed successfully. It includes files for the component.ini, modules, and plugins. Some languages may not have all the files.\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10057, 0, 'com_virtuemart - ru-RU', 'file', 'com_virtuemart-ru-RU', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"com_virtuemart - ru-RU\",\"type\":\"file\",\"creationDate\":\"20.08.2013\",\"author\":\"VirtueMart language team\",\"copyright\":\"\\u00a9 2008-2013 - compojoom-com. All rights reserved!\",\"authorEmail\":\"max@virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"2013-08-20-01-19-20\",\"description\":\"\\n        This package was auto generated with CTransifex(https:\\/\\/compojoom.com). We\'ve grabbed the latest language files for our extension from transifex.com.\\n        Special thanks to OpenTranslators (http:\\/\\/opentranslators.org) for helping us with this translation!\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 0, 'Virtuemart2.0.x products', 'module', 'mod_vm2_products', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"Virtuemart2.0.x products\",\"type\":\"module\",\"creationDate\":\"Jyuly 2013\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"\",\"group\":\"\"}', '{\"feat\":\"1\",\"layout_feat\":\"layout\",\"featTitle\":\"Featured Products\",\"max_items_feat\":\"2\",\"products_per_row_feat\":\"1\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"1\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"1\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"1\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"featured_source\":\"\",\"featured_outsource\":\"\",\"class_sfx_feat\":\"feat\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10060, 0, 'quick', 'plugin', 'quick', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"quick\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\\u00a9 2014. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_QUICK_DESC\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10061, 0, 'PLG_SYSTEM_JQUERYEASY', 'plugin', 'jqueryeasy', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_JQUERYEASY\",\"type\":\"plugin\",\"creationDate\":\"2012-10-21\",\"author\":\"Olivier Buisard\",\"copyright\":\"Copyright (C) 2011 Simplify Your Web. All rights reserved.\",\"authorEmail\":\"olivier.buisard@simplifyyourweb.com\",\"authorUrl\":\"www.simplifyyourweb.com\",\"version\":\"2.2.4\",\"description\":\"PLG_SYSTEM_JQUERYEASY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"jqueryeasy\"}', '{\"jqueryinfrontend\":\"0\",\"jqueryversionfrontend\":\"1.9\",\"jquerysubversionfrontend\":\"\",\"localversionfrontend\":\"\",\"migrateversionfrontend\":\"none\",\"localpathmigratefrontend\":\"\",\"jqueryuiversionfrontend\":\"1.8\",\"jqueryuisubversionfrontend\":\"\",\"localuiversionfrontend\":\"\",\"jqueryuithemefrontend\":\"none\",\"jqueryuithemecustomfrontend\":\"\",\"whichhttpfrontend\":\"http\",\"compressionfrontend\":\"compressed\",\"templateid\":[\"none\"],\"enableonlyinfrontend\":\"\",\"disableinfrontend\":\"\",\"replacewhenuniquefrontend\":\"1\",\"addwhenmissingfrontend\":\"1\",\"ignorescriptsfrontend\":\"media\\/jui\\/js\\/chosen.jquery.min.js\",\"removenoconflictfrontend\":\"0\",\"addnoconflictfrontend\":\"0\",\"replacedocumentreadyfrontend\":\"0\",\"disablemootools\":\"0\",\"keepmootoolsin\":\"\",\"disablecaptions\":\"0\",\"stripremainingscriptsfrontend\":\"\\/components\\/com_virtuemart\\/assets\\/js\\/vmprices.js\",\"stripremainingcssfrontend\":\"\",\"addjavascriptfrontend\":\"\",\"addjavascriptdeclarationfrontend\":\"\",\"addcssfrontend\":\"\",\"addcssdeclarationfrontend\":\"\",\"removeblanklinesfrontend\":\"0\",\"back_compat_paths\":\"1\",\"showreport\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 38, 0),
(10062, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{\"name\":\"AcyMailing\",\"type\":\"component\",\"creationDate\":\"August 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"5.10.4\",\"description\":\"Manage your Mailing lists, Newsletters, e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acymailing_j3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10063, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"November 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10064, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"October 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10065, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10066, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 0, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"August 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10067, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10068, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"January 2011\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10069, 0, 'AcyMailing Tag : CB User information', 'plugin', 'tagcbuser', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.2\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10070, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10071, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10072, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10073, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10074, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10075, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 52, 0),
(10077, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10078, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10080, 0, 'COM_K2', 'component', 'com_k2', '', 1, 1, 0, 0, '{\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla\",\"group\":\"\",\"filename\":\"k2\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"0\",\"backendJQueryHandling\":\"remote\",\"userName\":\"0\",\"userImage\":\"0\",\"userDescription\":\"0\",\"userURL\":\"0\",\"userEmail\":\"0\",\"userFeedLink\":\"0\",\"userFeedIcon\":\"0\",\"userItemCount\":\"10\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"0\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"0\",\"userItemTags\":\"0\",\"userItemCommentsAnchor\":\"0\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"10\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"0\",\"tagItemDateCreated\":\"0\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"0\",\"tagItemReadMore\":\"0\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"0\",\"tagFeedIcon\":\"0\",\"genericItemCount\":\"10\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"0\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"0\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"0\",\"genericFeedLink\":\"0\",\"genericFeedIcon\":\"0\",\"feedLimit\":\"10\",\"feedItemImage\":\"0\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"0\",\"feedItemVideo\":\"0\",\"feedItemGallery\":\"0\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"100\",\"itemImageS\":\"200\",\"itemImageM\":\"350\",\"itemImageL\":\"600\",\"itemImageXL\":\"900\",\"itemImageGeneric\":\"300\",\"catImageWidth\":\"100\",\"catImageDefault\":\"1\",\"userImageWidth\":\"100\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"48\",\"onlineImageEditor\":\"splashup\",\"imageTimestamp\":\"0\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"\",\"facebookImage\":\"Medium\",\"comments\":\"1\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"6\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"1\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"1\",\"gravatar\":\"0\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"1\",\"akismetForRegistered\":\"1\",\"commentsFormNotes\":\"1\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"1\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"1\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"0\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"K2UserGroup\":\"1\",\"redirect\":\"164\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaOnRegistration\":\"0\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"0\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"0\",\"k2SefLabelItemCustomPrefix\":\"\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"dash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\",\"sh404SefLabelCat\":\"\",\"sh404SefLabelUser\":\"blog\",\"sh404SefLabelItem\":\"2\",\"sh404SefTitleAlias\":\"alias\",\"sh404SefModK2ContentFeedAlias\":\"feed\",\"sh404SefInsertItemId\":\"0\",\"sh404SefInsertUniqueItemId\":\"0\",\"cbIntegration\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10081, 0, 'plg_finder_k2', 'plugin', 'k2', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10082, 0, 'Search - K2', 'plugin', 'k2', 'search', 0, 1, 1, 0, '{\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\",\"filename\":\"k2\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10083, 0, 'System - K2', 'plugin', 'k2', 'system', 0, 1, 1, 0, '{\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10084, 0, 'User - K2', 'plugin', 'k2', 'user', 0, 1, 1, 0, '{\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10085, 0, 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', 0, 1, 1, 0, '{\"name\":\"Josetta - K2 Categories\",\"type\":\"plugin\",\"creationDate\":\"December 8th, 2014\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.9\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10086, 0, 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', 0, 1, 1, 0, '{\"name\":\"Josetta - K2 Items\",\"type\":\"plugin\",\"creationDate\":\"June 7th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.9\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10087, 0, 'K2 Comments', 'module', 'mod_k2_comments', '', 0, 1, 0, 0, '{\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_comments.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10088, 0, 'K2 Content', 'module', 'mod_k2_content', '', 0, 1, 0, 0, '{\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_content.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10089, 0, 'K2 Tools', 'module', 'mod_k2_tools', '', 0, 1, 0, 0, '{\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_TOOLS\",\"group\":\"\",\"filename\":\"mod_k2_tools.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10090, 0, 'K2 Users', 'module', 'mod_k2_users', '', 0, 1, 0, 0, '{\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\",\"filename\":\"mod_k2_users.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10091, 0, 'K2 User', 'module', 'mod_k2_user', '', 0, 1, 0, 0, '{\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_user.j25\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10092, 0, 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', 1, 1, 2, 0, '{\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_quickicons.j25\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10093, 0, 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', 1, 1, 2, 0, '{\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_stats.j25\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10100, 0, 'System - Virtuemart Slider', 'plugin', 'vmslider', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"System - Virtuemart Slider\",\"type\":\"plugin\",\"creationDate\":\"July, 2012\",\"author\":\"Lamvt (Lamvt19792003@gmail.com)\",\"copyright\":\"(C) http:\\/\\/joomquery.com All rights reserved.\",\"authorEmail\":\"lamvt19792003@gmail.com\",\"authorUrl\":\"http:\\/\\/joomquery.com\",\"version\":\"2.5.0\",\"description\":\"\\t\\n\\tPlugin Virtuemar slider developed by Lamvt (lamvt19792003@gmail.com) http:\\/\\/joomquery.com, Vinaora team ! <br\\/ >\\n\\t\\t<p><strong>Joomquery.com Free Joomla templates, free Joomla extensions<br \\/>\\n\\t\\t\\tWe provide the best solutions for you to choice great templates - skins for your website.\\n\\nTemplates - Skins are semi-designed websites for you to add your contents - site map so you\'re ready to start website. You can edite - customize your website with any ideas.\\n\\t\\t<\\/strong><\\/p>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{\"imageWidth\":\"380\",\"imageHeight\":\"auto\",\"thumbimageWidth\":\"89\",\"thumbimageHeight\":\"auto\"}', '', '', 0, '0000-00-00 00:00:00', 18, 0),
(10101, 0, 'VirtueMart Countdown', 'module', 'mod_virtuemart_countdown', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"VirtueMart Countdown\",\"type\":\"module\",\"creationDate\":\"10 April 2012\",\"author\":\"Cecil Gupta\",\"copyright\":\"Copyright (C) 20011 Cecil Gupta. All rights reserved. \",\"authorEmail\":\"cecilgupta@gmail.com\",\"authorUrl\":\"http:\\/\\/www.bronzecode.com\",\"version\":\"1.2.0\",\"description\":\"Countdown Timer for VirtueMart Product discounts.\",\"group\":\"\"}', '{\"sale_text\":\"\",\"product_id\":\"\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10105, 0, 'Unite Slider 2', 'module', 'mod_unite_revolution2', '', 0, 1, 0, 0, '{\"name\":\"Unite Slider 2\",\"type\":\"module\",\"creationDate\":\"October 2012\",\"author\":\"Unite CMS\",\"copyright\":\"Copyright (C) 2012 UniteCMS.net, All rights reserved.\",\"authorEmail\":\"support@unitecms.net\",\"authorUrl\":\"http:\\/\\/unitecms.net\",\"version\":\"4.7\",\"description\":\"\\n\\t\\t\\t<div style=\\\"font-weight:normal;\\\">\\n\\t\\t\\t<p><strong>Unite Slider (new edition)<\\/strong> module. Put the slider on any page. All the slider configuration located in Component.<\\/p>\\n\\t\\t\\t<p>\\n\\t\\t\\t\\tFor support please turn to <a href=\\\"http:\\/\\/unitecms.net\\/joomla-extensions\\/unite-revolution-slider-responsive\\\" target=\\\"_blank\\\">Unite Slider Page<\\/a>\\n\\t\\t\\t<\\/p>\\n\\t\\t\\t<small style=\\\"float:right\\\">ver. 4.7<\\/small>\\n\\t\\t\\t<\\/div>\\n     \\n\\t \",\"group\":\"\",\"filename\":\"mod_unite_revolution2\"}', '{\"include_jquery\":\"true\",\"js_load_type\":\"head\",\"no_conflict_mode\":\"false\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10106, 0, 'com_uniterevolution2', 'component', 'com_uniterevolution2', '', 1, 1, 0, 0, '{\"name\":\"com_uniterevolution2\",\"type\":\"component\",\"creationDate\":\"August 2012\",\"author\":\"Unite CMS \\/ Valiano\",\"copyright\":\"Copyright (C) 2012 UniteCMS.net, All rights reserved.\",\"authorEmail\":\"support@unitecms.net\",\"authorUrl\":\"http:\\/\\/www.unitecms.net\",\"version\":\"5.0.16\",\"description\":\"\\n\\t\\tUnite Slider extension and module installation success!\\n\\t\",\"group\":\"\",\"filename\":\"manifest\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10111, 0, 'VM - Search autocomplete', 'plugin', 'vm_search_ac', 'system', 0, 1, 1, 0, '{\"legacy\":true,\"name\":\"VM - Search autocomplete\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"Bob\",\"copyright\":\"Copyright (C) 2011 virtuemart. All rights reserved.\",\"authorEmail\":\"info@bob.com\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"VM - Search autocomplete\",\"group\":\"\"}', '{\"loadmj\":\"0\",\"minChars\":\"3\",\"delay\":\"400\",\"searchchilds\":\"0\",\"searchsku\":\"1\",\"searchcat\":\"0\",\"searchmanuf\":\"0\",\"max\":\"5\",\"width\":\"1170\",\"showimg\":\"1\",\"showsku\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10114, 0, 'JS Cookie Alert', 'module', 'mod_js_cookie_alert', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"JS Cookie Alert\",\"type\":\"module\",\"creationDate\":\"Unknown\",\"author\":\"Jakub Skowro\\u0144ski\",\"copyright\":\" All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\"}', '{\"js_alert_jquery\":\"1\",\"js_cwbuttoncolor\":\"blue\",\"js_cwmessage\":\"Please note this website requires cookies in order to function correctly, they do not store any specific information about you personally.\",\"js_cwbubbletitle\":\"Cookie Laws within the EU\",\"js_cwbubblemessage\":\"On 26th May 2012, new laws came into force in the EU that affect most web sites. If cookies are used in a site, the Privacy and Electronic Communications (EC Directive) (Amendment) Regulations 2011 (UK Government Regulations) asks that the website user must give consent to the use and placing of the cookies.\",\"js_cwagree\":\"Accept Cookies\",\"js_cwmoreinfo\":\"Read more...\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10122, 0, 'pkg_onestepcheckout', 'package', 'pkg_pkg_onestepcheckout', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Overrides and jQuery ,Onestepcheckout plugins in package\",\"type\":\"package\",\"creationDate\":\"09-13-2013\",\"author\":\"Neo Hoang\",\"copyright\":\"(C) 2012 Cmsmart Team. All rights reserved.\",\"authorEmail\":\"info@cmsmart.net\",\"authorUrl\":\"http:\\/\\/cmsmart.net\",\"version\":\"1.0.0\",\"description\":\"Package installer for OVERRIDES and jQuery system plugins\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10123, 0, 'plg_system_ajax_scroll', 'plugin', 'ajax_scroll', 'system', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_ajax_scroll\",\"type\":\"plugin\",\"creationDate\":\"27.01.2014\",\"author\":\"Unknown\",\"copyright\":\"\\u00a9 2014. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_AJAX_SCROLL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"container\":\".loadmore #slider\",\"item\":\".item\",\"pagination\":\".pagination.vm\",\"next\":\".pagination.vm .next a\",\"triggerPageThreshold\":\"99999\"}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10124, 0, 'Smart Slider 2', 'module', 'mod_smartslider2', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"Smart Slider 2\",\"type\":\"module\",\"creationDate\":\"2013-10-01\",\"author\":\"Roland Soos\",\"copyright\":\"Copyright (C) Nextendweb.com\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"http:\\/\\/www.nextendweb.com\",\"version\":\"2.3.0\",\"description\":\"The module displays sliders from Smart Slider 2. You can create the sliders in the Smart Slider 2 component!\",\"group\":\"\"}', '{\"cache\":\"0\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10126, 0, 'smartslider2', 'component', 'com_smartslider2', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"Smart Slider 2\",\"type\":\"component\",\"creationDate\":\"2013-10-01\",\"author\":\"Roland Soos\",\"copyright\":\"Copyright (C) Nextendweb.com\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"http:\\/\\/www.nextendweb.com\",\"version\":\"2.3.7\",\"description\":\"Component for Smart Slider 2 which allow you to create sliders and slides.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10192, 0, 'nextend_installer', 'component', 'com_nextend_installer', '', 1, 1, 0, 0, '{\"legacy\":true,\"name\":\"nextend_installer\",\"type\":\"component\",\"creationDate\":\"2013 January\",\"author\":\"Roland Soos\",\"copyright\":\"Copyright (C) 2013 All rights reserved.\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"http:\\/\\/www.nextendweb.com\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10193, 0, 'mod_vmmenu', 'module', 'mod_vmmenu', '', 1, 1, 3, 0, '{\"name\":\"VirtueMart Administrator Menu\",\"type\":\"module\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"MOD_VMMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_vmmenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10195, 0, 'VM Payment - Paybox', 'plugin', 'paybox', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - Paybox\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"http:\\/\\/paybox.com\\\" target=\\\"_blank\\\">Paybox<\\/a> \\n    \",\"group\":\"\",\"filename\":\"paybox\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10197, 0, 'VM Payment - Skrill', 'plugin', 'skrill', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Skrill\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"Skrill Holdings Limited\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.skrill.com\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"http:\\/\\/www.skrill.com\\\" target=\\\"_blank\\\">skrill<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    \",\"group\":\"\",\"filename\":\"skrill\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10198, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10199, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10200, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10201, 0, 'PLG_JSCSSCONTROL', 'plugin', 'jscsscontrol', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_JSCSSCONTROL\",\"type\":\"plugin\",\"creationDate\":\"08-Jan-2013\",\"author\":\"Viktor Vogel\",\"copyright\":\"Copyright 2013 Viktor Vogel. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomla-extensions.kubik-rubik.de\",\"version\":\"3-1\",\"description\":\"PLG_JSCSSCONTROL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"js\":\"jquery.fancybox-1.3.4.pack.js\",\"css\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 37, 0),
(10202, 0, 'mod_virtuemart_currencies_tf', 'module', 'mod_virtuemart_currencies_tf', '', 0, 1, 0, 0, '{\"name\":\"mod_virtuemart_currencies_tf\",\"type\":\"module\",\"creationDate\":\"October 23 2014\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.9.9.2\",\"description\":\"MOD_VIRTUEMART_CURRENCIES_DESC\",\"group\":\"\"}', '{\"text_before\":\"\",\"product_currency\":\"\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10204, 0, 'VM UserField - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmuserfield', 0, 0, 1, 0, '{\"name\":\"Realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"Card storage plugin for Realex\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10205, 0, 'VirtueMart Shopping Cart', 'module', 'mod_virtuemart_cart_tf', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Shopping Cart\",\"type\":\"module\",\"creationDate\":\"February 2011\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2011 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.0.0RC3\",\"description\":\"Mod Virtuemart Cart\",\"group\":\"\"}', '{\"JOOMLA_SETTING\":\"JOOMLA_SETTING\",\"moduleclass_sfx\":\"\",\"enable_cache\":\"0\",\"cache_time\":\"30\",\"SOURCE_SETTING\":\"SOURCE_SETTING\",\"show_product_list\":\"1\",\"limitcount\":\"6\",\"width\":\"60px\",\"height\":\"60px\",\"widthdropdown\":\"460\",\"show_scrollbar\":\"1\",\"height_scrollbar\":\"292\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10206, 0, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product_tf', '', 0, 1, 0, 0, '{\"name\":\"mod_virtuemart_product\",\"type\":\"module\",\"creationDate\":\"October 23 2014\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.9.9.2\",\"description\":\"MOD_VIRTUEMART_PRODUCT_DESC\",\"group\":\"\"}', '{\"layout\":\"default\",\"product_group\":\"featured\",\"max_items\":\"2\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"@spacer\":\"\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10207, 0, 'SP VirtueMart Category Search', 'module', 'mod_sp_vmsearch', '', 0, 1, 0, 0, '{\"name\":\"SP VirtueMart Category Search\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2013 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"Displays a list of VirtueMart categories and \\/ or sub-categories to search.\",\"group\":\"\"}', '{\"max_search_suggest\":\"10\",\"loadjquery\":\"1\",\"loadtypeahead\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10208, 0, 'Cooltags Cloud', 'module', 'mod_cooltags_cloud', '', 0, 1, 0, 0, '{\"name\":\"Cooltags Cloud\",\"type\":\"module\",\"creationDate\":\"April 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"dshnda@gmail.com\",\"authorUrl\":\"www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Shows a tag cloud from Virtuemart product tags. This requires com_cooltags component, Virtuemart 3 and Joomla 3.\",\"group\":\"\"}', '{\"min_font\":\"10\",\"max_font\":\"25\",\"limit\":\"50\",\"catfilter\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10209, 0, 'VMCustom - Cooltags', 'plugin', 'cooltags', 'vmcustom', 0, 0, 1, 0, '{\"name\":\"VMCustom - Cooltags\",\"type\":\"plugin\",\"creationDate\":\"April 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Adds tagging feature to Virtuemart products. This plugin requires the com_cooltags component. It also comes with its fellow (optional) search plugin extending Virtuemart product search to related product tags.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10210, 0, 'plg_search_cooltagsearch', 'plugin', 'cooltagsearch', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_cooltagsearch\",\"type\":\"plugin\",\"creationDate\":\"april 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"dshnda@gmail.com\",\"authorUrl\":\"www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Allows Searching of CoolTags Component with search for product tags.\",\"group\":\"\"}', '{\"search_limit\":\"50\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10211, 0, 'com_cooltags', 'component', 'com_cooltags', '', 1, 1, 0, 0, '{\"name\":\"com_cooltags\",\"type\":\"component\",\"creationDate\":\"2012-10-03\",\"author\":\"Adrien Roussel\",\"copyright\":\"Copyright (C) Nordmograph 2012. All rights reserved.\",\"authorEmail\":\"contact@nordmograph.com\",\"authorUrl\":\"http:\\/\\/www.nordmograph.com\",\"version\":\"1.3\",\"description\":\"Tagging solution for Virtuemart 3\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10212, 0, 'MOD_ITPFBLIKEBOX', 'module', 'mod_itpfblikebox', '', 0, 1, 0, 0, '{\"name\":\"MOD_ITPFBLIKEBOX\",\"type\":\"module\",\"creationDate\":\"18 May, 2015\",\"author\":\"Todor Iliev\",\"copyright\":\"Copyright (C) 2015 Todor Iliev ( ITPrism.com )\",\"authorEmail\":\"todor@itprism.com\",\"authorUrl\":\"http:\\/\\/itprism.com\",\"version\":\"1.11\",\"description\":\"\\n        <p><a href=\'http:\\/\\/itprism.com\\/free-joomla-extensions\\/social-marketing-seo\\/facebook-like-box\' target=\'_blank\'>ITPFacebookLikeBox<\\/a> adds Facebook Page promoting box on your website.<\\/p>\\n        <p><a href=\'http:\\/\\/itprism.com\\/help\\/34-facebook-likebox-documentation-faq\' target=\'_blank\'>Read documentation<\\/a> that will help you to setup the extensions.<\\/p>\\n        <p><a href=\'http:\\/\\/itprism.com\\/\' target=\'_blank\'>Subscribe for the newsletter<\\/a> to receive information about updates and new ITPrism extensions.<\\/p>\\n        <p>Please, vote for this module on <a href=\'http:\\/\\/extensions.joomla.org\\/extensions\\/social-web\\/facebook-display\\/15754\' target=\'_blank\'>Joomla! Extensions Directory!<\\/a><\\/p>\\n    \",\"group\":\"\",\"filename\":\"mod_itpfblikebox\"}', '{\"fbPageLink\":\"\",\"fbRendering\":\"2\",\"fbWidth\":\"250\",\"fbHeight\":\"827\",\"fbColour\":\"light\",\"fbFaces\":\"1\",\"fbStream\":\"1\",\"fbHeader\":\"1\",\"fbDynamicLocale\":\"1\",\"fbLocale\":\"en_US\",\"facebookLikeAppId\":\"\",\"fbLoadJsLib\":\"1\",\"facebookRootDiv\":\"1\",\"facebookForceWall\":\"0\",\"facebookResponsive\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10213, 0, 'JMod TweetDisplay', 'module', 'mod_jmod_tweetdisplay', '', 0, 1, 0, 0, '{\"name\":\"JMod TweetDisplay\",\"type\":\"module\",\"creationDate\":\"July 2013\",\"author\":\"Sean Casco\",\"copyright\":\"Copyright (C) 2013. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.0\",\"description\":\" <h1 style=\\\"color: red\\\">To use this module follow this guide: <a href=\\\"http:\\/\\/jmodules.com\\/tutorials\\/jmod-tweetdisplay-documentation\\\" target=\\\"_blank\\\">How to Setup<\\/a><\\/h1>\\n\\t\",\"group\":\"\"}', '{\"consumer_key\":\"\",\"consumer_secret\":\"\",\"access_token\":\"\",\"access_secret\":\"\",\"type\":\"1\",\"username\":\"twitter\",\"query\":\"\",\"title\":\"\",\"link_title\":\"1\",\"count\":\"5\",\"width\":\"\",\"height\":\"\",\"header\":\"1\",\"twitter_icon\":\"1\",\"display_name\":\"1\",\"avatars\":\"0\",\"timestamps\":\"1\",\"reply\":\"1\",\"retweet\":\"1\",\"favorite\":\"1\",\"show_link\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10222, 0, 'com_jcomments', 'component', 'com_jcomments', '', 1, 1, 0, 0, '{\"name\":\"JComments\",\"type\":\"component\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"3.0.5\",\"description\":\"JComments lets your users comment on content items.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10223, 0, 'plg_content_jcomments', 'plugin', 'jcomments', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_CONTENT_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_frontpage\":\"1\",\"enable_for_archived\":\"0\",\"comments_count\":\"1\",\"add_comments\":\"1\",\"links_position\":\"1\",\"readmore_link\":\"1\",\"readmore_css_class\":\"readmore-link\",\"comments_css_class\":\"comments-link\",\"show_hits\":\"0\",\"show_comments_event\":\"onAfterDisplayContent\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10224, 0, 'plg_editors-xtd_jcommentson', 'plugin', 'jcommentson', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_jcommentson\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_EDITORS-XTD_JCOMMENTSON_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10225, 0, 'plg_editors-xtd_jcommentsoff', 'plugin', 'jcommentsoff', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_jcommentsoff\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_EDITORS-XTD_JCOMMENTSOFF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10226, 0, 'plg_search_jcomments', 'plugin', 'jcomments', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_SEARCH_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10227, 0, 'plg_system_jcomments', 'plugin', 'jcomments', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_SYSTEM_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"disable_template_css\":\"0\",\"disable_error_reporting\":\"0\",\"clear_rss\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 24, 0),
(10228, 0, 'plg_user_jcomments', 'plugin', 'jcomments', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_USER_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10229, 0, 'plg_quickicon_jcomments', 'plugin', 'jcomments', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_QUICKICON_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"context\":\"mod_quickicon\",\"displayedtext\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10230, 0, 'vmVendor', 'plugin', 'vmvendor', 'system', 0, 1, 1, 0, '{\"name\":\"vmVendor\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"velikorodnov\",\"copyright\":\"mad_velikorodnov\",\"authorEmail\":\"velikorodnov@velikorodnov.com\",\"authorUrl\":\"http:\\/\\/themeforest.net\\/user\\/mad_velikorodnov\",\"version\":\"1.0\",\"description\":\"PLG_VMVENDOR_DESC\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 19, 0),
(10231, 0, 'VMCustom - JMSYoutube', 'plugin', 'jmsyoutube', 'vmcustom', 0, 0, 1, 0, '{\"name\":\"VMCustom - JMSYoutube\",\"type\":\"plugin\",\"creationDate\":\"Otober 2013\",\"author\":\"Joommasters\",\"copyright\":\"Copyright (C) 2009-2013 Joommasters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.joommasters.com\",\"version\":\"1.0\",\"description\":\"JMS youtube for Virtuemart plugin\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10232, 0, 'Responsive color google map', 'module', 'mod_profil_responsive_map', '', 0, 1, 0, 0, '{\"name\":\"Responsive color google map\",\"type\":\"module\",\"creationDate\":\"January 22th, 2014\",\"author\":\"David Hoffmann\",\"copyright\":\"Copyright (c) 2014 Profil PR & Werbeagentur All rights reserved.\",\"authorEmail\":\"web@profilpr.de\",\"authorUrl\":\"Profilpr\",\"version\":\"1.0\",\"description\":\"MOD_PROFIL_RESPONSIVE_MAP_DESCRIPTION\",\"group\":\"\"}', '{\"profilResponsiveMapTemplates\":\"default\",\"profilResponsiveMapColor\":\"#123456\",\"profilResponsiveMapContrast\":\"1.58\",\"profilResponsiveMapSaturation\":\"0\",\"profilResponsiveMapLightness\":\"0\",\"profilResponsiveMapZoom\":\"14\",\"profilResponsivePanControl\":\"1\",\"profilResponsiveZoomControl\":\"1\",\"profilResponsiveMapTypeControl\":\"1\",\"profilResponsiveScaleControl\":\"1\",\"profilResponsiveStreetViewControl\":\"1\",\"profilResponsiveScrollwheel\":\"1\",\"profilResponsiveFullscreen\":\"0\",\"profilResponsiveVisibility\":\"0\",\"profilResponsiveBikemap\":\"0\",\"profilResponsiveWeathermap\":\"0\",\"profilResponsiveWeathermapTemperatureunit\":\"0\",\"profilResponsiveCloudmap\":\"0\",\"profilResponsiveTrafficmap\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10233, 0, 'Joomla Options', 'plugin', 'joomla_options', 'system', 0, 1, 1, 0, '{\"name\":\"Joomla Options\",\"type\":\"plugin\",\"creationDate\":\"Mart 2013\",\"author\":\"Fedor Vlasenko\",\"copyright\":\"Copyright (C) 2013 Fregate Studio.\",\"authorEmail\":\"vlasenkofedor@mail.ru\",\"authorUrl\":\"fregate.org.ua\",\"version\":\"0.0.1\",\"description\":\"\\u0421onfiguration, options in Joomla\",\"group\":\"\"}', '{\"disable_mootools\":\"0\",\"disable_jquery\":\"1\",\"disable_bootstrap\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10234, 0, 'mod_jux_vm_megamenu', 'module', 'mod_jux_vm_megamenu', '', 0, 1, 0, 0, '{\"name\":\"mod_jux_vm_megamenu\",\"type\":\"module\",\"creationDate\":\"July 2013\",\"author\":\"JoomlaUX\",\"copyright\":\"Copyright (C) 20011 - 2015 JoomlaUX. All rights reserved.\",\"authorEmail\":\"admin@joomlaux.com\",\"authorUrl\":\"http:\\/\\/joomlaux.com\",\"version\":\"2.0.4\",\"description\":\"\\n\\t <div class=\'js_desc\'>\\n\\t\\t\\t<h3 style=\'color: #008000;\'>JUX VM Megamenu<\\/h3>\\n\\t\\t\\t<a href=\'http:\\/\\/joomlaux.com\' target=\'_blank\'><img src=\'http:\\/\\/www.joomlaux.com\\/images\\/digitalstore\\/preview\\/jux-virtuemart-mega-menu.png\'><\\/a>\\n\\t\\t\\t<p style=\'text-align:justify;\'>\\n\\t\\t\\t\\t<strong>JUX VM Megamenu<\\/strong> is a powerful & responsive Joomla menu module which helps you to flexibly & easily bring VirtueMart categories & subcategories to display in menu.\\n\\t\\t\\t<\\/p>\\n                        <p style=\'text-align:justify;\'>Mega menu for VirtueMart provides an optimal viewing experience \\u2013 visitors can navigation and reading content easily on any screen size because it fully responsive.<\\/p>\\n\\t\\t\\t<br clear=\'both\' \\/>\\n\\t\\t\\t<p style=\'clear:both\'><span style=\'color: #ff6600;\'><strong>Highlight feature:<\\/strong><\\/strong><\\/p>\\n\\t\\t\\t<ul class=\'list-style\'>\\n                            <li> Easy to change orientation for menu<\\/li>\\n                            <li>Easily customize effect & time for submenu to display<\\/li>\\n                            <li>Customize to every detail of Top Menu, submenu & menu items at ease, such as:<\\/li>\\n                            <li>Show\\/hide items, submenu of items<\\/li>\\n                            <li>Add\\/remove column in submenu<\\/li>\\n                            <li>Select module for added column<\\/li>\\n                            <li>Hover background color<\\/li>\\n                            <li>Border, padding, Margin<\\/li>\\n                            <li>Text & hover text color<\\/li>\\n                            <li>Totally responsive: displays on any devices<\\/li>\\n\\t\\t\\t<\\/ul>\\n\\t\\t\\t<p><span style=\'color: #008000;\'><strong>Links:<\\/strong><\\/span><\\/p>\\n\\t\\t\\t<ul class=\'list-style\'>\\n\\t\\t\\t\\t<li><a target=\'_blank\' href=\'http:\\/\\/docs.joomlaux.com\\/extensions\\/jux_megamenu_specific\\/\'>User Guide<\\/a><\\/li>\\n\\t\\t\\t\\t<li><a target=\'_blank\' href=\'http:\\/\\/extensions.joomla.org\\/extensions\\/extension\\/extension-specific\\/virtuemart-extensions\\/jux-mega-menu-for-virtuemart\'>Vote for us on JED!<\\/a><\\/li>\\n\\t\\t\\t\\t<li><a target=\'_blank\' href=\'http:\\/\\/joomlaux.com\\/forum\'>Forums<\\/a><\\/li>\\n\\t\\t\\t<\\/ul>\\n\\t\\t\\t<p>Copyright 2013 - 2014 <a target=\'_blank\' href=\'http:\\/\\/www.joomlaux.com\\/\' title=\'Visit JoomlaUX.com!\'>JoomlaUX.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\\t<style type=\'text\\/css\'>\\n\\t\\t\\t.js_desc{\\n\\t\\t\\t\\ttext-align: left;\\n\\t\\t\\t}\\n\\t\\t\\t.js_desc h3{\\n\\t\\t\\t\\tmargin: 20px 0px 10px 0px;\\n\\t\\t\\t}\\n\\t\\t\\t.js_desc img{\\n\\t\\t\\t\\twidth:40%;\\n\\t\\t\\t\\tmargin:5px 5px 5px 0px;\\n\\t\\t\\t}\\n\\t\\t\\t.js_desc p,.js_desc li{\\n\\t\\t\\t\\tlist-style: none outside none;\\n\\t\\t\\t\\tpadding: 5px 5px 5px 0px;\\n\\t\\t\\t}\\n\\n\\t\\t\\t.js_desc ul.list-style li{\\n\\t\\t\\t\\tbackground:url(http:\\/\\/www.joomlaux.com\\/images\\/icons\\/tick.png) 0px 6px no-repeat;\\n\\t\\t\\t\\tpadding-left:30px;\\n\\t\\t\\t\\tline-height:15px;\\n\\t\\t\\t}\\n\\t\\t<\\/style>\",\"group\":\"\",\"filename\":\"mod_jux_vm_megamenu\"}', '{\"hozorver\":\"horizontal\",\"horizontal_submenu_direction\":\"down\",\"vertical_submenu_direction\":\"lefttoright\",\"navigation_animation\":\"\",\"n_navigation_animation\":\"\",\"animation_duration\":\"400\",\"animation_delay\":\"\",\"show_num_items\":\"1\",\"show_items\":\"0\",\"load_font_awesome\":\"0\",\"nav_style\":\"flat\",\"fl_color\":\"#FFFFFF\",\"gradient\":\"\",\"gradient_type\":\"linear\",\"gs_color_1\":\"#484848\",\"gs_color_2\":\"#393939\",\"ge_color_1\":\"#212121\",\"ge_color_2\":\"#131313\",\"nav_border\":\"\",\"nav_padding\":\"0\",\"nav_margin\":\"0\",\"nav_corner\":\"\",\"dd_bacground_color\":\"#fffff\",\"dd_border\":\"\",\"dd_padding\":\"0\",\"dd_margin\":\"0\",\"dd_corner\":\"\",\"dd_shadow\":\"0\",\"titem_hover_bacground_color\":\"#fffff\",\"titem_border\":\"\",\"titem_padding\":\"0\",\"titem_margin\":\"0\",\"titem_text_color\":\"#333333\",\"titem_text_hover_color\":\"#0088CC\",\"ditem_hover_bacground_color\":\"#fffff\",\"ditem_border\":\"\",\"ditem_padding\":\"0\",\"ditem_margin\":\"0\",\"ditem_text_color\":\"#333333\",\"ditem_text_hover_color\":\"#0088CC\",\"custom_css\":\"\",\"cache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10235, 0, 'Virtuemart 3 multiple customfield plugin', 'plugin', 'param', 'vmcustom', 0, 0, 1, 0, '{\"name\":\"Virtuemart 3 multiple customfield plugin\",\"type\":\"plugin\",\"creationDate\":\"2015.11.23\",\"author\":\"Dmitriy Usov\",\"copyright\":\"Copyright (C) 2012-2015 usovdm\",\"authorEmail\":\"usovdm@gmail.com\",\"authorUrl\":\"http:\\/\\/myext.ru\",\"version\":\"3.0.6\",\"description\":\"PLG_VMCUSTOM_PARAM_XML_DESC\",\"group\":\"\",\"filename\":\"param\"}', '{\"mcf_key\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10236, 0, 'Search (filter) module for Virtuemart 3 multiple customfield plugin', 'module', 'mod_virtuemart_param_filter', '', 0, 1, 0, 0, '{\"name\":\"Search (filter) module for Virtuemart 3 multiple customfield plugin\",\"type\":\"module\",\"creationDate\":\"2015.11.23\",\"author\":\"Dmitriy Usov\",\"copyright\":\"Copyright (C) 2012-2015 usovdm\",\"authorEmail\":\"usovdm@gmail.com\",\"authorUrl\":\"http:\\/\\/myext.eu\",\"version\":\"3.0.6\",\"description\":\"mod_vmcustom_param_filter_xml_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_param_filter\"}', '{\"layout\":\"default\",\"method\":\"get\",\"limit\":\"10\",\"parent_auto\":\"0\",\"stock\":\"0\",\"children\":\"-1\",\"show_all_count\":\"1\",\"mod_ajax\":\"1\",\"count_show\":\"1\",\"count_zero_show\":\"disable\",\"mod_ajax_div\":\"\",\"loader_img\":\"aload-black_on_white\",\"mcf_mod_uniq_display\":\"1\",\"mcf_mod_uniq_result\":\"0\",\"view_assign\":\"-1\",\"categories_show\":\"1\",\"in_active_category\":\"0\",\"active_category_id\":\"\",\"mcf_subcategories\":\"0\",\"mcf_only_subcategories\":\"0\",\"categories_heading\":\"\",\"categories_select_heading\":\"Choose category\",\"categories_layout\":\"checkbox\",\"manufacturers_show\":\"1\",\"manufacturers_heading\":\"\",\"manufacturers_select_heading\":\"Choose manufacturer\",\"mcf_body\":\"Z3ppbmZsYXRl;dZJra9swFIb\\/ypnwik0Tx4GtbL5kBNrRFQod65etKUaxj2OtsmR08eaW\\/vdJTsYgZF8E5\\/K859WRdlxuKYegNR2fBT1VtCs1UlW1Jat1BkEtKyjg5jOtjFRjmu7QXMrKdihMGLn6MeKamdZoQk\\/OV8flCM7OTkBvCpgv4ROchiAFYTn30\\/iu7KrGO7rjdsfENfIe1WRrnwjJ0FVWG9mRGZmEiLfpoPIJRwf+1FKUNVayxvCv3mGkjuarQ2MGwJrwH1ZAV78Pt1TjxbsSxUTvnmtsODUYEk6\\/Xi5JrO1WG\\/XfNi9Bbkl8c7e+vy6\\/fbm\\/iskViaJolsyWF1FM1vgjmRLRC7wi1\\/gCgel655oqRUe\\/8EaqMGBFkgUsLz668\\/zcNTuvh60f7+4hYI9RNMk8PDqhkw0ZvJ58SU9l+8\\/hIpLXbABtRo7FhjRSmLlmz5h+SN5mG7L6Li20dECgIKRw\\/4UN7tI1DKg0kwJ+taxqoWa653TUYHswEpYJ7CeCQm250TGsDySM0iroZG05QosKU8gptAobN701pk8Xi27E3yZGuyFgqHKfwJXKLafiyRm6Ha+mYr6gq3zhvK9ITDbCHTkTvTVgxt7fpGV1jcJJCNr52D86E8y4zEC59all4oKF46dd+HUpNFYJMMpi9gc=;Y3JlYXRlX2Z1bmN0aW9u\",\"mcf_mod\":\"bxaisiexi6xi4xi_xdieicixoidxe\",\"manufacturers_layout\":\"auto\",\"price_show\":\"1\",\"price_heading\":\"\",\"price_discount\":\"0\",\"price_mcur\":\"0\",\"price_layout\":\"auto\",\"price_select_heading\":\"\",\"customfields_show\":\"1\",\"customfields_select_heading\":\"Choose some options\",\"customfields_layout\":\"auto\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"mcf_jqueryui\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10237, 0, 'jmsmultiupload', 'component', 'com_jmsmultiupload', '', 1, 1, 0, 0, '{\"name\":\"jmsmultiupload\",\"type\":\"component\",\"creationDate\":\"29 July 2013\",\"author\":\"Joommasters Team\",\"copyright\":\"Joommasters.com\",\"authorEmail\":\"Joommasters@gmail.com\",\"authorUrl\":\"www.Joommasters.com\",\"version\":\"2.5\",\"description\":\"JMS Multi Images Upload Component\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10238, 0, 'System - JMS Multi Upload For Virtuemart', 'plugin', 'jmsmultiupload', 'system', 0, 1, 1, 0, '{\"name\":\"System - JMS Multi Upload For Virtuemart\",\"type\":\"plugin\",\"creationDate\":\"16-Jan-2012\",\"author\":\"JoomMasterS\",\"copyright\":\"http:\\/\\/www.joommasters.com\",\"authorEmail\":\"joommasters@gmail.com\",\"authorUrl\":\"http:\\/\\/www.joommasters.com\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"jmsmultiupload\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 25, 0),
(10240, 0, 'Shortcodes Ultimate', 'plugin', 'bdthemes_shortcodes', 'system', 0, 1, 1, 0, '{\"name\":\"Shortcodes Ultimate\",\"type\":\"plugin\",\"creationDate\":\"May 15, 2014\",\"author\":\"BDThemes Ltd\",\"copyright\":\"(C) 2012 BDThemes Ltd. All rights reserved.\",\"authorEmail\":\"info@bdthemes.com\",\"authorUrl\":\"http:\\/\\/www.bdtheme.com\",\"version\":\"2.0.0-RC3\",\"description\":\"PLG_SYSTEM_BDTHEMES_SHORTCODES_SHORTCODE_ULTIMATE_DESC\",\"group\":\"\",\"filename\":\"bdthemes_shortcodes\"}', '{\"font-awesome\":\"local\",\"tmpl_shortcode\":\"t3_bs3_blank\",\"font-awesome-admin\":\"local\",\"shortcode_pre\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 22, 0),
(10241, 0, 'Button - Shortcodes Ultimate', 'plugin', 'shortcode_ultimate', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"Button - Shortcodes Ultimate\",\"type\":\"plugin\",\"creationDate\":\"January 15, 2015\",\"author\":\"BdThemes Ltd\",\"copyright\":\"(C) 2012 BDThemes Ltd. All rights reserved.\",\"authorEmail\":\"info@bdthemes.com\",\"authorUrl\":\"http:\\/\\/www.bdthemes.com\",\"version\":\"2.0\",\"description\":\"This is the Shortcodes system buttom that enables the use of shortcodes in the entire site. it\'s work like wordpress shortcodes system.\",\"group\":\"\",\"filename\":\"shortcode_ultimate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10242, 0, 'bdthemes_shortcodes', 'component', 'com_bdthemes_shortcodes', '', 1, 1, 0, 0, '{\"name\":\"bdthemes_shortcodes\",\"type\":\"component\",\"creationDate\":\"March 31, 2014\",\"author\":\"BDThemes Ltd\",\"copyright\":\"(C) 2012 BDThemes Ltd. All rights reserved.\",\"authorEmail\":\"info@bdthemes.com\",\"authorUrl\":\"http:\\/\\/www.bdtheme.com\",\"version\":\"2.0-RC2\",\"description\":\"Shortcode Ultimate Component for generate shortcode easily.\",\"group\":\"\",\"filename\":\"bdthemes_shortcodes\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10243, 0, 'Module youtube video', 'module', 'mod_youtubevideo', '', 0, 1, 0, 0, '{\"name\":\"Module youtube video\",\"type\":\"module\",\"creationDate\":\"30\\/08\\/2015\",\"author\":\"Velikorodnov\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"test@test.com\",\"authorUrl\":\"\",\"version\":\"0.1\",\"description\":\"Youtube Video Module is a Joomla! \",\"group\":\"\",\"filename\":\"mod_youtubevideo\"}', '{\"selector\":\"#youtubevideo\",\"video\":\"kN3ZO8vwPRg\",\"mod_image\":\"\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10244, 0, 'Module Parallax', 'module', 'mod_parallax', '', 0, 1, 0, 0, '{\"name\":\"Module Parallax\",\"type\":\"module\",\"creationDate\":\"21\\/10\\/2014\",\"author\":\"Test\",\"copyright\":\"Copyright (C) 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"Test\",\"authorUrl\":\"\",\"version\":\"0.0\",\"description\":\"Parallax Module is a Joomla! \",\"group\":\"\",\"filename\":\"mod_parallax\"}', '{\"selector\":\"#parallax\",\"backgroundratio\":\"-0.2\",\"horizontalOffset\":\"0\",\"verticalOffset\":\"20\",\"mod_image\":\"\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10245, 0, 'VirtueMart Category Velikorodnov', 'module', 'mod_virtuemart_category_tf', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Category Velikorodnov\",\"type\":\"module\",\"creationDate\":\"August 24 2015\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"3.0.9.6\",\"description\":\"VirtueMart Category Velikorodnov\",\"group\":\"\",\"filename\":\"mod_virtuemart_category_tf\"}', '{\"level\":\"2\",\"layout\":\"default\",\"cache\":\"1\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10246, 0, 'VirtueMart Manufacturers Velikorodnov', 'module', 'mod_virtuemart_manufacturer_tf', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Manufacturers Velikorodnov\",\"type\":\"module\",\"creationDate\":\"August 24 2015\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"3.0.9.6\",\"description\":\"VirtueMart Manufacturers Velikorodnov\",\"group\":\"\",\"filename\":\"mod_virtuemart_manufacturer_tf\"}', '{\"show\":\"all\",\"display_style\":\"list\",\"manufacturers_per_row\":\"\",\"@spacer\":\"\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10247, 0, 'VirtueMart Search Product Velokorodnov', 'module', 'mod_virtuemart_search_tf', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Search Product Velokorodnov\",\"type\":\"module\",\"creationDate\":\"August 24 2015\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"3.0.9.6\",\"description\":\"VirtueMart Search Product Velokorodnov\",\"group\":\"\",\"filename\":\"mod_virtuemart_search_tf\"}', '{\"width\":\"20\",\"text\":\"\",\"@spacer\":\"\",\"filter_category\":\"0\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10248, 0, 'VM Payment - Pay with Amazon', 'plugin', 'amazon', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 25 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.3\",\"description\":\"AMAZON PAY plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10249, 0, 'System - Pay with Amazon', 'plugin', 'amazon', 'system', 0, 1, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 25 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.3\",\"description\":\"AMAZON payment SYSTEM plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10250, 0, 'VM Payment - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"Global Payments HPP and API\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10251, 0, 'VM Payment - Klikandpay', 'plugin', 'klikandpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - klikandpay\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"http:\\/\\/klikandpay.com\\\" target=\\\"_blank\\\">klikandpay<\\/a> \\n    \",\"group\":\"\",\"filename\":\"klikandpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10252, 0, 'Genius Virtuemart Ajax Search - VM3 Edition - Deluxe', 'module', 'mod_genius_vm_ajax_search_vm3', '', 0, 1, 0, 0, '{\"name\":\"Genius Virtuemart Ajax Search - VM3 Edition - Deluxe\",\"type\":\"module\",\"creationDate\":\"2015\",\"author\":\"www.genius-webdesign.com\",\"copyright\":\"(C) Genius WebDesign\",\"authorEmail\":\"info@geniusdesign.dk\",\"authorUrl\":\"https:\\/\\/www.genius-webdesign.com\",\"version\":\"GVM3AS 1.1.0\",\"description\":\"\\nGenius Virtuemart Ajax Search - VM3 Edition - Deluxe, created by <a href=\\\"https:\\/\\/www.genius-webdesign.com\\/\\\">Genius WebDesign<\\/a> Development Team. <br>For further module information and install instructions visit <a href=\\\"https:\\/\\/www.genius-webdesign.com\\/joomla-extensions-menu\\/virtuemart-ajax-search\\\">the official product page<\\/a><script>window.jQuery || document.write(\\\"<script src=\'\\/\\/www.genius-webdesign.com\\/js\\/jquery1.7.2.js\'>\\\\x3C\\/script>\\\") <\\/script>\\n<div id=\\\"infogenius\\\"><div style=\\\"font-size: 12px;color: #800000;display: inline-block;padding: 5px;background: #F4F4F4;border: solid #DDDDDD 1px;padding-left: 14px;padding-right: 14px;padding-top: 22px;padding-bottom: 22px;margin-top: 12px;\\\">THIS DOMAIN IS NOT LICENSED FOR USING THIS MODULE!<br><br>Please go to this page and get your special Envato license for Genius Virtuemart Ajax Search:<br><br>\\n<a href=\\\"https:\\/\\/www.genius-webdesign.com\\/genius-vm-ajax-search-deluxe-envato-checkout\\\" target=\\\"_blank\\\">Activate License & Download Module!<\\/a><\\/div><\\/div>\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_genius_vm_ajax_search_vm3\"}', '{\"template\":\"0\",\"moduleclass_sfx\":\" ajax_srch\",\"price_type_display\":\"1\",\"manualmargin_setting\":\"0\",\"manualmargin_settingtop\":\"0\",\"number_of_cats\":\"100\",\"number_of_mans\":\"100\",\"number_of_products\":\"20\",\"vm_expo_sku\":\"0\",\"highlight_prods\":\"1\",\"highlight_sku\":\"1\",\"highlight_cats\":\"1\",\"highlight_manuf\":\"1\",\"showcats_info\":\"1\",\"showmanuf_info\":\"1\",\"child_products_link\":\"0\",\"internal_caching\":\"0\",\"include_sdescr\":\"0\",\"results_ordering\":\"0\",\"matching_depth\":\"0\",\"highlight_color\":\"#FF8\",\"css_override\":\".mycustomclass h1.customclass { background: #807000; }\",\"overlay_bg_color_enable\":\"0\",\"overlay_bg_color\":\"#008000\",\"overlay_bg_color_opacity\":\"0.4\",\"initial_ajax_loader_enable\":\"0\",\"initial_ajax_loader_bg\":\"#F9F5F2\",\"master_ajax_window_width\":\"905\",\"initial_ajax_loader_width\":\"905\",\"search_input_placeholder\":\"Search in shop!\",\"search_string_info\":\"Your search:\",\"modal_close_txt\":\"Close window X\",\"category_header_txt\":\"Categories\",\"manuf_header_txt\":\"Brands\",\"product_header_txt\":\"Products\",\"news_header_txt\":\"Latest News\",\"sku_pre_txt\":\"SKU:\",\"buynow_txt\":\"Buy Now!\",\"noresults__box_txt\":\"No matching results...\",\"less_than_three_txt\":\"Please also try these popular search phrases: Disco music, King Kong...\",\"noprresults_atall_txt\":\"No results found... Please try another search\",\"include_custom_pos\":\"0\",\"custom_module_pos\":\"customajaxposition\",\"custom_module_default_width\":\"183\",\"show_ratings_ajax\":\"0\",\"starrating_color\":\"#008000\",\"shownews_info\":\"1\",\"newssource\":\"1\",\"number_of_news\":\"20\",\"highlight_news\":\"1\",\"special_scroll_bars\":\"1\",\"special_scroll_bars_type\":\"0\",\"special_scroll_bars_smoothness\":\"120\",\"k2catfilter\":\"0\",\"k2category_id\":\"\",\"joomart_filter\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10253, 0, 'IsotopeMart layout for VirtueMart', 'module', 'mod_isotopemart', '', 0, 1, 0, 0, '{\"name\":\"IsotopeMart layout for VirtueMart\",\"type\":\"module\",\"creationDate\":\"February 2014\",\"author\":\"ITechnoDev, LLC\",\"copyright\":\"Copyright (C) 2014 ITechnoDev, LLC. All rights reserved.\",\"authorEmail\":\"help@itechnodev.com\",\"authorUrl\":\"http:\\/\\/www.itechnodev.com\",\"version\":\"1.0.0\",\"description\":\"This is a Joomla! module which displays VirtueMart products inside a dynamic mosaic mansory layout using isotope jQuery plugin\",\"group\":\"\",\"filename\":\"mod_isotopemart\"}', '{\"text-options\":\"Text Settings\",\"product_group\":\"random\",\"pagination-options\":\"Pagination Settings\",\"enable_pagination\":\"0\",\"per_page\":\"6\",\"style-options\":\"Style Settings\",\"itemWidth\":\"282\",\"itemHeight\":\"427\",\"item_style\":\"1\",\"display-options\":\"Text Settings\",\"show_filtering\":\"1\",\"show_sorting\":\"1\",\"show_ordering\":\"1\",\"jquery-options\":\"Text Settings\",\"loadjQuery\":\"1\",\"hide_front\":\"1\",\"hide_views\":\"1\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10254, 0, 'tcpdf', 'component', 'com_tcpdf', '', 1, 1, 0, 0, '{\"name\":\"tcpdf\",\"type\":\"component\",\"creationDate\":\"May 2019\",\"author\":\"Nicola Asuni, The VirtueMart Development Team\",\"copyright\":\"Copyright (c) 2001-2018 Nicola Asuni - Tecnick.com LTD - Tutti i diritti riservati - All Rights Reserved. 2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"1.0.8\",\"description\":\"TCPDF 6.2.26 by Nicola Asuni. Joomla Installer by the VirtueMart Team\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10259, 0, 'VM Payment - 2Checkout', 'plugin', 'tco', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"2Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Craig Christenson\",\"copyright\":\"Copyright (C) 2004-2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.2checkout.com\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"https:\\/\\/www.2checkout.com\\/referral?r=virtuemart\\\" target=\\\"_blank\\\">2Checkout<\\/a> is a popular payment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"tco\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10260, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 0, 1, 0, '{\"version\":\"5.6.1\",\"author\":\"Acyba\",\"creationDate\":\"janvier 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10261, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10262, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10263, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10264, 0, 'System - Google Maps', 'plugin', 'plugin_googlemap3', 'system', 0, 1, 1, 0, '{\"name\":\"System - Google Maps\",\"type\":\"plugin\",\"creationDate\":\"July 2014\",\"author\":\"mapsplugin.com\",\"copyright\":\"(C) 2014 mapsplugin.com\",\"authorEmail\":\"info@mapsplugin.com\",\"authorUrl\":\"mapsplugin.com\",\"version\":\"3.4\",\"description\":\"PLUGIN_GOOGLE_MAP3_INSTALLATION\",\"group\":\"\",\"filename\":\"plugin_googlemap3\"}', '{\"debug\":\"0\",\"plugincode\":\"mosmap\",\"brackets\":\"{\",\"Google_API_version\":\"3\",\"visualrefresh\":\"0\",\"signedin\":\"0\",\"show\":\"1\",\"mapclass\":\"\",\"mapprint\":\"icon\",\"mapcssgen\":\"realtime\",\"mapcss\":\"\\/* For img in the map remove borders, shadow, no margin and no max-width\\r\\n*\\/\\r\\n.map img, .svPanel img {\\r\\n    border: 0px;\\r\\n    box-shadow: none;\\r\\n    margin: 0px !important;\\r\\n    padding: 0px !important;\\r\\n    max-width: none !important;\\r\\n    background: none !important;\\r\\n}\\r\\n\\r\\n\\/* Make sure the directions are below the map\\r\\n*\\/\\r\\n.directions {\\r\\n    clear: left;\\r\\n}\\r\\n\\r\\n.adp-directions {\\r\\n    width: 100%;\\r\\n}\\r\\n\\r\\n\\/* Solve problems in chrome with the show of the direction steps in full width\\r\\n*\\/\\r\\n.adp-placemark {\\r\\n    width : 100%;\\r\\n}\\r\\n\\r\\n\\/* Padding for image overlay\\r\\n*\\/\\r\\n.controlDiv {\\r\\n    padding : 5px;\\r\\n}\\r\\n\",\"loadmootools\":\"1\",\"timeinterval\":\"500\",\"loadfont\":\"1\",\"Google_API_key\":\"AIzaSyBQft4vTUGW75YPU6c0xOMwLKhxCEJDPwg\",\"Google_Multi_API_key\":\"\",\"urlsetting\":\"Joomla\",\"googlewebsite\":\"maps.google.com\",\"styledmap\":\"\",\"align\":\"center\",\"langtype\":\"site\",\"lang\":\"\",\"width\":\"100%\",\"height\":\"400\",\"effect\":\"none\",\"lat\":\"52.075581\",\"lon\":\"4.541513\",\"centerlat\":\"\",\"centerlon\":\"\",\"address\":\"\",\"geoloc\":\"0\",\"geocenter\":\"0\",\"geomarkerurl\":\"\\/media\\/plugin_googlemap3\\/site\\/geolocation\\/images\\/gpsloc.png\",\"geomarkersizex\":\"34\",\"geomarkersizey\":\"34\",\"geomarkerscaledx\":\"17\",\"geomarkerscaledy\":\"17\",\"geomarkeranchorx\":\"8\",\"geomarkeranchory\":\"8\",\"geocirclefill\":\"#61a0bf\",\"geocirclestroke\":\"#1bb6ff\",\"geocirclestrokeop\":\".4\",\"geocirclefillop\":\".4\",\"geocirclestrokeweight\":\"1\",\"controltype\":\"UI\",\"oldcontrol\":\"0\",\"zoomType\":\"3D-large\",\"svcontrol\":\"1\",\"returncontrol\":\"1\",\"zoom\":\"10\",\"corzoom\":\"0\",\"minzoom\":\"0\",\"maxzoom\":\"19\",\"rotation\":\"1\",\"zoomnew\":\"0\",\"zoomWheel\":\"0\",\"keyboard\":\"0\",\"mapType\":\"Normal\",\"showmaptype\":\"1\",\"showNormalMaptype\":\"1\",\"showSatelliteMaptype\":\"1\",\"showHybridMaptype\":\"1\",\"showTerrainMaptype\":\"1\",\"showscale\":\"0\",\"overview\":\"0\",\"dragging\":\"1\",\"marker\":\"1\",\"labelcolor\":\"\",\"labelfont\":\"\",\"labelfontsize\":\"\",\"labelfontweight\":\"\",\"labelanchorx\":\"\",\"labelanchory\":\"\",\"icon\":\"\",\"iconwidth\":\"\",\"iconheight\":\"\",\"iconanchorx\":\"\",\"iconanchory\":\"\",\"iconshadow\":\"\",\"iconshadowwidth\":\"\",\"iconshadowheight\":\"\",\"iconimagemap\":\"\",\"traffic\":\"0\",\"transit\":\"0\",\"bicycle\":\"0\",\"dir\":\"0\",\"dirtype\":\"D\",\"formdirtype\":\"1\",\"avoidhighways\":\"0\",\"avoidtoll\":\"0\",\"diroptimize\":\"0\",\"diralternatives\":\"0\",\"showdir\":\"1\",\"animdir\":\"0\",\"animspeed\":\"1\",\"animautostart\":\"0\",\"animunit\":\"kilometers\",\"formspeed\":\"0\",\"formaddress\":\"0\",\"formdir\":\"0\",\"autocompl\":\"both\",\"langanim\":\"en-GB;The requested panorama could not be displayed|Could not generate a route for the current start and end addresses|Street View coverage is not available for this route|You have reached your destination|miles|miles|ft|kilometers|kilometer|meters|In|You will reach your destination|Stop|Drive|Press Drive to follow your route|Route|Speed|Fast|Medium|Slow\",\"txtdir\":\"Directions: \",\"txtgetdir\":\"Get Directions\",\"txtfrom\":\"From here\",\"txtto\":\"To here\",\"txtdiraddr\":\"Address: \",\"txt_driving\":\"\",\"txt_avhighways\":\"\",\"txt_avtoll\":\"\",\"txt_walking\":\"\",\"txt_bicycle\":\"\",\"txt_transit\":\"\",\"txt_optimize\":\"\",\"txt_alternatives\":\"\",\"inputsize\":\"25\",\"dirdefault\":\"0\",\"gotoaddr\":\"0\",\"gotoaddrzoom\":\"0\",\"gotoaddrtimeout\":\"5000\",\"txtaddr\":\"Address: ##\",\"erraddr\":\"Address ## not found!\",\"txtgotoaddr\":\"Goto\",\"clientgeotype\":\"google\",\"lightbox\":\"0\",\"txtlightbox\":\"Open lightbox\",\"lbxcaption\":\"\",\"lbxwidth\":\"500\",\"lbxheight\":\"700\",\"lbxcenterlat\":\"\",\"lbxcenterlon\":\"\",\"lbxzoom\":\"\",\"sv\":\"none\",\"svpano\":\"\",\"svwidth\":\"100%\",\"svheight\":\"300\",\"svyaw\":\"0\",\"svpitch\":\"0\",\"svzoom\":\"\",\"svautorotate\":\"0\",\"svaddress\":\"1\",\"kmlrenderer\":\"google\",\"kmlsidebar\":\"none\",\"kmlsbwidth\":\"200\",\"kmlfoldersopen\":\"0\",\"kmlhide\":\"0\",\"kmlscale\":\"0\",\"kmlopenmethod\":\"click\",\"kmlsbsort\":\"none\",\"kmllightbox\":\"0\",\"kmlmessshow\":\"0\",\"kmlclickablemarkers\":\"1\",\"kmlzoommarkers\":\"0\",\"kmlopendivmarkers\":\"\",\"kmlcontentlinkmarkers\":\"0\",\"kmllinkablemarkers\":\"0\",\"kmllinktarget\":\"_self\",\"kmllinkmethod\":\"dblclick\",\"kmlhighlite\":\"{ \'color\': \'#aaffff\', \'opacity\': 0.3,  \'textcolor\': \'#000000\' }\",\"kmlmarkerlabel\":\"100\",\"kmlmarkerlabelclass\":\"\",\"kmlpolylabel\":\"100\",\"kmlpolylabelclass\":\"\",\"proxy\":\"0\",\"txtsrchnrby\":\"Search nearby\",\"txtzoomhere\":\"Zoom Here\",\"txtaddrstart\":\"Start address:\",\"txtkmlgetdir\":\"Go\",\"txtback\":\"\\u00ab Back\",\"txtsearchnearby\":\"Search nearby: e.g. pizza\",\"txtsearch\":\"Go\",\"googlemaps_credit\":\"1\",\"maxcluster\":\"\",\"clustericonurl\":\"\\/media\\/plugin_googlemap3\\/site\\/geoxmlv3\\/images\\/m\",\"gridsize\":\"\",\"minmarkerscluster\":\"\",\"maxlinesinfocluster\":\"\",\"clusterinfowindow\":\"click\",\"clusterzoom\":\"dblclick\",\"clustermarkerzoom\":\"16\",\"txtzoomin\":\"Zoom in to show more\",\"txtclustercount1\":\"...and\",\"txtclustercount2\":\"more\",\"tilelayer\":\"\",\"tilemethod\":\"\",\"tileopacity\":\"1\",\"tilebounds\":\"\",\"tileminzoom\":\"0\",\"tilemaxzoom\":\"19\",\"imageurl\":\"\",\"imageposition\":\"RIGHT_TOP\",\"imageindex\":\"1\",\"imagewidth\":\"\",\"imageheight\":\"\",\"twittername\":\"\",\"twittertweets\":\"15\",\"twittericon\":\"\\/media\\/plugin_googlemap3\\/site\\/Twitter\\/twitter_map_icon.png\",\"twitterline\":\"#ff0000ff\",\"twitterlinewidth\":\"4\",\"twitterstartloc\":\"0,0,0\",\"twitterconsumerkey\":\"\",\"twitterconsumersecret\":\"\",\"twitteraccesstoken\":\"\",\"twitteraccesstokensecret\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 40, 0),
(10266, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.8.0\",\"author\":\"Acyba\",\"creationDate\":\"ao\\u00fbt 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 35, 0),
(10267, 0, 'VM Framework Loader during Plugin Updates', 'plugin', 'vmLoaderPluginUpdate', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_SYSTEM_VMLOADERPLUGINUPDATE\",\"type\":\"plugin\",\"creationDate\":\"2019-10-08\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2017 Reinhold Kainhofer.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\\/\",\"version\":\"1.0.2\",\"description\":\"PLG_SYSTEM_VMLOADERPLUGINUPDATE_DESC\",\"group\":\"\",\"filename\":\"vmLoaderPluginUpdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 17, 0),
(10269, 0, 'T3 Framework Package', 'package', 'pkg_t3', '', 0, 1, 1, 0, '{\"name\":\"T3 Framework Package\",\"type\":\"package\",\"creationDate\":\"Sep 06, 2017\",\"author\":\"t3-framework.org\",\"copyright\":\"(C) 2012 - 2017. All rights reserved.\",\"authorEmail\":\"support@t3-framework.org\",\"authorUrl\":\"www.t3-framework.org\",\"version\":\"2.6.7\",\"description\":\"\\t\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2017 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"pkg_t3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10271, 10273, 'PLG_SYSTEM_JCH_OPTIMIZE', 'plugin', 'jch_optimize', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_JCH_OPTIMIZE\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"Copyright (C) 2017 Samuel Marshall. All rights reserved.\",\"authorEmail\":\"sdmarshall73@gmail.com\",\"authorUrl\":\"http:\\/\\/www.jch-optimize.net\",\"version\":\"5.4.3\",\"description\":\"JCH_OPTIMIZE_DESCRIPTION\",\"group\":\"\",\"filename\":\"jch_optimize\"}', '{\"combine_files_enable\":\"1\",\"html_minify_level\":\"0\",\"htaccess\":\"2\",\"try_catch\":\"1\",\"debug\":\"0\",\"log\":\"0\",\"css\":\"1\",\"javascript\":\"1\",\"gzip\":\"1\",\"css_minify\":\"1\",\"js_minify\":\"1\",\"html_minify\":\"1\",\"includeAllExtensions\":\"1\",\"hidden_containsgf\":\"\",\"csg_enable\":\"0\",\"csg_direction\":\"vertical\",\"csg_wrap_images\":\"0\",\"img_attributes_enable\":\"0\",\"kraken_backup\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 39, 0),
(10272, 10273, 'JCH Optimize', 'component', 'com_jch_optimize', '', 1, 1, 0, 0, '{\"name\":\"JCH Optimize\",\"type\":\"component\",\"creationDate\":\"September 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"(c) 2017 JCH Optimize All rights reserved\",\"authorEmail\":\"samuel@jch-optimize.net\",\"authorUrl\":\"https:\\/\\/www.jch-optimize.net\",\"version\":\"5.4.3\",\"description\":\"Provides Ajax support to the JCH Optimize plugin\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10273, 0, 'JCH Optimize Package', 'package', 'pkg_jch_optimize', '', 0, 1, 1, 0, '{\"name\":\"JCH Optimize Package\",\"type\":\"package\",\"creationDate\":\"September 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"Copyright (c) 2017 Samuel Marshall\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"5.4.3\",\"description\":\"Package to install the JCH Optimize plugin with supporting component\",\"group\":\"\",\"filename\":\"pkg_jch_optimize\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10274, 0, 'com_virtuemart - en-GB', 'file', 'com_virtuemart-en-GB', '', 0, 1, 0, 0, '{\"name\":\"com_virtuemart - en-GB\",\"type\":\"file\",\"creationDate\":\"03.11.2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/www.virtuemart.net\",\"version\":\"2017-11-03-09-18-36\",\"description\":\"\\n        This package was auto generated with CTransifex(https:\\/\\/compojoom.com). We\'ve grabbed the latest language files for our extension from transifex.com.\\n        Special thanks to OpenTranslators (http:\\/\\/opentranslators.org) for helping us with this translation!\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10275, 0, 'VM Payment - eWay', 'plugin', 'eway', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - eway\",\"type\":\"plugin\",\"creationDate\":\"October 16 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2018 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.6.3\",\"description\":\"<a href=\\\"https:\\/\\/www.eway.com.au\\/\\\" target=\\\"_blank\\\">eway<\\/a> \\n    \",\"group\":\"\",\"filename\":\"eway\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10276, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"3.6.2\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10277, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10278, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10279, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10280, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10281, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2019 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10282, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10283, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10284, 0, 'VM Custom - iStraxx Download simple', 'plugin', 'istraxx_download_simple', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VM - Custom, Virtuemart Simple Download Plugin\",\"type\":\"plugin\",\"creationDate\":\"September 06 2019\",\"author\":\"Max Milbers\",\"copyright\":\"Copyright (C) 2012-2019 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/extensions.virtuemart.net\",\"version\":\"${PHING.VERSION}\",\"description\":\"\\n<b>${PHING.DESCRIPTION}<\\/b>\\n<br\\/><a target=\\\"_blank\\\" href=\\\"http:\\/\\/www.extensions.virtuemart.net\\\">Visit extensions.virtuemart.net for more extensions<\\/a>\\n<p><img src=\\\"..\\/plugins\\/${PHING.GROUP}\\/${PHING.FILENAME}\\/assets\\/images\\/vm-istraxx.png\\\" align=\\\"bottom\\\"\\/><\\/p>\\n\\n<br style=\\\"clear: both;\\\">\\n<br\\/>\\nFirst installation:\\n<a target=\\\"_blank\\\" href=\\\"index.php?option=com_virtuemart&view=custom&task=edit\\\">\\n  Click here to configure the new customfield using the custom field type plugin<\\/a>\\n<br\\/>\\nSee also:\\n<br\\/>\\n<a target=\\\"_blank\\\" href=\\\"https:\\/\\/extensions.virtuemart.net\\/all-tutorials\\\">\\n  Installation Guide<\\/a>\\n\\n\",\"group\":\"\",\"filename\":\"istraxx_download_simple\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10285, 0, 'System - VirtueMart One Page Checkout', 'plugin', 'onepage_generic', 'system', 0, 1, 1, 0, '{\"name\":\"System - VirtueMart One Page Checkout\",\"type\":\"plugin\",\"creationDate\":\"SEP 2019\",\"author\":\"Claes Norin\",\"copyright\":\" Copyright (c) 2012, 2015 All Right Reserved, http:\\/\\/www.joomlapro.com.\",\"authorEmail\":\"info@joomlapro.com\",\"authorUrl\":\"http:\\/\\/www.joomlapro.com\\/\",\"version\":\"2.3.1\",\"description\":\"<html>\\n\\t\\t   <table class=\\\"table\\\"><tr><td><a href=\\\"http:\\/\\/joomlapro.com\\\" target=\\\"_blank\\\"><img src=\\\"http:\\/\\/joomlapro.com\\/images\\/logo1.png\\\"><\\/a><\\/td><td><h3>System - VirtueMart One Page Checkout downloaded from joomlapro.com.<\\/h3><hr>We have built quality Joomla extension since 2012. JoomlaPro is a company under joomlapro.com<\\/td><\\/tr>\\n\\t\\t   <tr>\\n\\t\\t   <td colspan=\\\"2\\\" style=\\\"text-align:right; padding:10px 0 0 0; border-bottom:0px none\\\">\\n\\t\\t   <a href=\\\"http:\\/\\/joomlapro.com\\/\\\" target=\\\"_blank\\\"><img src=\\\"http:\\/\\/joomlapro.com\\/images\\/logo2.png\\\"><\\/a>\\n\\t\\t   <\\/td>\\n\\t\\t   <\\/tr>\\n\\t\\t   <\\/table>\\n\\t     \",\"group\":\"\",\"filename\":\"onepage_generic\"}', '{\"download_key\":\"\",\"show_extraterms\":\"0\",\"popup_address\":\"1\",\"show_shiptoaddress_list\":\"0\",\"hide_oneshipment\":\"1\",\"hide_onepayment\":\"1\",\"list_allpayment\":\"1\",\"list_allshipment\":\"1\",\"hide_billto_btn\":\"0\",\"hide_shipto_btn\":\"0\",\"allow_html\":\"1\",\"show_onlyguest\":\"0\",\"buttoncolour\":\"#3498db\",\"button_primary\":\"\",\"button_danger\":\"\",\"form_danger\":\"\",\"activetab\":\"3\",\"auto_country\":\"0\",\"hide_countryfield\":\"1\",\"hide_statefield\":\"1\",\"check_terms\":\"1\",\"show_forgot\":\"1\",\"layout_width\":\"1\",\"notes_popup\":\"1\",\"terms_css\":\"1\",\"hide_coupon_amount\":\"0\",\"hide_coupon_tax_amount\":\"0\",\"hide_payment_amount\":\"0\",\"hide_shipment_amount\":\"0\",\"country_reload\":\"0\",\"ajax_zip\":\"0\",\"showzip_top\":\"0\",\"use_recaptcha\":\"0\",\"recaptchakey\":\"\",\"secretkey\":\"\",\"built_by\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE `#__finder_filters` (
  `filter_id` int(10) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `params` mediumtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE `#__finder_links` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double UNSIGNED NOT NULL DEFAULT '0',
  `sale_price` double UNSIGNED NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms0`;
CREATE TABLE `#__finder_links_terms0` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms1`;
CREATE TABLE `#__finder_links_terms1` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms2`;
CREATE TABLE `#__finder_links_terms2` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms3`;
CREATE TABLE `#__finder_links_terms3` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms4`;
CREATE TABLE `#__finder_links_terms4` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms5`;
CREATE TABLE `#__finder_links_terms5` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms6`;
CREATE TABLE `#__finder_links_terms6` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms7`;
CREATE TABLE `#__finder_links_terms7` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms8`;
CREATE TABLE `#__finder_links_terms8` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms9`;
CREATE TABLE `#__finder_links_terms9` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsa`;
CREATE TABLE `#__finder_links_termsa` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsb`;
CREATE TABLE `#__finder_links_termsb` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsc`;
CREATE TABLE `#__finder_links_termsc` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsd`;
CREATE TABLE `#__finder_links_termsd` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termse`;
CREATE TABLE `#__finder_links_termse` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsf`;
CREATE TABLE `#__finder_links_termsf` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE `#__finder_taxonomy` (
  `id` int(10) UNSIGNED NOT NULL,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `access` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `#__finder_taxonomy` VALUES
(1, 0, 'ROOT', 0, 0, 0);

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE `#__finder_taxonomy_map` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE `#__finder_terms` (
  `term_id` int(10) UNSIGNED NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `#__finder_terms_common` VALUES
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('any', 'en'),
('are', 'en'),
('aren\'t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn\'t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '1',
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE `#__finder_tokens_aggregate` (
  `term_id` int(10) UNSIGNED NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `term_weight` float UNSIGNED NOT NULL,
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `context_weight` float UNSIGNED NOT NULL,
  `total_weight` float UNSIGNED NOT NULL,
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE `#__finder_types` (
  `id` int(10) UNSIGNED NOT NULL,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__jcomments`;
CREATE TABLE `#__jcomments` (
  `id` int(11) UNSIGNED NOT NULL,
  `parent` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `thread_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `level` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `object_params` text NOT NULL,
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `isgood` smallint(5) NOT NULL DEFAULT '0',
  `ispoor` smallint(5) NOT NULL DEFAULT '0',
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `deleted` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subscribe` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(255) NOT NULL DEFAULT '',
  `source_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments` VALUES
(1, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'demos', 'demos', 'qqq@qqq.com', '', '', 'Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa. Aenean a adipiscing justo', '127.0.0.1', '2015-05-22 18:46:42', 0, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(2, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', '[quote name=\"demos\"]Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa. Aenean a adipiscing justo[/quote]<br />Etiam rhoncus leo vitae purus laoreet viverra. Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat. Etiam tellus arcu, tincidunt in rhoncus quis, vestibulum vitae ipsum. Suspendisse sit amet nisl leo, et viverra ante. Sed mi lorem, cursus sit amet pellentesque laoreet,', '127.0.0.1', '2015-05-22 18:49:22', 0, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(3, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', ':lol:', '127.0.0.1', '2015-05-22 21:05:38', 0, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(4, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', 'Etiam tellus arcu, tincidunt in rhoncus quis, vestibulum vitae ipsum.', '127.0.0.1', '2015-05-22 21:17:19', 0, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(5, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', 'in rhoncus quis, vestibulum vitae ipsum. Suspendisse sit amet nisl leo, et viverra ante. Sed mi lorem, cursus sit amet pellentesque laoreet,', '127.0.0.1', '2015-05-22 21:17:26', 0, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(6, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', 'Etiam rhoncus leo vitae purus laoreet viverra. Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.', '127.0.0.1', '2015-05-22 21:17:38', 0, 1, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', ''),
(7, 0, 0, '0', 0, 6, 'com_virtuemart', '', 'en-GB', 0, 'Super User', 'admin', 'admin@admin.com', '', '', '[quote name=\"Super User\"]:lol:[/quote]<br />Etiam rhoncus leo vitae purus laoreet viverra. Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.', '127.0.0.1', '2015-05-22 21:17:44', 1, 0, 1, 0, 0, '', 0, 0, '0000-00-00 00:00:00', '');

DROP TABLE IF EXISTS `#__jcomments_blacklist`;
CREATE TABLE `#__jcomments_blacklist` (
  `id` int(11) UNSIGNED NOT NULL,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `notes` tinytext NOT NULL,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_custom_bbcodes`;
CREATE TABLE `#__jcomments_custom_bbcodes` (
  `id` int(11) UNSIGNED NOT NULL,
  `name` varchar(64) NOT NULL DEFAULT '',
  `simple_pattern` varchar(255) NOT NULL DEFAULT '',
  `simple_replacement_html` text NOT NULL,
  `simple_replacement_text` text NOT NULL,
  `pattern` varchar(255) NOT NULL DEFAULT '',
  `replacement_html` text NOT NULL,
  `replacement_text` text NOT NULL,
  `button_acl` text NOT NULL,
  `button_open_tag` varchar(16) NOT NULL DEFAULT '',
  `button_close_tag` varchar(16) NOT NULL DEFAULT '',
  `button_title` varchar(255) NOT NULL DEFAULT '',
  `button_prompt` varchar(255) NOT NULL DEFAULT '',
  `button_image` varchar(255) NOT NULL DEFAULT '',
  `button_css` varchar(255) NOT NULL DEFAULT '',
  `button_enabled` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_custom_bbcodes` VALUES
(1, 'YouTube Video', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8,1', '[youtube]', '[/youtube]', 'YouTube Video', '', '', 'bbcode-youtube', 1, 1, 1, 0, '0000-00-00 00:00:00'),
(2, 'YouTube Video (short syntax)', '[youtube]{IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 2, 1, 0, '0000-00-00 00:00:00'),
(3, 'YouTube Video (alternate syntax)', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}{TEXT}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([\\w0-9-\\+\\=\\!\\?\\(\\)\\[\\]\\{\\}\\&\\%\\*\\#\\.,_ ]+)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8,1', '[youtube]', '[/youtube]', 'YouTube Video', '', '', '', 0, 3, 1, 0, '0000-00-00 00:00:00'),
(4, 'YouTube Video (alternate syntax)', '[youtube]http://www.youtube.com/watch?feature=player_embedded&v={IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\://www\\.youtube\\.com/watch\\?feature\\=player_embedded&v\\=([\\w0-9-_]+)\\[/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 4, 1, 0, '0000-00-00 00:00:00'),
(5, 'YouTube Video (alternate syntax)', '[youtube]http://youtu.be/{IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\://youtu\\.be/([\\w0-9-_]+)\\[/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 5, 1, 0, '0000-00-00 00:00:00'),
(6, 'Facebook Video', '[fv]http://www.facebook.com/video/video.php?v={IDENTIFIER}[/fv]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id={IDENTIFIER}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v={IDENTIFIER}', '\\[fv\\]http\\:\\/\\/www\\.facebook\\.com\\/video\\/video\\.php\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id=${1}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v=${1}', '1,2,3,4,5,6,7,8,1', '[fv]', '[/fv]', 'Facebook Video', '', '', 'bbcode-facebook', 1, 6, 1, 0, '0000-00-00 00:00:00'),
(7, 'Facebook Video (short syntax)', '[fv]{IDENTIFIER}[/fv]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id={IDENTIFIER}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v={IDENTIFIER}', '\\[fv\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id=${1}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v=${1}', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 7, 1, 0, '0000-00-00 00:00:00'),
(8, 'Facebook Video (alternate syntax)', '[fv]http://www.facebook.com/photo.php?v={IDENTIFIER}[/fv]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id={IDENTIFIER}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v={IDENTIFIER}', '\\[fv\\]http\\:\\/\\/www\\.facebook\\.com\\/photo\\.php\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/video/embed?video_id=${1}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v=${1}', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 8, 1, 0, '0000-00-00 00:00:00'),
(9, 'Instagram', '[instagram]http://instagram.com/p/{IDENTIFIER}/[/instagram]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/{IDENTIFIER}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/{IDENTIFIER}/', '\\[instagram\\]http\\:\\/\\/instagram\\.com\\/p\\/([\\w0-9-_]+)\\/\\[/instagram\\]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/${1}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/${1}/', '1,2,3,4,5,6,7,8,1', '[instagram]', '[/instagram]', 'Instagram Photo', '', '', 'bbcode-instagram', 1, 9, 1, 0, '0000-00-00 00:00:00'),
(10, 'Instagram (short syntax)', '[instagram]{IDENTIFIER}[/instagram]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/{IDENTIFIER}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/{IDENTIFIER}/', '\\[instagram\\]([\\w0-9-_]+)\\[/instagram\\]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/${1}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/${1}/', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 10, 1, 0, '0000-00-00 00:00:00'),
(11, 'Instagram (alternate syntax)', '[instagram]http://instagram.com/p/{IDENTIFIER}[/instagram]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/{IDENTIFIER}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/{IDENTIFIER}/', '\\[instagram\\]http\\:\\/\\/instagram\\.com\\/p\\/([\\w0-9-_]+)\\[/instagram\\]', '<iframe width=\"425\" height=\"350\" src=\"//instagram.com/p/${1}/embed/\" frameborder=\"0\" scrolling=\"no\" allowtransparency=\"true\"></iframe>', 'http://instagram.com/p/${1}/', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 11, 1, 0, '0000-00-00 00:00:00'),
(12, 'Vimeo', '[vimeo]http://vimeo.com/{IDENTIFIER}/[/vimeo]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/{IDENTIFIER}/\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'http://vimeo.com/{IDENTIFIER}/', '\\[vimeo\\]http\\:\\/\\/vimeo\\.com\\/([\\w0-9-_]+)\\[/vimeo\\]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/${1}\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'http://vimeo.com/${1}/', '1,2,3,4,5,6,7,8,1', '[vimeo]', '[/vimeo]', 'Vimeo Video', '', '', 'bbcode-vimeo', 1, 12, 1, 0, '0000-00-00 00:00:00'),
(13, 'Vimeo (short syntax)', '[vimeo]{IDENTIFIER}[/vimeo]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/{IDENTIFIER}/\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'http://vimeo.com/{IDENTIFIER}/', '\\[vimeo\\]([\\w0-9-_]+)\\[/vimeo\\]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/${1}\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'http://vimeo.com/${1}/', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 13, 1, 0, '0000-00-00 00:00:00'),
(14, 'Vimeo (alternate syntax)', '[vimeo]https://vimeo.com/{IDENTIFIER}/[/vimeo]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/{IDENTIFIER}/\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'https://vimeo.com/{IDENTIFIER}/', '\\[vimeo\\]https\\:\\/\\/vimeo\\.com\\/([\\w0-9-_]+)\\[/vimeo\\]', '<iframe width=\"425\" height=\"239\" src=\"//player.vimeo.com/video/${1}\" frameborder=\"0\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>', 'https://vimeo.com/${1}/', '1,2,3,4,5,6,7,8,1', '', '', '', '', '', '', 0, 13, 1, 0, '0000-00-00 00:00:00'),
(15, 'Wiki', '[wiki]{SIMPLETEXT}[/wiki]', '<a href=\"http://www.wikipedia.org/wiki/{SIMPLETEXT}\" title=\"{SIMPLETEXT}\" target=\"_blank\">{SIMPLETEXT}</a>', '{SIMPLETEXT}', '\\[wiki\\]([A-Za-z0-9\\-\\+\\.,_ ]+)\\[\\/wiki\\]', '<a href=\"http://www.wikipedia.org/wiki/${1}\" title=\"${1}\" target=\"_blank\">${1}</a>', '${1}', '1,2,3,4,5,6,7,8,1', '[wiki]', '[/wiki]', 'Wikipedia', '', '', 'bbcode-wiki', 1, 14, 1, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__jcomments_mailq`;
CREATE TABLE `#__jcomments_mailq` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `created` datetime NOT NULL,
  `attempts` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) NOT NULL DEFAULT '0',
  `session_id` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_objects`;
CREATE TABLE `#__jcomments_objects` (
  `id` int(11) UNSIGNED NOT NULL,
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `category_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `lang` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `link` text NOT NULL,
  `access` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `expired` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_objects` VALUES
(33, 3, 'com_virtuemart', 0, 'en-GB', 'Ut us dolor apibusgetele mentumvel', '/homeshop/index.php?option=com_virtuemart&amp;view=productdetails&amp;virtuemart_product_id=3&amp;virtuemart_category_id=1&amp;Itemid=116&amp;lang=en', 0, 0, 0, '2017-01-27 18:53:01'),
(34, 14, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet conse ctetur adipisicing', '/homeshop/index.php?option=com_virtuemart&amp;view=productdetails&amp;virtuemart_product_id=14&amp;virtuemart_category_id=4&amp;Itemid=116&amp;lang=en', 0, 0, 0, '2017-01-27 18:53:33'),
(35, 8, 'com_virtuemart', 0, 'en-GB', 'Ipsum dolor sit amet conse ctetur', '/homeshop/index.php/en/men/product-8-detail', 0, 0, 0, '2017-06-05 18:51:34'),
(36, 6, 'com_virtuemart', 0, 'en-GB', 'Dolor sit amet', '/homeshop/index.php/en/women/product-6-detail', 0, 0, 0, '2017-06-05 19:13:51'),
(37, 30, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet, consect etuer', '/homeshop/index.php/en/shop/photography/product-30', 0, 0, 0, '2017-06-19 20:30:26'),
(38, 34, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet conse ctetur adipisicing', '/homeshop/index.php/en/shop/photography/product-34', 0, 0, 0, '2017-06-19 20:30:53'),
(39, 1, 'com_virtuemart', 0, 'en-GB', 'Lum mleie kertase miase lacnean', '/homeshop/index.php/en/men/product-1', 0, 0, 0, '2017-06-26 18:57:28'),
(40, 5, 'com_virtuemart', 0, 'en-GB', 'Ipsum dolor sit amet conse ctetur', '/homeshop/index.php/en/cameras/product-5', 0, 0, 0, '2017-06-26 18:57:56'),
(41, 33, 'com_virtuemart', 0, 'en-GB', 'Ut us dolor apibusgetele mentumvel', '/homeshop/index.php/en/men/product-33', 0, 0, 0, '2017-06-26 18:59:10'),
(42, 31, 'com_virtuemart', 0, 'en-GB', 'Lum mleie kertase miase lacnean', '/homeshop/index.php/en/men/product-31', 0, 0, 0, '2017-06-26 18:59:17'),
(43, 55, 'com_virtuemart', 0, 'en-GB', 'red + 12', '/homeshop/index.php/en/cameras/red', 0, 0, 0, '2017-06-26 19:02:15'),
(44, 56, 'com_virtuemart', 0, 'en-GB', 'blue + 12', '/homeshop/index.php/en/cameras/blue', 0, 0, 0, '2017-06-26 19:02:18'),
(45, 58, 'com_virtuemart', 0, 'en-GB', 'blue + 14', '/homeshop/index.php/en/cameras/size-14', 0, 0, 0, '2017-06-26 19:02:21'),
(46, 27, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet', '/homeshop/index.php/en/shop/photography/product-27', 0, 0, 0, '2017-06-27 19:24:59'),
(47, 24, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet conse ctetur adipisicing', '/home/ver1_9/index.php/en/shop/photography/product-24', 0, 0, 0, '2017-09-01 17:30:07'),
(48, 35, 'com_virtuemart', 0, 'en-GB', 'Ipsum dolor sit amet conse ctetur', '/home/ver1_9/index.php/cameras/donec-ultricies/proin-viverra,-ur/product-35', 0, 0, 0, '2017-09-20 19:33:22'),
(49, 4, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet conse ctetur adipisicing', '/home/ver1_9/index.php/en/cameras/product-4', 0, 0, 0, '2017-09-20 20:07:25'),
(50, 12, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet, consect etuer', '/home/ver_2/index.php?option=com_virtuemart&amp;view=productdetails&amp;virtuemart_product_id=12&amp;virtuemart_category_id=3&amp;lang=en', 0, 0, 0, '2017-12-24 20:15:40'),
(51, 7, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet', '/home/ver_2_3/index.php/en/men/product-7', 0, 0, 0, '2019-02-22 13:04:52'),
(52, 22, 'com_virtuemart', 0, 'en-GB', 'Lorem ipsum dolor sit amet, consect etuer', '/homeshop/homeshop_theme_2.5/index.php/en/shop/photography/product-22', 0, 0, 0, '2019-10-21 19:49:19');

DROP TABLE IF EXISTS `#__jcomments_reports`;
CREATE TABLE `#__jcomments_reports` (
  `id` int(11) UNSIGNED NOT NULL,
  `commentid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_settings`;
CREATE TABLE `#__jcomments_settings` (
  `component` varchar(50) NOT NULL DEFAULT '',
  `lang` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_settings` VALUES
('', '', 'author_email', '2'),
('', '', 'author_homepage', '1'),
('', '', 'author_name', '2'),
('', '', 'autolinkurls', '6,7,2,3,4,5,8'),
('', '', 'autopublish', '1,6,7,2,3,4,5,8'),
('', '', 'badwords', ''),
('', '', 'can_ban', '7,8'),
('', '', 'can_comment', '1,6,7,2,3,4,5,8'),
('', '', 'can_delete', '6,7,8'),
('', '', 'can_delete_for_my_object', ''),
('', '', 'can_delete_own', '6,7,8'),
('', '', 'can_edit', '6,7,8'),
('', '', 'can_edit_for_my_object', ''),
('', '', 'can_edit_own', '6,7,2,3,4,5,8'),
('', '', 'can_publish', '6,7,5,8'),
('', '', 'can_publish_for_my_object', ''),
('', '', 'can_reply', '1,6,7,2,3,4,5,8'),
('', '', 'can_report', '6,7,2,3,4,5,8'),
('', '', 'can_view_email', '6,7,8'),
('', '', 'can_view_homepage', '6,7,2,3,4,5,8'),
('', '', 'can_view_ip', '7,8'),
('', '', 'can_vote', '1,6,7,2,3,4,5,8'),
('', '', 'captcha_engine', 'kcaptcha'),
('', '', 'censor_replace_word', '[censored]'),
('', '', 'comments_list_order', 'DESC'),
('', '', 'comments_page_limit', '15'),
('', '', 'comments_pagination', 'top'),
('', '', 'comments_per_page', '6'),
('', '', 'comments_tree_order', '0'),
('', '', 'comment_maxlength', '1000'),
('', '', 'comment_minlength', '0'),
('', '', 'comment_title', '0'),
('', '', 'delete_mode', '0'),
('', '', 'display_author', 'name'),
('', '', 'emailprotection', '1'),
('', '', 'enable_autocensor', '1'),
('', '', 'enable_bbcode_b', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_code', '2,3,4,5,6,7,8'),
('', '', 'enable_bbcode_hide', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_i', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_img', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_list', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_quote', '1,6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_s', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_u', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_url', '6,7,2,3,4,5,8'),
('', '', 'enable_blacklist', '0'),
('', '', 'enable_captcha', '1'),
('', '', 'enable_categories', ''),
('', '', 'enable_comment_length_check', '1,2'),
('', '', 'enable_comment_maxlength_check', ''),
('', '', 'enable_custom_bbcode', '0'),
('', '', 'enable_geshi', '0'),
('', '', 'enable_gravatar', ''),
('', '', 'enable_nested_quotes', '1'),
('', '', 'enable_notification', '0'),
('', '', 'enable_plugins', '1'),
('', '', 'enable_quick_moderation', '0'),
('', '', 'enable_reports', '1'),
('', '', 'enable_rss', '1'),
('', '', 'enable_smilies', '1'),
('', '', 'enable_subscribe', '1,6,7,2,3,4,5,8'),
('', '', 'enable_username_check', '1'),
('', '', 'enable_voting', '1'),
('', '', 'feed_limit', '100'),
('', '', 'floodprotection', '1,2,3,4'),
('', '', 'flood_time', '30'),
('', '', 'forbidden_names', 'administrator,moderator'),
('', '', 'form_position', '0'),
('', '', 'form_show', '1'),
('', '', 'link_maxlength', '50'),
('', '', 'load_cached_comments', '1'),
('', '', 'max_comments_per_object', '0'),
('', '', 'merge_time', '0'),
('', '', 'message_banned', ''),
('', '', 'message_locked', 'Comments are now closed for this entry'),
('', '', 'message_policy_post', ''),
('', '', 'message_policy_whocancomment', 'You have no rights to post comments'),
('', '', 'notification_email', ''),
('', '', 'notification_type', '1,2'),
('', '', 'reports_before_unpublish', '0'),
('', '', 'reports_per_comment', '0'),
('', '', 'report_reason_required', '1'),
('', '', 'show_commentlength', '1'),
('', '', 'show_policy', '1,2'),
('', '', 'smilies', ':D	laugh.gif\n:lol:	lol.gif\n:-)	smile.gif\n;-)	wink.gif\n8)	cool.gif\n:-|	normal.gif\n:-*	whistling.gif\n:oops:	redface.gif\n:sad:	sad.gif\n:cry:	cry.gif\n:o	surprised.gif\n:-?	confused.gif\n:-x	sick.gif\n:eek:	shocked.gif\n:zzz	sleeping.gif\n:P	tongue.gif\n:roll:	rolleyes.gif\n:sigh:	unsure.gif'),
('', '', 'smilies_path', '/components/com_jcomments/images/smilies/'),
('', '', 'template', 'default'),
('', '', 'template_view', 'list'),
('', '', 'username_maxlength', '20'),
('', '', 'word_maxlength', '50');

DROP TABLE IF EXISTS `#__jcomments_smilies`;
CREATE TABLE `#__jcomments_smilies` (
  `id` int(11) UNSIGNED NOT NULL,
  `code` varchar(39) NOT NULL DEFAULT '',
  `alias` varchar(39) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_smilies` VALUES
(1, ':D', '', 'laugh.gif', 'Laugh', 1, 1, 0, '0000-00-00 00:00:00'),
(2, ':lol:', '', 'lol.gif', 'Lol', 1, 2, 0, '0000-00-00 00:00:00'),
(3, ':-)', '', 'smile.gif', 'Smile', 1, 3, 0, '0000-00-00 00:00:00'),
(4, ';-)', '', 'wink.gif', 'Wink', 1, 4, 0, '0000-00-00 00:00:00'),
(5, '8)', '', 'cool.gif', 'Cool', 1, 5, 0, '0000-00-00 00:00:00'),
(6, ':-|', '', 'normal.gif', 'Normal', 1, 6, 0, '0000-00-00 00:00:00'),
(7, ':-*', '', 'whistling.gif', 'Whistling', 1, 7, 0, '0000-00-00 00:00:00'),
(8, ':oops:', '', 'redface.gif', 'Redface', 1, 8, 0, '0000-00-00 00:00:00'),
(9, ':sad:', '', 'sad.gif', 'Sad', 1, 9, 0, '0000-00-00 00:00:00'),
(10, ':cry:', '', 'cry.gif', 'Cry', 1, 10, 0, '0000-00-00 00:00:00'),
(11, ':o', '', 'surprised.gif', 'Surprised', 1, 11, 0, '0000-00-00 00:00:00'),
(12, ':-?', '', 'confused.gif', 'Confused', 1, 12, 0, '0000-00-00 00:00:00'),
(13, ':-x', '', 'sick.gif', 'Sick', 1, 13, 0, '0000-00-00 00:00:00'),
(14, ':eek:', '', 'shocked.gif', 'Shocked', 1, 14, 0, '0000-00-00 00:00:00'),
(15, ':zzz', '', 'sleeping.gif', 'Sleeping', 1, 15, 0, '0000-00-00 00:00:00'),
(16, ':P', '', 'tongue.gif', 'Tongue', 1, 16, 0, '0000-00-00 00:00:00'),
(17, ':roll:', '', 'rolleyes.gif', 'Rolleyes', 1, 17, 0, '0000-00-00 00:00:00'),
(18, ':sigh:', '', 'unsure.gif', 'Unsure', 1, 18, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__jcomments_subscriptions`;
CREATE TABLE `#__jcomments_subscriptions` (
  `id` int(11) UNSIGNED NOT NULL,
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `hash` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(255) NOT NULL DEFAULT '',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_version`;
CREATE TABLE `#__jcomments_version` (
  `version` varchar(16) NOT NULL DEFAULT '',
  `previous` varchar(16) NOT NULL DEFAULT '',
  `installed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_votes`;
CREATE TABLE `#__jcomments_votes` (
  `id` int(11) UNSIGNED NOT NULL,
  `commentid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `value` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_votes` VALUES
(1, 7, 863, '127.0.0.1', '2015-05-24 12:29:54', 1),
(2, 6, 863, '127.0.0.1', '2015-05-24 12:29:58', -1);

DROP TABLE IF EXISTS `#__k2_attachments`;
CREATE TABLE `#__k2_attachments` (
  `id` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `titleAttribute` text NOT NULL,
  `hits` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_categories`;
CREATE TABLE `#__k2_categories` (
  `id` int(11) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `parent` int(11) DEFAULT '0',
  `extraFieldsGroup` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `image` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_categories` VALUES
(4, 'Blog', 'blog', '', 0, 0, 1, 1, 2, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"1\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"1\",\"primaryImgSize\":\"XLarge\",\"num_secondary_items\":\"3\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"XLarge\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"order\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"1\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"1\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"0\",\"itemFullText\":\"1\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"0\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(6, 'Blank', 'blank', '', 0, 0, 1, 1, 1, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(13, 'Etiam eu nisl', 'etiam-eu-nisl', '', 4, 0, 1, 1, 2, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"XLarge\",\"num_secondary_items\":\"1\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"XLarge\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"0\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(21, 'Curabitur consectetur', 'curabitur-consectetur', '', 4, 0, 1, 1, 1, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"4\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"XLarge\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"2\",\"secondaryImgSize\":\"XLarge\",\"num_links\":\"4\",\"num_links_columns\":\"2\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"1\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"55\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"0\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(23, 'System', 'system', '', 0, 0, 1, 1, 3, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"0\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"0\",\"catItemDateCreated\":\"0\",\"catItemRating\":\"0\",\"catItemImage\":\"0\",\"catItemIntroText\":\"0\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"0\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"0\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"0\",\"itemDateCreated\":\"0\",\"itemTitle\":\"0\",\"itemFeaturedNotice\":\"0\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"0\",\"itemImage\":\"0\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"0\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"0\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"0\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(27, 'Custom pages', 'custom-pages', '<p>Custom pages</p>', 0, 0, 1, 1, 4, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*');

DROP TABLE IF EXISTS `#__k2_comments`;
CREATE TABLE `#__k2_comments` (
  `id` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) NOT NULL,
  `commentDate` datetime NOT NULL,
  `commentText` text NOT NULL,
  `commentEmail` varchar(255) NOT NULL,
  `commentURL` varchar(255) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_comments` VALUES
(7, 128, 0, 'uvelir', '2015-06-05 16:46:07', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'uvelir@uvelir.com', '', 1),
(8, 128, 0, 'coder', '2015-06-05 16:47:08', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder@coder.com', '', 1),
(9, 128, 0, 'coder2', '2015-06-05 17:02:18', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder2@coder2.com', '', 1),
(10, 128, 0, 'coder3', '2015-06-05 17:02:38', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder3@coder3.com', '', 1),
(11, 128, 0, 'coder4', '2015-06-05 17:02:52', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder3@coder4.com', '', 1),
(12, 128, 0, 'coder5', '2015-06-05 17:05:15', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder5@coder5.com', '', 1),
(13, 128, 0, 'coder6', '2015-06-05 17:05:26', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder5@coder6.com', '', 1),
(14, 128, 0, 'coder7', '2015-06-05 17:05:38', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder7@coder7.com', '', 1),
(15, 128, 0, 'coder8', '2015-06-05 17:05:51', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder8@coder8.com', '', 1),
(16, 128, 0, 'coder9', '2015-06-05 17:06:02', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder9@coder9.com', '', 1),
(17, 128, 0, 'coder11', '2015-06-05 17:06:19', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder11@coder11.com', '', 1),
(18, 128, 0, 'coder12', '2015-06-05 17:06:32', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder12@coder12.com', '', 1),
(19, 128, 0, 'coder13', '2015-06-05 17:06:47', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder13@coder13.com', '', 1),
(20, 128, 0, 'coder13', '2015-06-05 17:06:47', 'Maecenas adipiscing, tortor ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. Curabitur bibendum urna ligula, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.', 'coder13@coder13.com', '', 1);

DROP TABLE IF EXISTS `#__k2_extra_fields`;
CREATE TABLE `#__k2_extra_fields` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `group` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_extra_fields_groups`;
CREATE TABLE `#__k2_extra_fields_groups` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_items`;
CREATE TABLE `#__k2_items` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` smallint(6) NOT NULL DEFAULT '0',
  `featured_ordering` int(11) NOT NULL DEFAULT '0',
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_items` VALUES
(123, 'Lorem hac habitasse platea dictumst. Ut elit nisi', 'in-hac-habitasse-platea-dictumst-ut-elit-nisi', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"560\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2013-05-18 19:31:26', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:18:06', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 7, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(124, 'Magnum Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 19:45:24', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:17:12', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 6, 0, 0, '', '', '', '', 0, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(125, 'Ipsum Maecenas adipiscing, tortor ac iaculis blandit', 'maecenas-adipiscing-tortor-ac-iaculis-blandit', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 19:45:24', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:16:52', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 1, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(126, 'Ullamcorper Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 20:08:34', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:15:59', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 8, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(127, 'Morbius venenatis accumsan turpis, in bibendum arcu', 'morbi-venenatis-accumsan-turpis-in-bibendum-arcu', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 20:08:34', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:15:38', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 9, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(128, 'Ut elit nisi, vehicula id suscipit id', 'ut-elit-nisi-vehicula-id-suscipit-id', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at.  Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"560\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2013-05-19 08:09:03', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:14:57', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 54, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"1\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(38, 'In hac habitasse platea dictumst. Ut elit nisi', 'in-hac-habitasse-platea-dictumst-ut-elit-nisi', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"660\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2012-01-18 08:36:20', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:21:44', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 212, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"1\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(50, 'Integer faucibus hendrerit massa, ac tincidunt enim porta', 'integer-faucibus-hendrerit-massa-ac-tincidunt-enim-porta', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-01-26 17:22:57', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:21:11', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 5, 0, 0, '', '', '', '', 2, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(51, 'Morbi venenatis accumsan turpis, in bibendum arcu', 'morbi-venenatis-accumsan-turpis-in-bibendum-arcu', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-01-26 17:22:57', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:19:36', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 7, 0, 0, '', '', '', '', 64, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(66, 'Donec euismod ultricies metus, ac tempus sem vulputate eget', 'donec-euismod-ultricies-metus-ac-tempus-sem-vulputate-eget', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 07:17:13', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:19:10', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 5, 0, 0, '', '', '', '', 22, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(68, 'Maecenas adipiscing, tortor ac iaculis blandit', 'maecenas-adipiscing-tortor-ac-iaculis-blandit', 21, 0, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 00:00:00', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:18:45', 0, '2012-01-18 00:00:00', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 172, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(69, 'Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 07:17:13', 0, '', 0, '0000-00-00 00:00:00', '2015-07-19 18:18:25', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 142, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(70, '404 Page Not Found', '404-page-not-found', 23, 1, '<div class=\"img404\"><img src=\"images/404page.png\" border=\"0\" alt=\"404 Page not found\" /></div>\r\n<div class=\"text404\">\r\n<h1><strong>Sorry!</strong></h1>\r\n<h2>404 Page Not Found</h2>\r\n<p>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>\r\n<p>Please try using our search box below to look for information on the internet</p>\r\n{loadposition error404}</div>', '', NULL, NULL, '[]', '', '2012-05-31 11:37:17', 0, '', 0, '0000-00-00 00:00:00', '2013-05-16 19:55:35', 0, '2012-05-31 11:37:17', '0000-00-00 00:00:00', 1, 1, 1, 0, 0, '', '', '', '', 588, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(129, 'FAQs', 'faqs', 27, 1, '[accordion class=\"shop-accordion\"]\r\n[spoiler title=\"Proin adipiscing accumsan ornare\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>\r\n[/spoiler]\r\n[spoiler title=\"Cras hendrerit eget erat facilisis scelerisque\"]<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/spoiler]\r\n[spoiler title=\"Integer quis scelerisque augue, nec dictum urna\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh. Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis.</p>\r\n<p>Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/spoiler]\r\n[spoiler title=\"Maecenas porttitor facilisis sapien eget venenatis\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>\r\n[/spoiler]\r\n[spoiler title=\"Pellentesque condimentum sapien ut lectus dictum cursus\"]<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/spoiler]\r\n[spoiler title=\"Nunc ultricies eros eget ornare convallis\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh. Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis.</p>\r\n<p>Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/spoiler]\r\n[/accordion]', '', NULL, NULL, '[]', '', '2014-03-04 18:06:25', 0, '', 0, '0000-00-00 00:00:00', '2015-07-15 17:17:16', 0, '2014-03-04 18:06:25', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 57, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"0\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"0\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"\",\"itemHits\":\"0\",\"itemCategory\":\"0\",\"itemTags\":\"0\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(130, 'Features shortcodes', 'features-shortcodes', 27, 1, '<h3>Accordion</h3>\r\n[accordion class=\"shop-accordion\"]\r\n[spoiler title=\"Proin adipiscing accumsan ornare\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>\r\n[/spoiler]\r\n[spoiler title=\"Cras hendrerit eget erat facilisis scelerisque\"]<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/spoiler]\r\n[/accordion]\r\n<h3>Tabs Horizontal</h3>\r\n[tabs class=\"shop-tabs-horizontal\"][tab title=\"Title 1\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab]\r\n[tab title=\"Title 2\"]<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab]\r\n[tab title=\"Title 3\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab][/tabs]\r\n<h3>Tabs Vertical</h3>\r\n[tabs vertical=\"yes\" class=\"shop-tabs-vertical\"][tab title=\"Title 1\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab]\r\n[tab title=\"Title 2\"]<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab]\r\n[tab title=\"Title 3\"]<p>Integer quis scelerisque augue, nec dictum urna. Proin adipiscing accumsan ornare. Maecenas porttitor facilisis sapien eget venenatis. Pellentesque cursus convallis mi sit amet aliquet. In lorem quam, tristique at turpis vitae, varius aliquet nibh.</p>\r\n<p>Cras hendrerit eget erat facilisis scelerisque. Nunc ultricies eros eget ornare convallis. Morbi consequat turpis quis ipsum interdum mollis. Pellentesque condimentum sapien ut lectus dictum cursus. Praesent ac nunc egestas neque sodales suscipit iaculis eu diam. Nulla quis volutpat nunc. Integer faucibus interdum purus nec dapibus. Duis nec sem velit. Phasellus sit amet imperdiet dolor, quis tincidunt purus. Duis quam elit, ultrices id tincidunt a, pulvinar non tortor.</p>[/tab][/tabs]\r\n<h3>Gallery</h3>\r\n[photo_gallery source=\"media: images/custom/siberia_v2_frost_blue_51125_332596199685.jpg,images/custom/slc460w_c_wifi_slc460wxev_382723275821.jpg,images/custom/tracks_deadmau_5_364731395614.jpg,images/custom/transformer_pad_tf103c1a024a_black_384837267153.jpg\" order_by=\"asc\" class=\"shop-gallery\"]', '', NULL, NULL, '[]', '', '2014-04-21 17:07:36', 0, '', 0, '0000-00-00 00:00:00', '2015-07-16 09:33:17', 0, '2014-04-21 17:07:36', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 123, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"0\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"0\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"0\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"0\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(131, 'GDPR Privacy Policy', 'gdpr-privacy-policy', 23, 1, '<p>On May 25, 2018, the European Union\'s General Data Protection Regulation (GDPR) will go into effect across all European Union markets. We believe this presents a new opportunity for marketers to strengthen their brand loyalty by focusing on consumer privacy while delivering amazing experiences. Think of it as experiential privacy — having privacy be a key part of the customer experience, through relevant privacy notices presented in context and choices that are on brand. More info about <a href=\"https://gdpr-info.eu/\" target=\"_blank\" rel=\"noopener noreferrer\">GDPR</a>.</p>\r\n<h3><a title=\"Terms &amp; condition\" href=\"index.php?option=com_k2&amp;view=item&amp;layout=item&amp;id=132\">Terms &amp; condition</a></h3>\r\n<div class=\"clearfix\">\r\n<div class=\"sppb-addon\">\r\n<div class=\"sppb-addon-content\">\r\n<h3>Website privacy policy template</h3>\r\n<p>This privacy policy sets out how [business name] uses and protects any information that you give [business name] when you use this website.</p>\r\n<p>[business name] is committed to ensuring that your privacy is protected. Should we ask you to provide certain information by which you can be identified when using this website, then you can be assured that it will only be used in accordance with this privacy statement.</p>\r\n<p>[business name] may change this policy from time to time by updating this page. You should check this page from time to time to ensure that you are happy with any changes. This policy is effective from [date].<br /><br /></p>\r\n<h3>What we collect</h3>\r\n<p>We may collect the following information:</p>\r\n<ul>\r\n<li>name and job title</li>\r\n<li>contact information including email address</li>\r\n<li>demographic information such as postcode, preferences and interests</li>\r\n<li>other information relevant to customer surveys and/or offers</li>\r\n</ul>\r\n<br />\r\n<h3>What we do with the information we gather</h3>\r\n<p>We require this information to understand your needs and provide you with a better service, and in particular for the following reasons:</p>\r\n<ul>\r\n<li>Internal record keeping.</li>\r\n<li>We may use the information to improve our products and services.</li>\r\n<li>We may periodically send promotional emails about new products, special offers or other information which we think you may find interesting using the email address which you have provided.</li>\r\n<li>From time to time, we may also use your information to contact you for market research purposes. We may contact you by email, phone, fax or mail. We may use the information to customise the website according to your interests.</li>\r\n</ul>\r\n<h3><br />Security</h3>\r\n<p>We are committed to ensuring that your information is secure. In order to prevent unauthorised access or disclosure, we have put in place suitable physical, electronic and managerial procedures to safeguard and secure the information we collect online.<br /><br /></p>\r\n<h3>How we use cookies</h3>\r\n<p>A cookie is a small file which asks permission to be placed on your computer\'s hard drive. Once you agree, the file is added and the cookie helps analyse web traffic or lets you know when you visit a particular site. Cookies allow web applications to respond to you as an individual. The web application can tailor its operations to your needs, likes and dislikes by gathering and remembering information about your preferences.</p>\r\n<p>We use traffic log cookies to identify which pages are being used. This helps us analyse data about webpage traffic and improve our website in order to tailor it to customer needs. We only use this information for statistical analysis purposes and then the data is removed from the system.</p>\r\n<p>Overall, cookies help us provide you with a better website by enabling us to monitor which pages you find useful and which you do not. A cookie in no way gives us access to your computer or any information about you, other than the data you choose to share with us.</p>\r\n<p>You can choose to accept or decline cookies. Most web browsers automatically accept cookies, but you can usually modify your browser setting to decline cookies if you prefer. This may prevent you from taking full advantage of the website.<br /><br /></p>\r\n<h3>Links to other websites</h3>\r\n<p>Our website may contain links to other websites of interest. However, once you have used these links to leave our site, you should note that we do not have any control over that other website. Therefore, we cannot be responsible for the protection and privacy of any information which you provide whilst visiting such sites and such sites are not governed by this privacy statement. You should exercise caution and look at the privacy statement applicable to the website in question.<br /><br /></p>\r\n<h3>Controlling your personal information</h3>\r\n<p>You may choose to restrict the collection or use of your personal information in the following ways:</p>\r\n<ul>\r\n<li>whenever you are asked to fill in a form on the website, look for the box that you can click to indicate that you do not want the information to be used by anybody for direct marketing purposes</li>\r\n<li>if you have previously agreed to us using your personal information for direct marketing purposes, you may change your mind at any time by writing to or emailing us at [email address]</li>\r\n</ul>\r\n<p>We will not sell, distribute or lease your personal information to third parties unless we have your permission or are required by law to do so. We may use your personal information to send you promotional information about third parties which we think you may find interesting if you tell us that you wish this to happen.</p>\r\n<p>You may request details of personal information which we hold about you under the Data Protection Act 1998. A small fee will be payable. If you would like a copy of the information held on you please write to [address].</p>\r\n<p>If you believe that any information we are holding on you is incorrect or incomplete, please write to or email us as soon as possible at the above address. We will promptly correct any information found to be incorrect.<br /><br /></p>\r\n</div>\r\n</div>\r\n</div>', '', NULL, NULL, '[]', '', '2018-06-06 18:30:39', 889, '', 0, '0000-00-00 00:00:00', '2018-06-06 18:48:16', 889, '2018-06-06 18:30:39', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 11, '{\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemImageGalleryWidth\":\"\",\"catItemImageGalleryHeight\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemImageGalleryWidth\":\"\",\"itemImageGalleryHeight\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(132, 'TERMS and CONDITIONS', 'terms-and-conditions', 23, 1, '<h4>CONDITIONS OF USE</h4>\r\n<p>Welcome to our online store! MYCOMPANY and its associates provide their services to you subject to the following conditions. If you visit or shop within this website, you accept these conditions. Please read them carefully. ​<br /><br /></p>\r\n<h4>PRIVACY</h4>\r\n<p>Please review our Privacy Notice, which also governs your visit to our website, to understand our practices.<br /><br /></p>\r\n<h4>ELECTRONIC COMMUNICATIONS</h4>\r\n<p>When you visit MYCOMPANY or send e-mails to us, you are communicating with us electronically. You consent to receive communications from us electronically. We will communicate with you by e-mail or by posting notices on this site. You agree that all agreements, notices, disclosures and other communications that we provide to you electronically satisfy any legal requirement that such communications be in writing.<br /><br /></p>\r\n<h4>COPYRIGHT</h4>\r\n<p>All content included on this site, such as text, graphics, logos, button icons, images, audio clips, digital downloads, data compilations, and software, is the property of MYCOMPANY or its content suppliers and protected by international copyright laws. The compilation of all content on this site is the exclusive property of MYCOMPANY, with copyright authorship for this collection by MYCOMPANY, and protected by international copyright laws.<br /><br /></p>\r\n<h4>TRADE MARKS</h4>\r\n<p>MYCOMPANYs trademarks and trade dress may not be used in connection with any product or service that is not MYCOMPANYs, in any manner that is likely to cause confusion among customers, or in any manner that disparages or discredits MYCOMPANY. All other trademarks not owned by MYCOMPANY or its subsidiaries that appear on this site are the property of their respective owners, who may or may not be affiliated with, connected to, or sponsored by MYCOMPANY or its subsidiaries.<br /><br /></p>\r\n<h4>LICENSE AND SITE ACCESS</h4>\r\n<p>MYCOMPANY grants you a limited license to access and make personal use of this site and not to download (other than page caching) or modify it, or any portion of it, except with express written consent of MYCOMPANY. This license does not include any resale or commercial use of this site or its contents: any collection and use of any product listings, descriptions, or prices: any derivative use of this site or its contents: any downloading or copying of account information for the benefit of another merchant: or any use of data mining, robots, or similar data gathering and extraction tools. This site or any portion of this site may not be reproduced, duplicated, copied, sold, resold, visited, or otherwise exploited for any commercial purpose without express written consent of MYCOMPANY. You may not frame or utilize framing techniques to enclose any trademark, logo, or other proprietary information (including images, text, page layout, or form) of MYCOMPANY and our associates without express written consent. You may not use any meta tags or any other \"hidden text\" utilizing MYCOMPANYs name or trademarks without the express written consent of MYCOMPANY. Any unauthorized use terminates the permission or license granted by MYCOMPANY. You are granted a limited, revocable, and nonexclusive right to create a hyperlink to the home page of MYCOMPANY so long as the link does not portray MYCOMPANY, its associates, or their products or services in a false, misleading, derogatory, or otherwise offensive matter. You may not use any MYCOMPANY logo or other proprietary graphic or trademark as part of the link without express written permission.<br /><br /></p>\r\n<h4>YOUR MEMBERSHIP ACCOUNT</h4>\r\n<p>If you use this site, you are responsible for maintaining the confidentiality of your account and password and for restricting access to your computer, and you agree to accept responsibility for all activities that occur under your account or password. If you are under 18, you may use our website only with involvement of a parent or guardian. MYCOMPANY and its associates reserve the right to refuse service, terminate accounts, remove or edit content, or cancel orders in their sole discretion.<br /><br /></p>\r\n<h4>REVIEWS, COMMENTS, EMAILS, AND OTHER CONTENT</h4>\r\n<p>Visitors may post reviews, comments, and other content: and submit suggestions, ideas, comments, questions, or other information, so long as the content is not illegal, obscene, threatening, defamatory, invasive of privacy, infringing of intellectual property rights, or otherwise injurious to third parties or objectionable and does not consist of or contain software viruses, political campaigning, commercial solicitation, chain letters, mass mailings, or any form of \"spam.\" You may not use a false e-mail address, impersonate any person or entity, or otherwise mislead as to the origin of a card or other content. MYCOMPANY reserves the right (but not the obligation) to remove or edit such content, but does not regularly review posted content. If you do post content or submit material, and unless we indicate otherwise, you grant MYCOMPANY and its associates a nonexclusive, royalty-free, perpetual, irrevocable, and fully sublicensable right to use, reproduce, modify, adapt, publish, translate, create derivative works from, distribute, and display such content throughout the world in any media. You grant MYCOMPANY and its associates and sublicensees the right to use the name that you submit in connection with such content, if they choose. You represent and warrant that you own or otherwise control all of the rights to the content that you post: that the content is accurate: that use of the content you supply does not violate this policy and will not cause injury to any person or entity: and that you will indemnify MYCOMPANY or its associates for all claims resulting from content you supply. MYCOMPANY has the right but not the obligation to monitor and edit or remove any activity or content. MYCOMPANY takes no responsibility and assumes no liability for any content posted by you or any third party.<br /><br /></p>\r\n<h4>RISK OF LOSS</h4>\r\n<p>All items purchased from MYCOMPANY are made pursuant to a shipment contract. This basically means that the risk of loss and title for such items pass to you upon our delivery to the carrier.<br /><br /></p>\r\n<h4>PRODUCT DESCRIPTIONS</h4>\r\n<p>MYCOMPANY and its associates attempt to be as accurate as possible. However, MYCOMPANY does not warrant that product descriptions or other content of this site is accurate, complete, reliable, current, or error-free. If a product offered by MYCOMPANY itself is not as described, your sole remedy is to return it in unused condition. <br /><br />DISCLAIMER OF WARRANTIES AND LIMITATION OF LIABILITY THIS SITE IS PROVIDED BY MYCOMPANY ON AN \"AS IS\" AND \"AS AVAILABLE\" BASIS. MYCOMPANY MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, AS TO THE OPERATION OF THIS SITE OR THE INFORMATION, CONTENT, MATERIALS, OR PRODUCTS INCLUDED ON THIS SITE. YOU EXPRESSLY AGREE THAT YOUR USE OF THIS SITE IS AT YOUR SOLE RISK. TO THE FULL EXTENT PERMISSIBLE BY APPLICABLE LAW, MYCOMPANY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. MYCOMPANY DOES NOT WARRANT THAT THIS SITE, ITS SERVERS, OR E-MAIL SENT FROM MYCOMPANY ARE FREE OF VIRUSES OR OTHER HARMFUL COMPONENTS. MYCOMPANY WILL NOT BE LIABLE FOR ANY DAMAGES OF ANY KIND ARISING FROM THE USE OF THIS SITE, INCLUDING, BUT NOT LIMITED TO DIRECT, INDIRECT, INCIDENTAL, PUNITIVE, AND CONSEQUENTIAL DAMAGES. CERTAIN STATE LAWS DO NOT ALLOW LIMITATIONS ON IMPLIED WARRANTIES OR THE EXCLUSION OR LIMITATION OF CERTAIN DAMAGES. IF THESE LAWS APPLY TO YOU, SOME OR ALL OF THE ABOVE DISCLAIMERS, EXCLUSIONS, OR LIMITATIONS MAY NOT APPLY TO YOU, AND YOU MIGHT HAVE ADDITIONAL RIGHTS.<br /><br /></p>\r\n<h4>APPLICABLE LAW</h4>\r\n<p>By visiting MYCOMPANY, you agree that the laws of the state of DEFINE_STATE, DEFINE_COUNTRY, without regard to principles of conflict of laws, will govern these Conditions of Use and any dispute of any sort that might arise between you and MYCOMPANY or its associates.<br /><br /></p>\r\n<h4>DISPUTES</h4>\r\n<p>Any dispute relating in any way to your visit to MYCOMPANY or to products you purchase through MYCOMPANY shall be submitted to confidential arbitration in DEFINE_STATE, DEFINE_COUNTRY, except that, to the extent you have in any manner violated or threatened to violate MYCOMPANYs intellectual property rights, MYCOMPANY may seek injunctive or other appropriate relief in any state or federal court in the state of DEFINE_STATE, DEFINE_COUNTRY, and you consent to exclusive jurisdiction and venue in such courts. Arbitration under this agreement shall be conducted under the rules then prevailing of the American Arbitration Association. The arbitrators award shall be binding and may be entered as a judgment in any court of competent jurisdiction. To the fullest extent permitted by applicable law, no arbitration under this Agreement shall be joined to an arbitration involving any other party subject to this Agreement, whether through class arbitration proceedings or otherwise.<br /><br /></p>\r\n<h4>SITE POLICIES, MODIFICATION, AND SEVERABILITY</h4>\r\n<p>Please review our other policies, such as our Shipping and Returns policy, posted on this site. These policies also govern your visit to MYCOMPANY. We reserve the right to make changes to our site, policies, and these Conditions of Use at any time. If any of these conditions shall be deemed invalid, void, or for any reason unenforceable, that condition shall be deemed severable and shall not affect the validity and enforceability of any remaining condition.<br /><br /><br /></p>', '', NULL, NULL, '[]', '', '2018-06-06 18:33:36', 889, '', 0, '0000-00-00 00:00:00', '2018-06-06 18:34:29', 889, '2018-06-06 18:30:39', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 2, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemImageGalleryWidth\":\"\",\"catItemImageGalleryHeight\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemImageGalleryWidth\":\"\",\"itemImageGalleryHeight\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*');

DROP TABLE IF EXISTS `#__k2_log`;
CREATE TABLE `#__k2_log` (
  `status` int(11) NOT NULL,
  `response` text NOT NULL,
  `timestamp` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_log` VALUES
(200, 'Anonymous metrics submitted - thank you for helping make K2 better!', '2019-06-21 21:34:05');

DROP TABLE IF EXISTS `#__k2_rating`;
CREATE TABLE `#__k2_rating` (
  `itemID` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_rating` VALUES
(69, 5, 1, '127.0.0.1'),
(38, 5, 1, '127.0.0.1'),
(68, 4, 1, '127.0.0.1'),
(66, 3, 1, '127.0.0.1'),
(123, 3, 1, '127.0.0.1'),
(126, 5, 1, '127.0.0.1'),
(127, 5, 1, '127.0.0.1'),
(130, 5, 1, '127.0.0.1'),
(51, 5, 1, '127.0.0.1'),
(50, 5, 1, '127.0.0.1'),
(125, 5, 1, '127.0.0.1'),
(128, 2, 1, '127.0.0.1');

DROP TABLE IF EXISTS `#__k2_tags`;
CREATE TABLE `#__k2_tags` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_tags_xref`;
CREATE TABLE `#__k2_tags_xref` (
  `id` int(11) NOT NULL,
  `tagID` int(11) NOT NULL,
  `itemID` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_users`;
CREATE TABLE `#__k2_users` (
  `id` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `gender` enum('m','f') NOT NULL DEFAULT 'm',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `group` int(11) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `notes` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_user_groups`;
CREATE TABLE `#__k2_user_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `permissions` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_user_groups` VALUES
(1, 'Registered', '{\"comment\":\"1\",\"frontEdit\":\"0\",\"add\":\"0\",\"editOwn\":\"0\",\"editAll\":\"0\",\"publish\":\"0\",\"inheritance\":0,\"categories\":\"all\"}'),
(2, 'Site Owner', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"inheritance\":1,\"categories\":\"all\"}'),
(4, 'Admin', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"editPublished\":\"1\",\"inheritance\":\"1\",\"categories\":\"all\"}');

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__languages` VALUES
(1, 0, 'en-GB', 'English(UK)', 'English', 'en', 'en', '', '', '', '', 1, 1, 1),
(2, 0, 'de-DE', 'German (DE)', 'German', 'de', 'de', '', '', '', '', 1, 1, 0),
(3, 0, 'fr-FR', 'French (FR)', 'French', 'fr', 'fr', '', '', '', '', 1, 1, 0),
(4, 0, 'it-IT', 'Italian (IT)', 'Italian', 'it', 'it', '', '', '', '', 1, 1, 0),
(5, 0, 'ru-RU', 'Russian (RU)', 'Russian', 'ru', 'ru', '', '', '', '', 1, 1, 0);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__menu` VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 325, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 139, 144, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 140, 141, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 142, 143, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 145, 148, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 146, 147, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 149, 154, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 150, 151, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 152, 153, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 161, 162, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 159, 160, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 157, 158, 0, '*', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 155, 156, 1, '*', 0),
(104, 'main', 'COM_COMPARE_MENU', 'com-compare-menu', '', 'com-compare-menu', 'index.php?option=com_comparelist', 'component', 1, 1, 1, 10031, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 163, 164, 0, '', 1),
(105, 'main', 'COM_WHISHLISTS_MENU', 'com-whishlists-menu', '', 'com-whishlists-menu', 'index.php?option=com_wishlists', 'component', 1, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 165, 166, 0, '', 1),
(106, 'main-menu-de', 'Home ', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 167, 168, 1, 'de-DE', 0),
(107, 'main-menu-en', 'Home ', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 169, 170, 1, 'en-GB', 0),
(108, 'main-menu-fr', 'Home ', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 171, 172, 1, 'fr-FR', 0),
(109, 'main-menu-it', 'Home ', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 173, 174, 1, 'it-IT', 0),
(110, 'main-menu-ru', 'Home ', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 175, 176, 1, 'ru-RU', 0),
(111, 'top-menu', 'My Account', 'my-account', '', 'my-account', 'index.php?option=com_virtuemart&view=user&layout=edit', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"My Account\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 177, 178, 0, '*', 0),
(112, 'top-menu', 'Orders List', 'orders-list', '', 'orders-list', 'index.php?option=com_virtuemart&view=orders&layout=list', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Orders List\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 179, 180, 0, '*', 0),
(113, 'top-menu', 'Shopping Cart', 'shopping-cart', 'Checkout', 'shopping-cart', 'index.php?option=com_virtuemart&view=cart', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Checkout\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 181, 182, 0, '*', 0),
(114, 'navigation', 'Home page', 'home-page', '', 'home-page', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 25, 48, 0, '*', 0),
(115, 'navigation', 'Sliders', 'sliders', '', 'sliders', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1}', 49, 60, 0, '*', 0),
(116, 'navigation', 'Cameras', 'cameras', '', 'cameras', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=1&virtuemart_manufacturer_id=0', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"0\",\"show_store_desc\":\"\",\"categorylayout\":\"default\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"default\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"products_horizon\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Cameras\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 61, 98, 0, '*', 0),
(117, 'navigation', 'Computers', 'men', '', 'men', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=2&virtuemart_manufacturer_id=0', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"1\",\"categories_per_row\":\"\",\"showproducts\":\"1\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Computers\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 103, 116, 0, '*', 0),
(118, 'navigation', 'Shop', 'shop', '', 'shop', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shop\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 117, 128, 0, '*', 0),
(119, 'system-menu', 'Compare List', 'compare-list', '', 'compare-list', 'index.php?option=com_comparelist&view=comparelist', 'component', 1, 1, 1, 10031, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Compare products\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 183, 184, 0, '*', 0),
(120, 'system-menu', 'Wishlist products', 'wishlist-products', '', 'wishlist-products', 'index.php?option=com_wishlists&view=wishlists', 'component', 1, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Wishlist products\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 185, 186, 0, '*', 0),
(121, 'navigation', 'Blog', 'blog', '', 'blog', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=4', 'component', 1, 1, 1, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"4\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Blog\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 129, 136, 0, '*', 0),
(154, 'navigation', 'Revolutions slider ', 'sliders-2', '', 'sliders/sliders-2', '#', 'url', -2, 115, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 56, 57, 0, '*', 0),
(155, 'navigation', 'Sliders (3)', 'sliders-3', '', 'sliders/sliders-3', '#', 'url', -2, 115, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 58, 59, 0, '*', 0),
(158, 'the-service', 'My account', 'account', '', 'account', 'index.php?Itemid=', 'alias', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"111\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 11, 12, 0, '*', 0),
(159, 'the-service', 'Order history', 'order-history', '', 'order-history', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"112\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 13, 14, 0, '*', 0),
(160, 'the-service', 'Wishlist', 'wishlist', '', 'wishlist', 'index.php?Itemid=', 'alias', -2, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"120\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 21, 22, 0, '*', 0),
(161, 'the-service', 'Vendor contact', 'vendor-contact', '', 'vendor-contact', 'index.php?option=com_virtuemart&view=vendor&layout=contact&virtuemart_vendor_id=1', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 15, 16, 0, '*', 0),
(162, 'the-service', 'Shop', 'shop-page', '', 'shop-page', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"118\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 17, 18, 0, '*', 0),
(163, 'the-service', 'Virtuemart categories', 'virtuemart-categories', '', 'virtuemart-categories', 'index.php?Itemid=', 'alias', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"117\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 23, 24, 0, '*', 0),
(164, 'information', 'About us', 'about-us', '', 'about-us', 'index.php?option=com_virtuemart&view=vendor&layout=details&virtuemart_vendor_id=1', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"About us\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 187, 188, 0, '*', 0),
(165, 'information', 'New collection', 'new-collection', '', 'new-collection', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"116\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 189, 190, 0, '*', 0),
(166, 'information', 'Bestsellers', 'best-sellers', '', 'best-sellers', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"129\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 191, 192, 0, '*', 0),
(167, 'information', 'Manufacturers', 'manufacturers', '', 'manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Manufacturers\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 193, 194, 0, '*', 0),
(168, 'information', 'GDPR Privacy Policy', 'gdpr-privacy-policy', '', 'gdpr-privacy-policy', 'index.php?option=com_k2&view=item&layout=item&id=131', 'component', 1, 1, 1, 10080, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 195, 196, 0, '*', 0),
(169, 'information', 'Terms & condition', 'terms-condition', '', 'terms-condition', 'index.php?option=com_k2&view=item&layout=item&id=132', 'component', 1, 1, 1, 10080, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 197, 198, 0, '*', 0),
(190, 'navigation', 'Categories (1)', 'categories-1', '', 'blog/categories-1', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=21', 'component', 1, 121, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"21\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (1)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 130, 131, 0, '*', 0),
(191, 'navigation', 'Categories (2)', 'categories-2', '', 'blog/categories-2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=13', 'component', 1, 121, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"13\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (2)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 132, 133, 0, '*', 0),
(192, 'navigation', 'Categories (3)', 'categories-3', '', 'blog/categories-3', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=19', 'component', -2, 121, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"19\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (3)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 134, 135, 0, '*', 0),
(194, 'system-menu', 'VM2 Tags', 'vm2-tags', '', 'vm2-tags', 'index.php?option=com_cooltags&view=productslist', 'component', 1, 1, 1, 10211, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"VM2 Tags\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 199, 200, 0, '*', 0),
(195, 'search-param', 'Search', 'vm-search', 'vm-search', 'vm-search', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"vm-search\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 201, 202, 0, '*', 0),
(196, 'navigation', 'Contacts', 'contacts', '', 'contacts', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"presentation_style\":\"plain\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"0\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Contact Us\",\"show_page_heading\":0,\"page_heading\":\"Contact Us\",\"pageclass_sfx\":\"Contact\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 137, 138, 0, '*', 0),
(197, 'system-menu', 'User Registration', 'user-registration', '', 'user-registration', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"User Registration\",\"show_page_heading\":\"0\",\"page_heading\":\"User Registration\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 203, 204, 0, '*', 0),
(198, 'system-menu', 'User Reset', 'user-reset', '', 'user-reset', 'index.php?option=com_users&view=reset', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"User Registration\",\"show_page_heading\":0,\"page_heading\":\"User Registration\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 205, 206, 0, '*', 0),
(199, 'system-menu', 'User Remind', 'user-remind', '', 'user-remind', 'index.php?option=com_users&view=remind', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"User Remind\",\"show_page_heading\":0,\"page_heading\":\"User Remind\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 207, 208, 0, '*', 0),
(200, 'system-menu', 'Edit User Profile', 'edit-user-profile', '', 'edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', 0, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Edit User Profile\",\"show_page_heading\":0,\"page_heading\":\"Edit User Profile\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 209, 210, 0, '*', 0),
(201, 'navigation', 'Home Full Width', 'home-full-width', '', 'home-page/home-full-width', 'index.php?option=com_content&view=featured', 'component', 1, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 22, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home Full Width\",\"show_page_heading\":\"0\",\"page_heading\":\"Home Full Width\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 26, 27, 0, '*', 0),
(202, 'navigation', 'Home Right Sidebar', 'home-right-sidebar', '', 'home-page/home-right-sidebar', 'index.php?option=com_content&view=featured', 'component', 1, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 23, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home Right Sidebar\",\"show_page_heading\":0,\"page_heading\":\"Home Right Sidebar\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 28, 29, 0, '*', 0),
(203, 'navigation', 'Home boxed', 'home-boxed', '', 'home-page/home-boxed', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 10, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home boxed\",\"show_page_heading\":0,\"page_heading\":\"Home boxed\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 30, 31, 0, '*', 0),
(206, 'navigation', 'Revolutions slider ', 'revolutions-slider', '', 'sliders/revolutions-slider', 'index.php?option=com_content&view=featured', 'component', 1, 115, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Revolutions slider \",\"show_page_heading\":0,\"page_heading\":\"Revolutions slider \",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 50, 51, 0, '*', 0),
(207, 'navigation', 'Home boxed left sidebar', 'home-boxed-left-sidebar', '', 'home-page/home-boxed-left-sidebar', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 10, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home boxed left sidebar\",\"show_page_heading\":0,\"page_heading\":\"Home boxed left sidebar\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 32, 33, 0, '*', 0),
(208, 'navigation', 'Home Izotop Products', 'home-izotop-products', '', 'home-page/home-izotop-products', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home Izotop Products\",\"show_page_heading\":0,\"page_heading\":\"Home Izotop Products\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 34, 35, 0, '*', 0),
(209, 'navigation', 'Camera slideshow ', 'camera-slideshow', '', 'sliders/camera-slideshow', 'index.php?option=com_content&view=featured', 'component', -2, 115, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Camera slideshow \",\"show_page_heading\":0,\"page_heading\":\"Camera slideshow \",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 54, 55, 0, '*', 0),
(210, 'navigation', 'Theme blue', 'theme-blue', '', 'shop/theme-blue', 'index.php?option=com_content&view=featured', 'component', 1, 118, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 25, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Theme blue\",\"show_page_heading\":0,\"page_heading\":\"Theme blue\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 122, 123, 0, '*', 0),
(214, 'navigation', 'FAQs', 'faqs', '', 'shop/faqs', 'index.php?option=com_k2&view=item&layout=item&id=129', 'component', 1, 118, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"FAQs\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 118, 119, 0, '*', 0),
(215, 'navigation', 'Theme green', 'theme-green', '', 'shop/theme-green', 'index.php?option=com_content&view=featured', 'component', 1, 118, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 24, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Theme green\",\"show_page_heading\":0,\"page_heading\":\"Theme green\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 124, 125, 0, '*', 0),
(216, 'navigation', 'Theme orange', 'theme-orange', '', 'shop/theme-orange', 'index.php?option=com_content&view=featured', 'component', 0, 118, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Theme orange\",\"show_page_heading\":0,\"page_heading\":\"Theme orange\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 126, 127, 0, '*', 0),
(219, 'navigation', 'Home Izotop Products More', 'home-izotop-products-more', '', 'home-page/home-izotop-products-more', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home Izotop Products More\",\"show_page_heading\":0,\"page_heading\":\"Home Izotop Products More\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 36, 37, 0, '*', 0),
(222, 'navigation', 'Smart Slider', 'smart-slider', '', 'sliders/smart-slider', 'index.php?option=com_content&view=featured', 'component', -2, 115, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Smart Slider\",\"show_page_heading\":0,\"page_heading\":\"Smart Slider\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 52, 53, 0, '*', 0),
(238, 'navigation', 'Home page2', 'home-page2', '', 'home-page/home-page2', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 15, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home page2\",\"show_page_heading\":0,\"page_heading\":\"Home page2\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 38, 39, 0, '*', 0),
(239, 'navigation', 'Home boxed page2', 'home-boxed-page2', '', 'home-page/home-boxed-page2', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 16, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home boxed page2\",\"show_page_heading\":0,\"page_heading\":\"Home boxed page2\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 40, 41, 0, '*', 0),
(240, 'navigation', 'Shortcodes', 'shortcodes', '', 'shop/shortcodes', 'index.php?option=com_k2&view=item&layout=item&id=130', 'component', 1, 118, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shortcodes\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 120, 121, 0, '*', 0),
(267, 'navigation', 'Home page3', 'home-page3', '', 'home-page/home-page3', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 17, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home page3\",\"show_page_heading\":0,\"page_heading\":\"Home page3\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 42, 43, 0, '*', 0),
(268, 'navigation', 'Home page4', 'home-page4', '', 'home-page/home-page4', 'index.php?option=com_content&view=featured', 'component', -2, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 18, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"show_feed_link\":\"0\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home page4\",\"show_page_heading\":0,\"page_heading\":\"Home page4\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 44, 45, 0, '*', 0),
(269, 'top-menu2', 'My Account', 'myaccount', '', 'myaccount', 'index.php?option=com_users&view=profile', 'component', -2, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Account\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 211, 212, 0, '*', 0),
(294, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 99, 100, 0, '', 1),
(295, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 101, 102, 0, '*', 1),
(356, 'main', 'COM_COOLTAGS', 'com-cooltags', '', 'com-cooltags', 'index.php?option=com_cooltags', 'component', 1, 1, 1, 10211, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_cooltags/assets/images/s_com_cooltags.png', 0, '', 213, 216, 0, '', 1),
(357, 'main', 'COM_COOLTAGS_LEGACYSWITCH', 'com-cooltags-legacyswitch', '', 'com-cooltags/com-cooltags-legacyswitch', 'index.php?option=com_cooltags&view=legacyswitch', 'component', 1, 356, 2, 10211, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 214, 215, 0, '', 1),
(431, 'main', 'COM_JCOMMENTS', 'com-jcomments', '', 'com-jcomments', 'index.php?option=com_jcomments', 'component', 1, 1, 1, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_jcomments/assets/images/icon-16-jcomments.png', 0, '', 217, 236, 0, '', 1),
(432, 'main', 'COM_JCOMMENTS_COMMENTS', 'com-jcomments-comments', '', 'com-jcomments/com-jcomments-comments', 'index.php?option=com_jcomments&view=comments', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-comments', 0, '', 218, 219, 0, '', 1),
(433, 'main', 'COM_JCOMMENTS_SETTINGS', 'com-jcomments-settings', '', 'com-jcomments/com-jcomments-settings', 'index.php?option=com_jcomments&view=settings', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-settings', 0, '', 220, 221, 0, '', 1),
(434, 'main', 'COM_JCOMMENTS_SMILIES', 'com-jcomments-smilies', '', 'com-jcomments/com-jcomments-smilies', 'index.php?option=com_jcomments&view=smilies', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-smilies', 0, '', 222, 223, 0, '', 1),
(435, 'main', 'COM_JCOMMENTS_SUBSCRIPTIONS', 'com-jcomments-subscriptions', '', 'com-jcomments/com-jcomments-subscriptions', 'index.php?option=com_jcomments&view=subscriptions', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-subscriptions', 0, '', 224, 225, 0, '', 1),
(436, 'main', 'COM_JCOMMENTS_CUSTOM_BBCODE', 'com-jcomments-custom-bbcode', '', 'com-jcomments/com-jcomments-custom-bbcode', 'index.php?option=com_jcomments&view=custombbcodes', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-custombbcodes', 0, '', 226, 227, 0, '', 1),
(437, 'main', 'COM_JCOMMENTS_BLACKLIST', 'com-jcomments-blacklist', '', 'com-jcomments/com-jcomments-blacklist', 'index.php?option=com_jcomments&view=blacklists', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-blacklist', 0, '', 228, 229, 0, '', 1),
(438, 'main', 'COM_JCOMMENTS_MAILQ', 'com-jcomments-mailq', '', 'com-jcomments/com-jcomments-mailq', 'index.php?option=com_jcomments&view=mailq', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-mailq', 0, '', 230, 231, 0, '', 1),
(439, 'main', 'COM_JCOMMENTS_IMPORT', 'com-jcomments-import', '', 'com-jcomments/com-jcomments-import', 'index.php?option=com_jcomments&view=import', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-import', 0, '', 232, 233, 0, '', 1),
(440, 'main', 'COM_JCOMMENTS_ABOUT', 'com-jcomments-about', '', 'com-jcomments/com-jcomments-about', 'index.php?option=com_jcomments&view=about', 'component', 1, 431, 2, 10222, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-about', 0, '', 234, 235, 0, '', 1),
(452, 'top-menu', 'Dress', 'dress', '', 'dress', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=3&virtuemart_manufacturer_id=0', 'component', -2, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 237, 238, 0, '*', 0),
(453, 'navigation', 'Dress (2)', 'dress-2', '', 'dress-2', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=3&virtuemart_manufacturer_id=0', 'component', -2, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 239, 240, 0, '*', 0),
(454, 'navigation', 'Donec ultricies', 'donec-ultricies', '', 'cameras/donec-ultricies', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=4&virtuemart_manufacturer_id=0', 'component', 1, 116, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"0\",\"show_store_desc\":\"\",\"categorylayout\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"products_horizon\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec ultricies\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 62, 73, 0, '*', 0),
(455, 'navigation', 'Proin lobortis', 'proin-lobortis', '', 'cameras/donec-ultricies/proin-lobortis', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=7&virtuemart_manufacturer_id=0', 'component', -2, 454, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Proin lobortis\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 63, 64, 0, '*', 0),
(456, 'navigation', 'Ut mi erat, co', 'ut-mi-erat-co', '', 'cameras/donec-ultricies/ut-mi-erat-co', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=9&virtuemart_manufacturer_id=0', 'component', -2, 454, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Ut mi erat, co\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 65, 66, 0, '*', 0),
(457, 'navigation', 'Sed in dui et', 'sed-in-dui-et', '', 'cameras/donec-ultricies/sed-in-dui-et', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=10&virtuemart_manufacturer_id=0', 'component', -2, 454, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sed in dui et\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 67, 68, 0, '*', 0),
(458, 'navigation', 'Proin viverra, ur', 'proin-viverra-ur', '', 'cameras/donec-ultricies/proin-viverra-ur', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=11&virtuemart_manufacturer_id=0', 'component', -2, 454, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Proin viverra, ur\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 69, 70, 0, '*', 0),
(459, 'navigation', 'Donec ultricies', 'donec-ultricies-1', '', 'cameras/donec-ultricies/donec-ultricies-1', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=12&virtuemart_manufacturer_id=0', 'component', -2, 454, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"0\",\"show_store_desc\":\"\",\"categorylayout\":\"default\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"1\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"default\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"1\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"products_horizon\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec ultricies\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 71, 72, 0, '*', 0),
(460, 'navigation', 'Sed sapien sap', 'sed-sapien-sap', '', 'cameras/sed-sapien-sap', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=5&virtuemart_manufacturer_id=0', 'component', 1, 116, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_store_desc\":\"\",\"categorylayout\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sed sapien sap\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 74, 85, 0, '*', 0),
(461, 'navigation', 'Ut vitae neque', 'ut-vitae-neque', '', 'cameras/sed-sapien-sap/ut-vitae-neque', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=15&virtuemart_manufacturer_id=0', 'component', -2, 460, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Ut vitae neque\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 75, 76, 0, '*', 0),
(462, 'navigation', 'Ut mi erat, conse', 'ut-mi-erat-conse', '', 'cameras/sed-sapien-sap/ut-mi-erat-conse', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=16&virtuemart_manufacturer_id=0', 'component', -2, 460, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Ut mi erat, conse\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 77, 78, 0, '*', 0),
(463, 'navigation', 'Sed in dui et', 'sed-in-dui-et-1', '', 'cameras/sed-sapien-sap/sed-in-dui-et-1', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=17&virtuemart_manufacturer_id=0', 'component', -2, 460, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sed in dui et\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 79, 80, 0, '*', 0),
(464, 'navigation', 'Proin viverra, ur', 'proin-viverra-ur-1', '', 'cameras/sed-sapien-sap/proin-viverra-ur-1', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=18&virtuemart_manufacturer_id=0', 'component', -2, 460, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Proin viverra, ur\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 81, 82, 0, '*', 0),
(465, 'navigation', 'Donec ultric', 'donec-ultric', '', 'cameras/sed-sapien-sap/donec-ultric', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=19&virtuemart_manufacturer_id=0', 'component', -2, 460, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec ultric\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 83, 84, 0, '*', 0),
(466, 'navigation', 'Vestibulum faucibus', 'vestibulum-faucibus', '', 'cameras/vestibulum-faucibus', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=6&virtuemart_manufacturer_id=0', 'component', 1, 116, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_store_desc\":\"\",\"categorylayout\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Vestibulum faucibus\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 86, 97, 0, '*', 0),
(467, 'navigation', 'Ut mi erat, consec', 'ut-mi-erat-consec', '', 'cameras/vestibulum-faucibus/ut-mi-erat-consec', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=22&virtuemart_manufacturer_id=0', 'component', -2, 466, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Ut mi erat, consec\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 87, 88, 0, '*', 0),
(468, 'navigation', 'Sed in dui et mau', 'sed-in-dui-et-mau', '', 'cameras/vestibulum-faucibus/sed-in-dui-et-mau', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=23&virtuemart_manufacturer_id=0', 'component', -2, 466, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sed in dui et mau\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 89, 90, 0, '*', 0),
(469, 'navigation', 'Proin viverra, nec', 'proin-viverra-nec', '', 'cameras/vestibulum-faucibus/proin-viverra-nec', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=24&virtuemart_manufacturer_id=0', 'component', -2, 466, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Proin viverra, nec\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 91, 92, 0, '*', 0),
(470, 'navigation', 'Donec ultricies tin', 'donec-ultricies-tin', '', 'cameras/vestibulum-faucibus/donec-ultricies-tin', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=25&virtuemart_manufacturer_id=0', 'component', -2, 466, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec ultricies tin\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 93, 94, 0, '*', 0),
(471, 'navigation', 'Donec ultricies nisi', 'donec-ultricies-nisi', '', 'cameras/vestibulum-faucibus/donec-ultricies-nisi', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=26&virtuemart_manufacturer_id=0', 'component', -2, 466, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec ultricies nisi\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 95, 96, 0, '*', 0),
(472, 'navigation', 'Ut mi erat, consecte', 'ut-mi-erat-consecte', '', 'men/ut-mi-erat-consecte', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=29&virtuemart_manufacturer_id=0', 'component', 1, 117, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Ut mi erat, consecte\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 104, 105, 0, '*', 0),
(473, 'navigation', 'Sed in dui ullamcorper', 'sed-in-dui-ullamcorper', '', 'men/sed-in-dui-ullamcorper', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=30&virtuemart_manufacturer_id=0', 'component', 1, 117, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sed in dui ullamcorper\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 106, 111, 0, '*', 0),
(474, 'navigation', 'Donec tincidunt eget', 'donec-tincidunt-eget', '', 'men/sed-in-dui-ullamcorper/donec-tincidunt-eget', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=27&virtuemart_manufacturer_id=0', 'component', 1, 473, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Donec tincidunt eget\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 107, 108, 0, '*', 0),
(475, 'navigation', 'Cras quis odio', 'cras-quis-odio', '', 'men/sed-in-dui-ullamcorper/cras-quis-odio', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=28&virtuemart_manufacturer_id=0', 'component', 1, 473, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Cras quis odio\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 109, 110, 0, '*', 0),
(476, 'navigation', 'Quisque ullamcorper', 'quisque-ullamcorper', '', 'men/quisque-ullamcorper', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=31&virtuemart_manufacturer_id=0', 'component', 1, 117, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Quisque ullamcorper\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 112, 113, 0, '*', 0),
(477, 'navigation', 'Fusce condimentu', 'fusce-condimentu', '', 'men/fusce-condimentu', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=32&virtuemart_manufacturer_id=0', 'component', 1, 117, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"storefront\":\"\",\"categorylayout\":\"\",\"show_store_desc\":\"\",\"showcategory_desc\":\"\",\"showcategory\":\"\",\"categories_per_row\":\"\",\"showproducts\":\"\",\"showsearch\":\"\",\"productsublayout\":\"products_horizon\",\"products_per_row\":\"\",\"featured\":\"\",\"featured_rows\":\"\",\"discontinued\":\"\",\"discontinued_rows\":\"\",\"latest\":\"\",\"latest_rows\":\"\",\"topten\":\"\",\"topten_rows\":\"\",\"recent\":\"\",\"recent_rows\":\"\",\"stf_itemid\":\"\",\"stf_categorylayout\":\"\",\"stf_show_store_desc\":\"\",\"stf_showcategory_desc\":\"\",\"stf_showcategory\":\"\",\"stf_categories_per_row\":\"\",\"stf_showproducts\":\"\",\"stf_showsearch\":\"\",\"stf_productsublayout\":\"\",\"stf_products_per_row\":\"\",\"stf_featured\":\"\",\"stf_featured_rows\":\"\",\"stf_discontinued\":\"\",\"stf_discontinued_rows\":\"\",\"stf_latest\":\"\",\"stf_latest_rows\":\"\",\"stf_topten\":\"\",\"stf_topten_rows\":\"\",\"stf_recent\":\"\",\"stf_recent_rows\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Fusce condimentu\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 114, 115, 0, '*', 0),
(481, 'the-service', 'Search results', 'search-results', '', 'search-results', 'index.php?option=com_search&view=search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"search_areas\":\"\",\"show_date\":\"\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 19, 20, 0, '*', 0),
(626, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 1, 'class:joomlaupdate', 0, '{}', 241, 242, 0, '', 1),
(628, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 243, 244, 0, '*', 1),
(644, 'main', 'com_weblinks', 'com-weblinks', '', 'com-weblinks', 'index.php?option=com_weblinks', 'component', 1, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks', 0, '{}', 245, 250, 0, '', 1),
(645, 'main', 'com_weblinks_links', 'com-weblinks-links', '', 'com-weblinks/com-weblinks-links', 'index.php?option=com_weblinks', 'component', 1, 644, 2, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks', 0, '{}', 246, 247, 0, '', 1),
(646, 'main', 'com_weblinks_categories', 'com-weblinks-categories', '', 'com-weblinks/com-weblinks-categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 1, 644, 2, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks-cat', 0, '{}', 248, 249, 0, '', 1),
(842, 'main', 'COM_K2', 'com-k2', '', 'com-k2', 'index.php?option=com_k2', 'component', 1, 1, 1, 10080, 0, '0000-00-00 00:00:00', 0, 1, '../media/k2/assets/images/backend/k2_logo_16x16.png', 0, '{}', 251, 272, 0, '', 1),
(843, 'main', 'K2_ITEMS', 'k2-items', '', 'com-k2/k2-items', 'index.php?option=com_k2&view=items', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 252, 253, 0, '', 1),
(844, 'main', 'K2_CATEGORIES', 'k2-categories', '', 'com-k2/k2-categories', 'index.php?option=com_k2&view=categories', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 254, 255, 0, '', 1),
(845, 'main', 'K2_TAGS', 'k2-tags', '', 'com-k2/k2-tags', 'index.php?option=com_k2&view=tags', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 256, 257, 0, '', 1),
(846, 'main', 'K2_COMMENTS', 'k2-comments', '', 'com-k2/k2-comments', 'index.php?option=com_k2&view=comments', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 258, 259, 0, '', 1),
(847, 'main', 'K2_USERS', 'k2-users', '', 'com-k2/k2-users', 'index.php?option=com_k2&view=users', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 260, 261, 0, '', 1),
(848, 'main', 'K2_USER_GROUPS', 'k2-user-groups', '', 'com-k2/k2-user-groups', 'index.php?option=com_k2&view=usergroups', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 262, 263, 0, '', 1),
(849, 'main', 'K2_EXTRA_FIELDS', 'k2-extra-fields', '', 'com-k2/k2-extra-fields', 'index.php?option=com_k2&view=extrafields', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 264, 265, 0, '', 1),
(850, 'main', 'K2_EXTRA_FIELD_GROUPS', 'k2-extra-field-groups', '', 'com-k2/k2-extra-field-groups', 'index.php?option=com_k2&view=extrafieldsgroups', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 266, 267, 0, '', 1),
(851, 'main', 'K2_MEDIA_MANAGER', 'k2-media-manager', '', 'com-k2/k2-media-manager', 'index.php?option=com_k2&view=media', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 268, 269, 0, '', 1),
(852, 'main', 'K2_INFORMATION', 'k2-information', '', 'com-k2/k2-information', 'index.php?option=com_k2&view=info', 'component', 1, 842, 2, 10080, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 270, 271, 0, '', 1),
(853, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 273, 288, 0, '', 1),
(854, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 274, 275, 0, '', 1),
(855, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 276, 277, 0, '', 1),
(856, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 278, 279, 0, '', 1),
(857, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 280, 281, 0, '', 1),
(858, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 282, 283, 0, '', 1),
(859, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 284, 285, 0, '', 1),
(860, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 853, 2, 10062, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 286, 287, 0, '', 1),
(892, 'main', 'COM_UNITEREVOLUTION2', 'com-uniterevolution2', '', 'com-uniterevolution2', 'index.php?option=com_uniterevolution2', 'component', 1, 1, 1, 10106, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_uniterevolution2/images/icon-16-revolution.png', 0, '{}', 289, 290, 0, '', 1),
(910, 'main', 'TCPDF', 'tcpdf', '', 'tcpdf', 'index.php?option=com_tcpdf', 'component', 1, 1, 1, 10254, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 291, 292, 0, '', 1),
(911, 'main', 'COM_VIRTUEMART', 'com-virtuemart', '', 'com-virtuemart', 'index.php?option=com_virtuemart', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, '../components/com_virtuemart/assets/images/vmgeneral/menu_icon.png', 0, '{}', 293, 320, 0, '', 1),
(912, 'main', 'COM_VIRTUEMART_CONTROL_PANEL', 'com-virtuemart-control-panel', '', 'com-virtuemart/com-virtuemart-control-panel', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 294, 295, 0, '', 1),
(913, 'main', 'COM_VIRTUEMART_MENU_CATEGORIES', 'com-virtuemart-menu-categories', '', 'com-virtuemart/com-virtuemart-menu-categories', 'index.php?option=com_virtuemart&view=category', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-categories.png', 0, '{}', 296, 297, 0, '', 1),
(914, 'main', 'COM_VIRTUEMART_MENU_PRODUCTS', 'com-virtuemart-menu-products', '', 'com-virtuemart/com-virtuemart-menu-products', 'index.php?option=com_virtuemart&view=product', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-products.png', 0, '{}', 298, 299, 0, '', 1),
(915, 'main', 'COM_VIRTUEMART_MENU_CUSTOMS', 'com-virtuemart-menu-customs', '', 'com-virtuemart/com-virtuemart-menu-customs', 'index.php?option=com_virtuemart&view=custom', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-document_move.png', 0, '{}', 300, 301, 0, '', 1),
(916, 'main', 'COM_VIRTUEMART_MENU_ORDERS', 'com-virtuemart-menu-orders', '', 'com-virtuemart/com-virtuemart-menu-orders', 'index.php?option=com_virtuemart&view=orders', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-orders.png', 0, '{}', 302, 303, 0, '', 1),
(917, 'main', 'COM_VIRTUEMART_MENU_REPORT', 'com-virtuemart-menu-report', '', 'com-virtuemart/com-virtuemart-menu-report', 'index.php?option=com_virtuemart&view=report', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 304, 305, 0, '', 1),
(918, 'main', 'COM_VIRTUEMART_MENU_USERS', 'com-virtuemart-menu-users', '', 'com-virtuemart/com-virtuemart-menu-users', 'index.php?option=com_virtuemart&view=user', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shoppers.png', 0, '{}', 306, 307, 0, '', 1),
(919, 'main', 'COM_VIRTUEMART_MENU_MANUFACTURERS', 'com-virtuemart-menu-manufacturers', '', 'com-virtuemart/com-virtuemart-menu-manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-manufacturers.png', 0, '{}', 308, 309, 0, '', 1),
(920, 'main', 'COM_VIRTUEMART_MENU_STORE', 'com-virtuemart-menu-store', '', 'com-virtuemart/com-virtuemart-menu-store', 'index.php?option=com_virtuemart&view=user&task=editshop', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shop.png', 0, '{}', 310, 311, 0, '', 1),
(921, 'main', 'COM_VIRTUEMART_MENU_MEDIAFILES', 'com-virtuemart-menu-mediafiles', '', 'com-virtuemart/com-virtuemart-menu-mediafiles', 'index.php?option=com_virtuemart&view=media', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-media.png', 0, '{}', 312, 313, 0, '', 1),
(922, 'main', 'COM_VIRTUEMART_MENU_SHIPMENTMETHODS', 'com-virtuemart-menu-shipmentmethods', '', 'com-virtuemart/com-virtuemart-menu-shipmentmethods', 'index.php?option=com_virtuemart&view=shipmentmethod', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shipmentmethods.png', 0, '{}', 314, 315, 0, '', 1),
(923, 'main', 'COM_VIRTUEMART_MENU_PAYMENTMETHODS', 'com-virtuemart-menu-paymentmethods', '', 'com-virtuemart/com-virtuemart-menu-paymentmethods', 'index.php?option=com_virtuemart&view=paymentmethod', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-paymentmethods.png', 0, '{}', 316, 317, 0, '', 1),
(924, 'main', 'COM_VIRTUEMART_MENU_CONFIGURATION', 'com-virtuemart-menu-configuration', '', 'com-virtuemart/com-virtuemart-menu-configuration', 'index.php?option=com_virtuemart&view=config', 'component', 1, 911, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-config.png', 0, '{}', 318, 319, 0, '', 1),
(925, 'main', 'VirtueMart AIO', 'virtuemart-aio', '', 'virtuemart-aio', 'index.php?option=com_virtuemart_allinone', 'component', 1, 1, 1, 10001, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 321, 322, 0, '', 1),
(926, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10276, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 323, 324, 0, '', 1),
(927, 'navigation', 'Test Builder', 'test-builder', '', 'home-page/test-builder', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', -2, 114, 2, 10276, 0, '0000-00-00 00:00:00', 0, 1, ' ', 22, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 46, 47, 0, '*', 0);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__menu_types` VALUES
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 0, 'main-menu-en', 'Main Menu EN', 'Main Menu en', 0),
(3, 0, 'main-menu-de', 'Main Menu DE', 'Main Menu DE', 0),
(4, 0, 'main-menu-fr', 'Main Menu FR', 'Main Menu FR', 0),
(5, 0, 'main-menu-it', 'Main Menu IT', 'Main Menu IT', 0),
(6, 0, 'main-menu-ru', 'Main Menu RU', 'Main Menu RU', 0),
(7, 0, 'top-menu', 'Top menu', 'Top menu', 0),
(8, 0, 'navigation', 'Navigation', 'Navigation', 0),
(9, 0, 'system-menu', 'System menu', 'System menu', 0),
(10, 0, 'the-service', 'The Service', 'The Service', 0),
(11, 0, 'information', 'Information', 'Information', 0),
(12, 0, 'search-param', 'search _param', 'search _param', 0),
(13, 0, 'top-menu2', 'Top menu2', 'Top menu2', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules` VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(95, 62, 'Top Login', '', '', 1, 'user-10', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_yj_pop_login', 1, 0, '{\"cache\":\"0\",\"moduleclass_sfx\":\"login\",\"pretext\":\"<span>Hello Guest!<\\/span>\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"layout\":\"_:default\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(97, 59, 'Top menu', '', '', 1, 'user-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"top-menu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 60, 'Language Switcher', '', '', 1, 'user-2', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_languages', 1, 0, '{\"header_text\":\"\",\"footer_text\":\"\",\"dropdown\":\"0\",\"image\":\"1\",\"inline\":\"1\",\"show_active\":\"1\",\"full_name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"switcher\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(101, 107, 'Display all products', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_vm2_products', 1, 0, '{\"feat\":\"1\",\"layout_feat\":\"layout\",\"featTitle\":\"Featured\",\"max_items_feat\":\"4\",\"products_per_row_feat\":\"4\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"0\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"0\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"0\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"class_sfx_feat\":\"featwww\",\"new\":\"1\",\"layout_new\":\"layout\",\"newTitle\":\"New\",\"max_items_new\":\"8\",\"products_per_row_new\":\"4\",\"stock_new\":\"0\",\"show_img_new\":\"1\",\"show_title_new\":\"1\",\"show_desc_new\":\"0\",\"row_desc_new\":\"40\",\"show_cat_new\":\"0\",\"show_rating_new\":\"1\",\"show_price_new\":\"1\",\"show_details_new\":\"0\",\"show_addcart_new\":\"1\",\"headerText_new\":\"\",\"footerText_new\":\"\",\"class_sfx_new\":\"new\",\"hit\":\"1\",\"layout_hit\":\"layout\",\"hitTitle\":\"Hit\",\"max_items_hit\":\"4\",\"products_per_row_hit\":\"4\",\"stock_hit\":\"0\",\"show_img_hit\":\"1\",\"show_title_hit\":\"1\",\"show_desc_hit\":\"0\",\"row_desc_hit\":\"40\",\"show_cat_hit\":\"0\",\"show_rating_hit\":\"1\",\"show_price_hit\":\"1\",\"show_details_hit\":\"0\",\"show_addcart_hit\":\"1\",\"headerText_hit\":\"\",\"footerText_hit\":\"\",\"class_sfx_hit\":\"hit\",\"disc\":\"1\",\"layout_disc\":\"layout\",\"discTitle\":\"Specials\",\"max_items_disc\":\"4\",\"products_per_row_disc\":\"4\",\"stock_disc\":\"0\",\"show_img_disc\":\"1\",\"show_title_disc\":\"1\",\"show_desc_disc\":\"0\",\"row_desc_disc\":\"40\",\"show_cat_disc\":\"0\",\"show_rating_disc\":\"1\",\"show_price_disc\":\"1\",\"show_details_disc\":\"0\",\"show_addcart_disc\":\"1\",\"headerText_disc\":\"\",\"footerText_disc\":\"\",\"class_sfx_disc\":\"disc\",\"rand\":\"1\",\"layout_rand\":\"layout\",\"randTitle\":\"Random\",\"max_items_random\":\"4\",\"products_per_row_random\":\"4\",\"stock_rand\":\"0\",\"show_img_rand\":\"1\",\"show_title_rand\":\"1\",\"show_desc_rand\":\"0\",\"row_desc_rand\":\"40\",\"show_cat_rand\":\"0\",\"show_rating_rand\":\"1\",\"show_price_rand\":\"1\",\"show_details_rand\":\"0\",\"show_addcart_rand\":\"1\",\"headerText_rand\":\"\",\"footerText_rand\":\"\",\"class_sfx_rand\":\"random\",\"rank\":\"1\",\"layout_rank\":\"layout\",\"rankTitle\":\"Rated\",\"max_items_rank\":\"4\",\"products_per_row_rank\":\"4\",\"show_img_rank\":\"1\",\"show_title_rank\":\"1\",\"show_desc_rank\":\"0\",\"row_desc_rank\":\"40\",\"show_cat_rank\":\"0\",\"show_rating_rank\":\"1\",\"show_price_rank\":\"1\",\"show_details_rank\":\"0\",\"show_addcart_rank\":\"1\",\"headerText_rank\":\"\",\"footerText_rank\":\"\",\"class_sfx_rank\":\"rating\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(102, 76, 'Compare Header', '', '', 1, 'user-8', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_comparelist', 1, 0, '{\"moduleclass_sfx\":\"comparetop\",\"layout\":\"header\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(103, 75, 'Wishlist Top', '', '', 1, 'user-7', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_wishlist', 1, 0, '{\"moduleclass_sfx\":\"wishlistop\",\"layout\":\"header\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 57, 'Contact Us', '', '<div class=\"addres\"><i class=\"fa fa-map-marker\"> </i> <span>8901 Marmora Road,\r\nGlasgow, D04 89GR.</span></div>\r\n<div class=\"phone\"><i class=\"fa fa-phone\"> </i> <span>+1 800 603 6035</span></div>\r\n<div class=\"mail\"><i class=\"fa fa-envelope\"> </i> <a href=\"mailto:mail@companyname.com\">mail@companyname.com</a></div>\r\n<div class=\"skype\"><i class=\"fa fa-skype\"> </i> <span>homeshop</span></div>', 1, 'footer-4', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"foot1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(114, 0, 'Information', '', '', 1, 'footer-3', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"information\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"foot3\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(117, 126, 'Newsletter popup', '', '', 1, 'footer-4', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"vertical\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"1\",\"listposition\":\"before\",\"customfields\":\"email,name\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"95%\",\"displayfields\":\"0\",\"introtext\":\"<h2>Subscribe Now to <span>Get 20% Off<\\/span>\\r\\non Any Product!<\\/h2>\\r\\n<div class=\\\"wrap-border\\\">\\r\\n<img src=\\\"modules\\/mod_acymailing\\/assets\\/images\\/subscribe_banner.jpg\\\" alt=\\\"\\\" \\/>\\r\\n<div class=\\\"fleft\\\">\\r\\n<P \\/>Aliquam dapibus tincidunt metus. Praesent justo dolor, lobortis quis, lobortis dignissim, pulvinar ac, lorem. <\\/p>\\r\\n<P \\/>Vestibulum sed ante. Donec sagittis euismod purus. Sed ut perspiciatis unde omnis iste natus error sit.<\\/p>\\r\\n<\\/div>\\r\\n<\\/div>\",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"3\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"1\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"610\",\"boxheight\":\"410\",\"moduleclass_sfx\":\"_newsletter\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"cache_time\":\"15\",\"includejs\":\"header\",\"itemid\":\"\",\"loadmootools\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(118, 0, 'Footer', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_footer', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"footer\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', 0, '*'),
(125, 0, 'K2 Quick Icons (admin)', '', '', 0, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_quickicons', 1, 1, '', 1, '*'),
(126, 0, 'K2 Stats (admin)', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_stats', 1, 1, '', 1, '*'),
(127, 71, 'Categories', '', '', 4, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_virtuemart_category', 1, 1, '{\"Parent_Category_id\":\"0\",\"layout\":\"default\",\"cache\":\"1\",\"moduleclass_sfx\":\"category\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(128, 82, 'Compare Products', '', '', 6, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_comparelist', 1, 1, '{\"moduleclass_sfx\":\"compare\",\"layout\":\"default\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 83, 'Wishlist Products', '', '', 5, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_wishlist', 1, 1, '{\"moduleclass_sfx\":\"wishlist\",\"layout\":\"default\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(134, 109, 'Deals of the day!', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_countdown', 1, 1, '{\"sale_text\":\"\",\"product_id\":\"4,5,6\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"cache\":\"0\",\"moduleclass_sfx\":\"deals\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(137, 87, 'Latest News', '', '', 1, 'brand', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{\"moduleclass_sfx\":\"homeblog\",\"getTemplate\":\"Home\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"4\",\"21\",\"13\",\"23\"],\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"modified\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"85\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"164\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(140, 97, 'Breadcrumbs', '', '', 1, 'breadcrumbs', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 0, '{\"showHere\":\"0\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\">\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"breadcrumbs\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(141, 94, 'Unite Revolution Slider', '', '', 1, 'user-12', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_unite_revolution2', 1, 1, '{\"sliderid\":\"1\",\"include_jquery\":\"false\",\"js_load_type\":\"body\",\"no_conflict_mode\":\"false\",\"moduleclass_sfx\":\"rev\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(143, 112, 'JS Cookie Alert', '', '', 1, 'cookie', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_js_cookie_alert', 1, 0, '{\"js_alert_jquery\":\"2\",\"js_cwmessage\":\"Please note this website requires cookies in order to function correctly, they do not store any specific information about you personally.\",\"js_cwbubbletitle\":\"Cookie Laws within the EU\",\"js_cwbubblemessage\":\"On 26th May 2012, new laws came into force in the EU that affect most web sites. If cookies are used in a site, the Privacy and Electronic Communications (EC Directive) (Amendment) Regulations 2011 (UK Government Regulations) asks that the website user must give consent to the use and placing of the cookies.\",\"js_cwagree\":\"Accept Cookies\",\"js_cwmoreinfo\":\"Read more...\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(148, 0, 'VM - Administrator Module', '', '', 5, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_vmmenu', 3, 1, '', 1, '*'),
(151, 121, 'Newsletter sign up', '', '', 1, 'footer-7', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 1, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"vertical\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"1\",\"listposition\":\"before\",\"customfields\":\"email\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"100%\",\"displayfields\":\"0\",\"introtext\":\"\",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"3\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"0\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"250\",\"boxheight\":\"200\",\"moduleclass_sfx\":\"_newsletter\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"includejs\":\"header\",\"itemid\":\"\",\"loadmootools\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(172, 66, 'Curency', '', '', 1, 'user-3', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_currencies_tf', 1, 0, '{\"text_before\":\"\",\"product_currency\":\"\",\"cache\":\"0\",\"moduleclass_sfx\":\"curency\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(173, 67, 'VirtueMart Shopping Cart', '', '', 1, 'user-9', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart_tf', 1, 0, '{\"moduleclass_sfx\":\"\",\"enable_cache\":\"0\",\"cache_time\":\"30\",\"show_product_list\":\"1\",\"limitcount\":\"6\",\"width\":\"60px\",\"height\":\"60px\",\"widthdropdown\":\"420\",\"show_scrollbar\":\"1\",\"height_scrollbar\":\"292\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(175, 69, 'Featured Products', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"default\",\"product_group\":\"featured\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"featured\",\"class_sfx\":\"featured\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(179, 74, 'SP VirtueMart Category Search', '', '', 1, 'head-search', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_sp_vmsearch', 1, 0, '{\"category_id\":\"\",\"max_search_suggest\":\"10\",\"loadjquery\":\"0\",\"loadtypeahead\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(180, 77, 'New Products', '', '', 2, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"slider\",\"product_group\":\"latest\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"new\",\"class_sfx\":\"new\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(181, 78, 'Tags Cloud', '', '', 11, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_cooltags_cloud', 1, 1, '{\"min_font\":\"14\",\"max_font\":\"14\",\"limit\":\"14\",\"catfilter\":\"0\",\"moduleclass_sfx\":\"tags\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(182, 80, 'Random Products', '', '', 3, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"slider\",\"product_group\":\"random\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"random\",\"class_sfx\":\"random\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(183, 81, 'Brands', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_virtuemart_manufacturer', 1, 1, '{\"show\":\"image\",\"display_style\":\"list\",\"manufacturers_per_row\":\"\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"0\",\"moduleclass_sfx\":\"brands\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(184, 85, 'Bestsellers', '', '', 7, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"listproducts\",\"product_group\":\"topten\",\"max_items\":\"3\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"best\",\"class_sfx\":\"best\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(185, 86, 'Specials', '', '', 12, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"sidebar\",\"product_group\":\"random\",\"max_items\":\"4\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"1\",\"virtuemart_category_id\":\"1\",\"cache\":\"0\",\"moduleclass_sfx\":\"specials\",\"class_sfx\":\"specials\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(186, 88, 'Custom HTML Bottom', '', '<ul class=\"list-banners\">\r\n<li class=\"item1\">\r\n<span class=\"txt1\">8(802)234-5678\r\n<span>Monday - Saturday: 8am - 5pm PST</span></span>\r\n<i class=\"fa fa-phone\"></i>\r\n</li>\r\n<li class=\"item2\">\r\n<i class=\"fa fa-truck\"></i>\r\n<span class=\"txt1\">Free Shipping\r\n<span>on all orders over $99</span></span>\r\n<a class=\"a\" href=\"#\">Learn More</a>\r\n</li>\r\n<li class=\"item3\">\r\n<span class=\"txt1\">Crazy Sale!\r\n<span>on selected items</span></span>\r\n<a class=\"a\" href=\"#\">Shop Now!</a>\r\n</li>\r\n</ul>', 1, 'position-5', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom_bottom\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(187, 89, 'ITPFacebookLikeBox', '', '', 1, 'footer-2', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_itpfblikebox', 1, 1, '{\"page_title\":\"facebooks\",\"page_link\":\"https:\\/\\/www.facebook.com\\/facebook\",\"width\":\"280\",\"height\":\"280\",\"show_facepile\":\"1\",\"show_posts\":\"0\",\"hide_cover\":\"1\",\"app_id\":\"facebook\",\"load_js\":\"1\",\"include_root_div\":\"1\",\"dynamic_locale\":\"1\",\"locale\":\"en_US\",\"moduleclass_sfx\":\"facebook\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(189, 91, 'From Twitter', '', '', 1, 'footer-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', -2, 'mod_jmod_tweetdisplay', 1, 1, '{\"consumer_key\":\"9JH7de9na8JnUjSADwpG0fJ65\",\"consumer_secret\":\"uamiAj41b46Razt38TJVgGKzBOIwOl07Pn8W53296uvReVni9N\",\"access_token\":\"308471286-eKRNX77anFKPKxUWbX0wRAT95GWgjnaGko5YGBpM\",\"access_secret\":\"VtRgip39ajULJ9R5oIiclxsG9Pu3F38kz3PLHeGM4fbRp\",\"type\":\"1\",\"username\":\"fanfbmltemplate\",\"query\":\"\",\"title\":\"\",\"link_title\":\"0\",\"count\":\"2\",\"width\":\"\",\"height\":\"\",\"header\":\"0\",\"twitter_icon\":\"0\",\"display_name\":\"1\",\"avatars\":\"1\",\"timestamps\":\"1\",\"reply\":\"1\",\"retweet\":\"1\",\"favorite\":\"1\",\"show_link\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"twitter\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(190, 92, 'Custom HTML top', '', '<ul class=\"list-banners\">\r\n<li class=\"item1\">\r\n<a href=\"#\">\r\n<img src=\"images/banners/banner1.png\" alt=\"\" />\r\n</a>\r\n</li>\r\n<li class=\"item2\">\r\n<a href=\"#\">\r\n<img src=\"images/banners/banner2.png\" alt=\"\" />\r\n</a>\r\n</li>\r\n<li class=\"item3\">\r\n<a href=\"#\">\r\n<img src=\"images/banners/banner3.png\" alt=\"\" />\r\n</a>\r\n</li>\r\n</ul>', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom_bottom\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(191, 93, 'Contact Information', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', -2, 'mod_profil_responsive_map', 1, 1, '{\"profilResponsiveMapTemplates\":\"default\",\"profilResponsiveMapGeoCoordinates\":[\"50.98476789999999\",\"11.029879899999969\",\"lorem ipsum\",\"1\",\"modules\\/mod_profil_responsive_map\\/tmpl\\/default\\/images\\/car-40-black.png\"],\"profilResponsiveMapColor\":\"#198012\",\"profilResponsiveMapContrast\":\"1.58\",\"profilResponsiveMapSaturation\":\"0\",\"profilResponsiveMapLightness\":\"0\",\"profilResponsiveMapZoom\":\"14\",\"profilResponsivePanControl\":\"1\",\"profilResponsiveZoomControl\":\"1\",\"profilResponsiveMapTypeControl\":\"1\",\"profilResponsiveScaleControl\":\"1\",\"profilResponsiveStreetViewControl\":\"1\",\"profilResponsiveScrollwheel\":\"1\",\"profilResponsiveFullscreen\":\"0\",\"profilResponsiveVisibility\":\"0\",\"profilResponsiveDescription\":\"<div class=\\\"row\\\">\\r\\n<div class=\\\"col-xs-3 col-md-3 col-sm-6\\\">\\r\\n<i class=\\\"fa fa-map-marker\\\"><\\/i>\\r\\n8901 Marmora Road,\\r\\nGlasgow, D04 89GR.\\r\\n<\\/div>\\r\\n<div class=\\\"col-xs-3 col-md-3 col-sm-6\\\">\\r\\n<i class=\\\"fa fa-phone\\\"><\\/i>\\r\\n800-559-65-80<br \\/>\\r\\n800-603-60-35\\r\\n<\\/div>\\r\\n<div class=\\\"col-xs-3 col-md-3 col-sm-6\\\">\\r\\n<i class=\\\"fa fa-envelope-o\\\"><\\/i>\\r\\n<a href=\\\"mailto:info@companyname.com\\\">info@companyname.com<\\/a>\\r\\n<a href=\\\"mailto:sales@companyname.com\\\">sales@companyname.com<\\/a>\\r\\n<\\/div>\\r\\n<div class=\\\"col-xs-3 col-md-3 col-sm-6\\\">\\r\\n<i class=\\\"fa fa-clock-o\\\"><\\/i>\\r\\nMonday - Friday: 08.00-20.00<br \\/>\\r\\nSaturday: 09.00-15.00<br \\/>\\r\\nSunday: closed\\r\\n<\\/div>\\r\\n<\\/div>\",\"profilResponsiveBikemap\":\"0\",\"profilResponsiveWeathermap\":\"0\",\"profilResponsiveWeathermapTemperatureunit\":\"0\",\"profilResponsiveCloudmap\":\"0\",\"profilResponsiveTrafficmap\":\"0\",\"moduleclass_sfx\":\"maps\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(192, 102, 'Megamenu', '', '', 2, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_jux_vm_megamenu', 1, 1, '{\"hozorver\":\"vertical\",\"horizontal_submenu_direction\":\"down\",\"vertical_submenu_direction\":\"lefttoright\",\"navigation_animation\":\"zoom\",\"n_navigation_animation\":\"\",\"animation_duration\":\"400\",\"animation_delay\":\"200\",\"show_num_items\":\"0\",\"show_items\":\"0\",\"load_font_awesome\":\"0\",\"mega_config\":\"{\\\"item-1\\\":{\\\"sub\\\":{\\\"class\\\":\\\"mega-drop_1\\\",\\\"width\\\":\\\"700px\\\",\\\"rows\\\":[[{\\\"item\\\":4,\\\"display\\\":1,\\\"width\\\":4},{\\\"item\\\":5,\\\"display\\\":1,\\\"width\\\":4},{\\\"item\\\":6,\\\"display\\\":1,\\\"width\\\":4},{\\\"position\\\":193,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"type\\\":\\\"category\\\",\\\"display\\\":1,\\\"class\\\":\\\"mega-drop_1\\\"},\\\"item-4\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":7,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-7\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-9\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-10\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-11\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-5\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":15,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-15\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-16\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-17\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-18\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-19\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-6\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":22,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-22\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-23\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-24\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-25\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-26\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-14\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-21\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-2\\\":{\\\"sub\\\":{\\\"width\\\":\\\"250px\\\",\\\"rows\\\":[[{\\\"item\\\":29,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-29\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-30\\\":{\\\"sub\\\":{\\\"width\\\":\\\"250px\\\",\\\"rows\\\":[[{\\\"item\\\":27,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-27\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-28\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-31\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-12\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-32\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-8\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-3\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-13\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-20\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1}}\",\"mega_order\":\"[]\",\"custom_css\":\"\",\"moduleclass_sfx\":\"megamenu_vm\",\"cache\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(193, 103, 'Custom HTML Megamenu', '', '<ul class=\"list-banners\">\r\n<li class=\"item1\">\r\n<span class=\"txt1\">8(802)234-5678\r\n<span>Monday - Saturday: 8am - 5pm PST</span></span>\r\n<i class=\"fa fa-phone\"></i>\r\n</li>\r\n<li class=\"item3\">\r\n<span class=\"txt1\">Crazy Sale!\r\n<span>on selected items</span></span>\r\n<a class=\"a\" href=\"#\">Shop Now!</a>\r\n</li>\r\n</ul>', 1, '', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom_html_megamenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(194, 104, 'Filter', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_param_filter', 1, 1, '{\"layout\":\"default\",\"method\":\"get\",\"limit\":\"6\",\"Parent_Category_id\":[\"25\"],\"parent_auto\":\"1\",\"stock\":\"1\",\"children\":\"-1\",\"show_all_count\":\"1\",\"mod_ajax\":\"1\",\"count_show\":\"1\",\"count_zero_show\":\"disable\",\"mod_ajax_div\":\"#prodlist-box\",\"loader_img\":\"aload-black_on_white\",\"mcf_prepend_text\":\"\",\"mcf_append_text\":\"\",\"mcf_reinit_start\":\"\",\"mcf_reinit_mod\":\"\",\"mcf_reinit_body\":\"\",\"mcf_mod_uniq_display\":\"1\",\"mcf_mod_uniq_result\":\"1\",\"view_assign\":[\"category\",\"virtuemart\"],\"category_assign\":[\"0\"],\"categories_show\":\"0\",\"in_active_category\":\"0\",\"active_category_id\":\"\",\"mcf_subcategories\":\"0\",\"mcf_only_subcategories\":\"0\",\"categories_heading\":\"\",\"categories_select_heading\":\"Choose category\",\"categories_layout\":\"checkbox\",\"manufacturers_show\":\"1\",\"manufacturers_heading\":\"Manufacturers\",\"manufacturers_select_heading\":\"Choose manufacturer\",\"mcf_body\":\"Z3ppbmZsYXRl;dZJra9swFIb\\/ypnwik0Tx4GtbL5kBNrRFQod65etKUaxj2OtsmR08eaW\\/vdJTsYgZF8E5\\/K859WRdlxuKYegNR2fBT1VtCs1UlW1Jat1BkEtKyjg5jOtjFRjmu7QXMrKdihMGLn6MeKamdZoQk\\/OV8flCM7OTkBvCpgv4ROchiAFYTn30\\/iu7KrGO7rjdsfENfIe1WRrnwjJ0FVWG9mRGZmEiLfpoPIJRwf+1FKUNVayxvCv3mGkjuarQ2MGwJrwH1ZAV78Pt1TjxbsSxUTvnmtsODUYEk6\\/Xi5JrO1WG\\/XfNi9Bbkl8c7e+vy6\\/fbm\\/iskViaJolsyWF1FM1vgjmRLRC7wi1\\/gCgel655oqRUe\\/8EaqMGBFkgUsLz668\\/zcNTuvh60f7+4hYI9RNMk8PDqhkw0ZvJ58SU9l+8\\/hIpLXbABtRo7FhjRSmLlmz5h+SN5mG7L6Li20dECgIKRw\\/4UN7tI1DKg0kwJ+taxqoWa653TUYHswEpYJ7CeCQm250TGsDySM0iroZG05QosKU8gptAobN701pk8Xi27E3yZGuyFgqHKfwJXKLafiyRm6Ha+mYr6gq3zhvK9ITDbCHTkTvTVgxt7fpGV1jcJJCNr52D86E8y4zEC59all4oKF46dd+HUpNFYJMMpi9gc=;Y3JlYXRlX2Z1bmN0aW9u\",\"mcf_mod\":\"bxaisiexi6xi4xi_xdieicixoidxe\",\"manufacturers_layout\":\"checkbox\",\"price_show\":\"1\",\"price_heading\":\"Price \",\"price_discount\":\"2\",\"price_mcur\":\"1\",\"price_layout\":\"slider_double\",\"price_select_heading\":\"Choose Price\",\"customfields_show\":\"1\",\"customfields_select_heading\":\"Param fileds\",\"customfields_layout\":\"auto\",\"moduleclass_sfx\":\"param\",\"class_sfx\":\"\",\"mcf_jqueryui\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(195, 106, 'Latest Products', '', '', 2, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"default\",\"product_group\":\"latest\",\"max_items\":\"8\",\"products_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"new\",\"class_sfx\":\"new\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(197, 110, 'Latest Products', '', '', 2, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product_tf', 1, 1, '{\"layout\":\"slider\",\"product_group\":\"latest\",\"max_items\":\"8\",\"products_per_row\":\"2\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"new\",\"class_sfx\":\"latest\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(198, 113, 'JS Cookie Alert Rus', '', '', 1, 'cookie', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_js_cookie_alert', 1, 0, '{\"js_alert_jquery\":\"2\",\"js_cwmessage\":\"Please note this website requires cookies in order to function correctly, they do not store any specific information about you personally.\",\"js_cwbubbletitle\":\"Cookie Laws within the EU\",\"js_cwbubblemessage\":\"On 26th May 2012, new laws came into force in the EU that affect most web sites. If cookies are used in a site, the Privacy and Electronic Communications (EC Directive) (Amendment) Regulations 2011 (UK Government Regulations) asks that the website user must give consent to the use and placing of the cookies.\",\"js_cwagree\":\"Принимать Cookies\",\"js_cwmoreinfo\":\"Читать далее...\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(199, 114, 'Tabs products', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_vm2_products', 1, 0, '{\"feat\":\"1\",\"layout_feat\":\"layout\",\"featTitle\":\"Featured\",\"max_items_feat\":\"3\",\"products_per_row_feat\":\"3\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"0\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"0\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"0\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"featured_source\":[],\"featured_outsource\":[],\"class_sfx_feat\":\"featwww\",\"new\":\"1\",\"layout_new\":\"layout\",\"newTitle\":\"New\",\"max_items_new\":\"6\",\"products_per_row_new\":\"3\",\"stock_new\":\"0\",\"show_img_new\":\"1\",\"show_title_new\":\"1\",\"show_desc_new\":\"0\",\"row_desc_new\":\"40\",\"show_cat_new\":\"0\",\"show_rating_new\":\"1\",\"show_price_new\":\"1\",\"show_details_new\":\"0\",\"show_addcart_new\":\"1\",\"headerText_new\":\"\",\"footerText_new\":\"\",\"new_source\":[],\"new_outsource\":[],\"class_sfx_new\":\"new\",\"hit\":\"1\",\"layout_hit\":\"layout\",\"hitTitle\":\"Hit\",\"max_items_hit\":\"3\",\"products_per_row_hit\":\"3\",\"stock_hit\":\"0\",\"show_img_hit\":\"1\",\"show_title_hit\":\"1\",\"show_desc_hit\":\"0\",\"row_desc_hit\":\"40\",\"show_cat_hit\":\"0\",\"show_rating_hit\":\"1\",\"show_price_hit\":\"1\",\"show_details_hit\":\"0\",\"show_addcart_hit\":\"1\",\"headerText_hit\":\"\",\"footerText_hit\":\"\",\"class_sfx_hit\":\"hit\",\"hit_source\":[],\"hit_outsource\":[],\"disc\":\"1\",\"layout_disc\":\"layout\",\"discTitle\":\"Specials\",\"max_items_disc\":\"3\",\"products_per_row_disc\":\"3\",\"stock_disc\":\"0\",\"show_img_disc\":\"1\",\"show_title_disc\":\"1\",\"show_desc_disc\":\"0\",\"row_desc_disc\":\"40\",\"show_cat_disc\":\"0\",\"show_rating_disc\":\"1\",\"show_price_disc\":\"1\",\"show_details_disc\":\"0\",\"show_addcart_disc\":\"1\",\"headerText_disc\":\"\",\"footerText_disc\":\"\",\"disc_source\":[],\"disc_outsource\":[],\"class_sfx_disc\":\"disc\",\"rand\":\"1\",\"layout_rand\":\"layout\",\"randTitle\":\"Random\",\"max_items_random\":\"6\",\"products_per_row_random\":\"3\",\"stock_rand\":\"0\",\"show_img_rand\":\"1\",\"show_title_rand\":\"1\",\"show_desc_rand\":\"0\",\"row_desc_rand\":\"40\",\"show_cat_rand\":\"0\",\"show_rating_rand\":\"1\",\"show_price_rand\":\"1\",\"show_details_rand\":\"0\",\"show_addcart_rand\":\"1\",\"headerText_rand\":\"\",\"footerText_rand\":\"\",\"rand_source\":[],\"rand_outsource\":[],\"class_sfx_rand\":\"random\",\"rank\":\"1\",\"layout_rank\":\"layout\",\"rankTitle\":\"Rated\",\"max_items_rank\":\"3\",\"products_per_row_rank\":\"3\",\"show_img_rank\":\"1\",\"show_title_rank\":\"1\",\"show_desc_rank\":\"0\",\"row_desc_rank\":\"40\",\"show_cat_rank\":\"0\",\"show_rating_rank\":\"1\",\"show_price_rank\":\"1\",\"show_details_rank\":\"0\",\"show_addcart_rank\":\"1\",\"headerText_rank\":\"\",\"footerText_rank\":\"\",\"class_sfx_rank\":\"rating\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(200, 115, 'Custom HTML Bottom', '', '<span class=\"text1\">Buy Safely</span>\r\n<span class=\"text2\">with guarantees!</span>\r\n<span class=\"text3\">Donec porta diam eu massa. Quisque diam lorem, interdum vitae, dapibus ac, scelerisque vitae, pede. Donec eget tellus non erat lacinia fermentum. </span>\r\n<span class=\"text4\"><a class=\"button\" href=\"#\">Read More</a></span>', 1, 'position-9', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom_html\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(201, 116, 'Module youtube video', '', '', 1, 'position-9', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_youtubevideo', 1, 0, '{\"selector\":\"#CustomblockVideo\",\"video\":\"Tk2Qj0B_6fo\",\"mod_image\":\"images\\/video-bg.jpg\",\"moduleclass_sfx\":\"youtube\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(202, 117, 'Unite Revolution Slider Wide', '', '', 1, 'user-14', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_unite_revolution2', 1, 0, '{\"sliderid\":\"2\",\"include_jquery\":\"false\",\"js_load_type\":\"body\",\"no_conflict_mode\":\"false\",\"moduleclass_sfx\":\"rev\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(203, 118, 'Module Parallax', '', '', 1, 'brand', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_parallax', 1, 0, '{\"selector\":\"#Customblock-brand\",\"backgroundratio\":\"0.2\",\"horizontalOffset\":\"0\",\"verticalOffset\":\"-20\",\"mod_image\":\"images\\/parallax-slide.png\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(204, 119, 'Custom HTMl Full Width', '', '<div class=\"container bannet-top-fullwidth\">\r\n<div class=\"row\">\r\n<div class=\" col-lg-4 col-md-4 col-sm-12 col-xs-12\">\r\n<a href=\"#\" class=\"item\">\r\n<img src=\"images/banners/img1-fullwidth.jpg\" alt=\"\" />\r\n<span class=\"box-text color\">\r\n<span class=\"text1\"><span>New Prices</span>\r\nNOW $70 LESS!</span>\r\n</span>\r\n</a>\r\n</div>\r\n<div class=\" col-lg-4 col-md-4 col-sm-12 col-xs-12 item\">\r\n<a href=\"#\" class=\"item\">\r\n<img src=\"images/banners/img2-fullwidth.jpg\" alt=\"\" />\r\n<span class=\"box-text color2\">\r\n<span class=\"text1\"><span>Must Have</span>\r\nTrendy Items!</span>\r\n</span>\r\n</a>\r\n</div>\r\n<div class=\" col-lg-4 col-md-4 col-sm-12 col-xs-12 item\">\r\n<a href=\"#\" class=\"item\">\r\n<img src=\"images/banners/img3-fullwidth.jpg\" alt=\"\" />\r\n<span class=\"box-text color3\">\r\n<span class=\"text1\"><span>special Offer</span>\r\nThe Biggest Sale!</span>\r\n</span>\r\n</a>\r\n</div>\r\n</div>\r\n</div>', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"banner_fullwidth\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(205, 120, 'The Service', '', '', 1, 'footer-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"the-service\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(206, 122, 'Stay connected', '', '<div class=\"social\">\r\n<a class=\"facebook hasTooltip\" title=\"Facebook\" href=\"http://www.facebook.com/\"><em class=\"fa fa-facebook\"> </em> </a> \r\n<a class=\"twitter hasTooltip\" title=\"Twitter\" href=\"http://twitter.com/\"><em class=\"fa fa-twitter\"> </em> </a> \r\n<a class=\"google hasTooltip\" title=\"Google\" href=\"http://plus.google.com\"><em class=\"fa fa-google-plus\"> </em> </a> \r\n<a class=\"pinterest hasTooltip\" title=\"Pinterest\" href=\"http://www.pinterest.com/\"><em class=\"fa fa-pinterest\"> </em> </a>  \r\n<a class=\"youtube hasTooltip\" title=\"Youtube\" href=\"http://www.youtube.com\"><em class=\"fa fa-youtube-square\"> </em> </a> \r\n</div>', 1, 'footer-8', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"foot1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(207, 123, 'Categories', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category_tf', 1, 1, '{\"Parent_Category_id\":\"0\",\"level\":\"3\",\"layout\":\"default\",\"cache\":\"1\",\"moduleclass_sfx\":\"category\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(208, 124, 'Brands', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_manufacturer_tf', 1, 1, '{\"show\":\"image\",\"display_style\":\"list\",\"manufacturers_per_row\":\"\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\"brands\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(209, 125, 'VirtueMart Search Product Velokorodnov', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_virtuemart_search_tf', 1, 1, '', 0, '*'),
(210, 127, 'Genius Virtuemart Ajax Search - VM3 Edition - Deluxe', '', '', 1, 'head-search', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_genius_vm_ajax_search_vm3', 1, 0, '{\"template\":\"default\",\"moduleclass_sfx\":\" ajax_srch\",\"price_type_display\":\"1\",\"manualmargin_setting\":\"0\",\"manualmargin_settingtop\":\"0\",\"number_of_cats\":\"100\",\"number_of_mans\":\"100\",\"number_of_products\":\"20\",\"vm_expo_sku\":\"0\",\"highlight_prods\":\"1\",\"highlight_sku\":\"1\",\"highlight_cats\":\"1\",\"highlight_manuf\":\"1\",\"showcats_info\":\"1\",\"showmanuf_info\":\"1\",\"child_products_link\":\"0\",\"internal_caching\":\"0\",\"include_sdescr\":\"0\",\"results_ordering\":\"0\",\"matching_depth\":\"0\",\"highlight_color\":\"#ffff88\",\"css_override\":\".mycustomclass h1.customclass { background: #807000; }\\r\\ndiv.geniusGroove .GeniusHeaderTopAjax {\\r\\nbackground: #34495e;\\r\\n}\",\"overlay_bg_color_enable\":\"0\",\"overlay_bg_color\":\"#008000\",\"overlay_bg_color_opacity\":\"0.4\",\"initial_ajax_loader_enable\":\"0\",\"initial_ajax_loader_bg\":\"#f9f5f2\",\"master_ajax_window_width\":\"100%\",\"initial_ajax_loader_width\":\"100%\",\"search_input_placeholder\":\"Search in shop!\",\"search_string_info\":\"Your search:\",\"modal_close_txt\":\"Close window X\",\"category_header_txt\":\"Categories\",\"manuf_header_txt\":\"Brands\",\"product_header_txt\":\"Products\",\"news_header_txt\":\"Latest News\",\"sku_pre_txt\":\"SKU:\",\"buynow_txt\":\"Buy Now!\",\"noresults__box_txt\":\"No matching results...\",\"less_than_three_txt\":\"Please also try these popular search phrases: Disco music, King Kong...\",\"noprresults_atall_txt\":\"<p>No results found... Please try another search<\\/p>\",\"include_custom_pos\":\"0\",\"custom_module_pos\":\"customajaxposition\",\"custom_module_default_width\":\"183\",\"show_ratings_ajax\":\"0\",\"starrating_color\":\"#008000\",\"shownews_info\":\"1\",\"newssource\":\"1\",\"number_of_news\":\"20\",\"highlight_news\":\"1\",\"special_scroll_bars\":\"1\",\"special_scroll_bars_type\":\"dark-thin\",\"special_scroll_bars_smoothness\":\"120\",\"k2catfilter\":\"0\",\"joomart_filter\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(211, 128, 'IsotopeMart layout for VirtueMart', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_isotopemart', 1, 1, '{\"product_group\":\"random\",\"max_items\":\"16\",\"itemWidth\":\"297\",\"itemHeight\":\"470\",\"item_style\":\"0\",\"show_filtering\":\"1\",\"show_sorting\":\"1\",\"show_ordering\":\"1\",\"loadjQuery\":\"0\",\"hide_front\":\"1\",\"hide_views\":\"1\",\"cache\":\"0\",\"moduleclass_sfx\":\"izotopprod\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(212, 131, 'Contact Information', '', '<p>{mosmap}</p>', 1, 'content-top', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":1,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(213, 134, 'Donec ultricies', '', '', 1, 'megamenu', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category_tf', 1, 0, '{\"Parent_Category_id\":\"4\",\"level\":\"2\",\"layout\":\"megamenu\",\"cache\":\"0\",\"moduleclass_sfx\":\"megamenu\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(214, 135, 'Sed sapien sap', '', '', 1, 'megamenu', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category_tf', 1, 0, '{\"Parent_Category_id\":\"5\",\"level\":\"2\",\"layout\":\"megamenu\",\"cache\":\"0\",\"moduleclass_sfx\":\"megamenu\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(215, 136, 'Vestibulum faucibus', '', '', 1, 'megamenu', 0, '0000-00-00 00:00:00', '2019-06-21 21:16:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category_tf', 1, 0, '{\"Parent_Category_id\":\"6\",\"level\":\"2\",\"layout\":\"megamenu\",\"cache\":\"0\",\"moduleclass_sfx\":\"megamenu\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(216, 141, 'SP Page Builder', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_sppagebuilder', 1, 1, '', 0, '*'),
(217, 142, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(218, 143, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules_menu` VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(95, 0),
(97, 0),
(100, 0),
(101, 201),
(102, 0),
(103, 0),
(112, 0),
(114, 0),
(117, 101),
(117, 106),
(117, 107),
(117, 108),
(117, 109),
(117, 110),
(117, 114),
(118, 0),
(125, 0),
(126, 0),
(127, 0),
(128, 0),
(129, 101),
(129, 106),
(129, 107),
(129, 108),
(129, 109),
(129, 110),
(129, 111),
(129, 112),
(129, 113),
(129, 114),
(129, 115),
(129, 116),
(129, 117),
(129, 118),
(129, 121),
(129, 122),
(129, 123),
(129, 124),
(129, 125),
(129, 126),
(129, 127),
(129, 128),
(129, 129),
(129, 130),
(129, 131),
(129, 132),
(129, 133),
(129, 134),
(129, 135),
(129, 136),
(129, 137),
(129, 138),
(129, 139),
(129, 140),
(129, 141),
(129, 142),
(129, 143),
(129, 144),
(129, 145),
(129, 146),
(129, 147),
(129, 148),
(129, 149),
(129, 150),
(129, 151),
(129, 152),
(129, 153),
(129, 158),
(129, 159),
(129, 161),
(129, 162),
(129, 163),
(129, 164),
(129, 165),
(129, 166),
(129, 167),
(129, 168),
(129, 169),
(129, 190),
(129, 191),
(129, 194),
(129, 195),
(129, 196),
(129, 197),
(129, 198),
(129, 199),
(129, 200),
(129, 201),
(129, 202),
(129, 203),
(129, 206),
(129, 207),
(129, 208),
(129, 209),
(129, 210),
(129, 214),
(129, 215),
(129, 216),
(129, 219),
(129, 222),
(129, 238),
(129, 239),
(129, 240),
(129, 267),
(129, 268),
(134, 117),
(134, 202),
(134, 215),
(137, 101),
(137, 106),
(137, 107),
(137, 108),
(137, 109),
(137, 110),
(137, 114),
(137, 201),
(137, 202),
(137, 203),
(137, 206),
(137, 207),
(137, 208),
(137, 209),
(137, 210),
(137, 215),
(137, 216),
(137, 219),
(137, 222),
(137, 238),
(137, 239),
(140, 111),
(140, 112),
(140, 113),
(140, 114),
(140, 115),
(140, 116),
(140, 117),
(140, 118),
(140, 119),
(140, 120),
(140, 121),
(140, 122),
(140, 123),
(140, 124),
(140, 125),
(140, 126),
(140, 127),
(140, 128),
(140, 129),
(140, 130),
(140, 131),
(140, 132),
(140, 133),
(140, 134),
(140, 135),
(140, 136),
(140, 137),
(140, 138),
(140, 139),
(140, 140),
(140, 141),
(140, 142),
(140, 143),
(140, 144),
(140, 145),
(140, 146),
(140, 147),
(140, 148),
(140, 149),
(140, 150),
(140, 151),
(140, 152),
(140, 153),
(140, 154),
(140, 155),
(140, 158),
(140, 159),
(140, 160),
(140, 161),
(140, 162),
(140, 163),
(140, 164),
(140, 165),
(140, 166),
(140, 167),
(140, 168),
(140, 169),
(140, 190),
(140, 191),
(140, 192),
(140, 194),
(140, 195),
(140, 196),
(140, 197),
(140, 198),
(140, 199),
(140, 200),
(140, 201),
(140, 202),
(140, 203),
(140, 206),
(140, 207),
(140, 208),
(140, 209),
(140, 210),
(140, 214),
(140, 215),
(140, 216),
(140, 219),
(140, 222),
(140, 238),
(140, 239),
(140, 240),
(140, 267),
(140, 268),
(140, 452),
(140, 453),
(141, 101),
(141, 106),
(141, 107),
(141, 108),
(141, 109),
(141, 110),
(141, 114),
(141, 202),
(143, 101),
(143, 106),
(143, 107),
(143, 108),
(143, 109),
(143, 111),
(143, 112),
(143, 113),
(143, 114),
(143, 116),
(143, 117),
(143, 118),
(143, 119),
(143, 120),
(143, 121),
(143, 161),
(143, 164),
(143, 167),
(143, 190),
(143, 191),
(143, 194),
(143, 195),
(143, 196),
(143, 197),
(143, 198),
(143, 199),
(143, 200),
(143, 201),
(143, 202),
(143, 206),
(143, 210),
(143, 214),
(143, 215),
(143, 216),
(143, 240),
(143, 454),
(143, 455),
(143, 456),
(143, 457),
(143, 458),
(143, 459),
(143, 460),
(143, 461),
(143, 462),
(143, 463),
(143, 464),
(143, 465),
(143, 466),
(143, 467),
(143, 468),
(143, 469),
(143, 470),
(143, 471),
(143, 472),
(143, 473),
(143, 474),
(143, 475),
(143, 476),
(143, 477),
(148, 0),
(151, 0),
(172, 0),
(173, 0),
(175, 101),
(175, 106),
(175, 107),
(175, 108),
(175, 109),
(175, 110),
(175, 114),
(175, 201),
(175, 202),
(175, 210),
(179, 106),
(179, 108),
(179, 109),
(179, 110),
(179, 111),
(179, 112),
(179, 113),
(179, 115),
(179, 116),
(179, 117),
(179, 118),
(179, 119),
(179, 120),
(179, 121),
(179, 158),
(179, 159),
(179, 160),
(179, 161),
(179, 162),
(179, 163),
(179, 164),
(179, 165),
(179, 166),
(179, 167),
(179, 168),
(179, 169),
(179, 190),
(179, 191),
(179, 194),
(179, 195),
(179, 196),
(179, 197),
(179, 198),
(179, 199),
(179, 200),
(179, 206),
(179, 210),
(179, 214),
(179, 215),
(179, 216),
(179, 240),
(179, 454),
(179, 455),
(179, 456),
(179, 457),
(179, 458),
(179, 459),
(179, 460),
(179, 461),
(179, 462),
(179, 463),
(179, 464),
(179, 465),
(179, 466),
(179, 467),
(179, 468),
(179, 469),
(179, 470),
(179, 471),
(179, 472),
(179, 473),
(179, 474),
(179, 475),
(179, 476),
(179, 477),
(179, 481),
(180, 101),
(180, 106),
(180, 107),
(180, 108),
(180, 109),
(180, 110),
(180, 114),
(181, 0),
(182, 101),
(182, 106),
(182, 107),
(182, 108),
(182, 109),
(182, 110),
(182, 114),
(182, 215),
(183, 101),
(183, 106),
(183, 107),
(183, 108),
(183, 109),
(183, 110),
(183, 111),
(183, 112),
(183, 113),
(183, 114),
(183, 115),
(183, 116),
(183, 117),
(183, 118),
(183, 119),
(183, 120),
(183, 158),
(183, 159),
(183, 160),
(183, 161),
(183, 162),
(183, 163),
(183, 164),
(183, 165),
(183, 166),
(183, 167),
(183, 168),
(183, 169),
(183, 194),
(183, 197),
(183, 198),
(183, 199),
(183, 200),
(183, 201),
(183, 206),
(183, 240),
(184, 101),
(184, 106),
(184, 107),
(184, 108),
(184, 109),
(184, 110),
(184, 111),
(184, 112),
(184, 113),
(184, 114),
(184, 115),
(184, 116),
(184, 117),
(184, 118),
(184, 119),
(184, 120),
(184, 121),
(184, 122),
(184, 123),
(184, 124),
(184, 125),
(184, 126),
(184, 127),
(184, 128),
(184, 129),
(184, 130),
(184, 131),
(184, 132),
(184, 133),
(184, 134),
(184, 135),
(184, 136),
(184, 137),
(184, 138),
(184, 139),
(184, 140),
(184, 141),
(184, 142),
(184, 143),
(184, 144),
(184, 145),
(184, 146),
(184, 147),
(184, 148),
(184, 149),
(184, 150),
(184, 151),
(184, 152),
(184, 153),
(184, 158),
(184, 159),
(184, 160),
(184, 161),
(184, 162),
(184, 163),
(184, 164),
(184, 165),
(184, 166),
(184, 167),
(184, 168),
(184, 169),
(184, 190),
(184, 191),
(184, 194),
(184, 195),
(184, 196),
(184, 197),
(184, 198),
(184, 199),
(184, 200),
(184, 201),
(184, 202),
(184, 203),
(184, 206),
(184, 207),
(184, 208),
(184, 209),
(184, 210),
(184, 214),
(184, 215),
(184, 216),
(184, 219),
(184, 222),
(184, 238),
(184, 239),
(184, 240),
(184, 267),
(184, 268),
(185, 101),
(185, 106),
(185, 107),
(185, 108),
(185, 109),
(185, 110),
(185, 114),
(185, 119),
(185, 120),
(185, 201),
(185, 202),
(185, 203),
(185, 207),
(185, 208),
(185, 219),
(185, 238),
(185, 239),
(185, 267),
(185, 268),
(186, 101),
(186, 106),
(186, 107),
(186, 108),
(186, 109),
(186, 110),
(186, 114),
(186, 201),
(187, 0),
(189, 0),
(190, 101),
(190, 106),
(190, 107),
(190, 108),
(190, 109),
(190, 110),
(191, 196),
(192, 101),
(192, 106),
(192, 107),
(192, 108),
(192, 109),
(192, 110),
(192, 114),
(193, 101),
(193, 106),
(193, 107),
(193, 108),
(193, 109),
(193, 110),
(194, 116),
(194, 117),
(194, 122),
(194, 123),
(194, 124),
(194, 125),
(194, 126),
(194, 127),
(194, 128),
(194, 129),
(194, 130),
(194, 131),
(194, 132),
(194, 133),
(194, 134),
(194, 135),
(194, 136),
(194, 137),
(194, 138),
(194, 139),
(194, 140),
(194, 141),
(194, 142),
(194, 143),
(194, 144),
(194, 145),
(194, 146),
(194, 147),
(194, 148),
(194, 149),
(194, 150),
(194, 151),
(194, 152),
(194, 153),
(194, 162),
(194, 163),
(194, 195),
(195, 201),
(195, 210),
(197, 202),
(198, 110),
(199, 210),
(199, 215),
(200, 114),
(200, 201),
(201, 114),
(201, 201),
(202, 201),
(203, 201),
(204, 201),
(205, 0),
(206, 0),
(207, 0),
(208, 101),
(208, 106),
(208, 107),
(208, 108),
(208, 109),
(208, 110),
(208, 111),
(208, 112),
(208, 113),
(208, 114),
(208, 116),
(208, 117),
(208, 118),
(208, 119),
(208, 120),
(208, 158),
(208, 159),
(208, 160),
(208, 161),
(208, 162),
(208, 163),
(208, 164),
(208, 165),
(208, 166),
(208, 167),
(208, 168),
(208, 169),
(208, 194),
(208, 197),
(208, 198),
(208, 199),
(208, 200),
(208, 201),
(208, 202),
(208, 210),
(208, 215),
(208, 216),
(208, 454),
(208, 455),
(208, 456),
(208, 457),
(208, 458),
(208, 459),
(208, 460),
(208, 461),
(208, 462),
(208, 463),
(208, 464),
(208, 465),
(208, 466),
(208, 467),
(208, 468),
(208, 469),
(208, 470),
(208, 471),
(208, 472),
(208, 473),
(208, 474),
(208, 475),
(208, 476),
(208, 477),
(210, 101),
(210, 107),
(210, 114),
(210, 201),
(210, 202),
(211, 201),
(212, 196),
(213, 0),
(214, 0),
(215, 0),
(217, 0),
(218, 0);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__nextend_smartslider_layouts`;
CREATE TABLE `#__nextend_smartslider_layouts` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `slide` longtext,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__nextend_smartslider_sliders`;
CREATE TABLE `#__nextend_smartslider_sliders` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `type` varchar(30) NOT NULL,
  `params` text NOT NULL,
  `generator` text NOT NULL,
  `slide` longtext
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__nextend_smartslider_slides`;
CREATE TABLE `#__nextend_smartslider_slides` (
  `id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `slider` int(11) NOT NULL,
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `published` tinyint(1) NOT NULL,
  `first` int(11) NOT NULL,
  `slide` longtext,
  `description` text NOT NULL,
  `thumbnail` varchar(255) NOT NULL,
  `background` varchar(300) NOT NULL,
  `params` text NOT NULL,
  `ordering` int(11) NOT NULL,
  `generator` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__nextend_smartslider_storage`;
CREATE TABLE `#__nextend_smartslider_storage` (
  `id` int(11) NOT NULL,
  `key` varchar(200) NOT NULL,
  `value` longtext
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__onepage_agendas`;
CREATE TABLE `#__onepage_agendas` (
  `id` int(11) NOT NULL,
  `format` varchar(255) NOT NULL DEFAULT 'nnnnnn',
  `depends` int(11) NOT NULL DEFAULT '0',
  `reseton` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__onepage_agendas` VALUES
(1, '{R}YYYYmmddnnnnnn', 0, 3, 'Order Number'),
(2, 'IInnnnnn', 0, 0, 'Issued Invoice Number'),
(3, 'DNnnnnnn', 2, 0, 'Delivery Note Number');

DROP TABLE IF EXISTS `#__onepage_exported`;
CREATE TABLE `#__onepage_exported` (
  `id` bigint(20) NOT NULL,
  `tid` int(11) NOT NULL,
  `localid` varchar(250) CHARACTER SET ascii NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'NONE',
  `ai` varchar(20) NOT NULL,
  `specials` mediumtext NOT NULL,
  `path` varchar(512) NOT NULL,
  `cdate` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__onepage_export_templates`;
CREATE TABLE `#__onepage_export_templates` (
  `tid` int(11) NOT NULL,
  `file` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('ORDER_DATA','ORDER_DATA_TXT','ORDERS','ORDERS_TXT') NOT NULL DEFAULT 'ORDER_DATA'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__onepage_export_templates` VALUES
(100, 'invoice.ods', '', 'ORDER_DATA'),
(101, 'sek.ods', '', 'ORDER_DATA'),
(102, 'invoice_common.ods', '', 'ORDER_DATA'),
(103, 'labels_us_letter.odt', '', 'ORDER_DATA');

DROP TABLE IF EXISTS `#__onepage_export_templates_settings`;
CREATE TABLE `#__onepage_export_templates_settings` (
  `id` int(11) NOT NULL,
  `tid` int(11) NOT NULL DEFAULT '0',
  `keyname` varchar(20) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `original` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__onepage_export_templates_settings` VALUES
(100, 100, 'tid_name', 'Invoice Example', ''),
(101, 100, 'tid_num', '0', ''),
(102, 100, 'tid_forward', '0', ''),
(103, 100, 'tid_back', '0', ''),
(104, 100, 'tid_foreign', '0', ''),
(105, 100, 'tid_autocreate', '0', ''),
(106, 100, 'tid_enabled', '1', ''),
(107, 100, 'tid_special', '1', ''),
(108, 100, 'tid_specials', '1', ''),
(109, 100, 'tid_ai', '1', ''),
(110, 100, 'tid_shared', '', ''),
(111, 100, 'tid_foreigntemplate', '101', ''),
(112, 100, 'tid_email', '1', ''),
(113, 100, 'tid_nummax', '', ''),
(114, 100, 'tid_itemmax', '', ''),
(115, 100, 'tid_type', 'ORDER_DATA', ''),
(116, 100, 'tid_emailsubject', 'Invoice Example', ''),
(117, 100, 'tid_emailbody', 'Please review the attachment of this email. ', ''),
(118, 101, 'tid_name', 'Postal Cheque Example', ''),
(119, 101, 'tid_special', '0', ''),
(120, 101, 'tid_ai', '0', ''),
(121, 101, 'tid_num', '0', ''),
(122, 101, 'tid_forward', '0', ''),
(123, 101, 'tid_back', '0', ''),
(124, 101, 'tid_enabled', '0', ''),
(125, 101, 'tid_foreign', '0', ''),
(126, 101, 'tid_email', '0', ''),
(127, 101, 'tid_autocreate', '0', ''),
(128, 101, 'tid_specials', '1', ''),
(129, 101, 'tid_shared', '', ''),
(130, 101, 'tid_foreigntemplate', '100', ''),
(131, 101, 'tid_nummax', '', ''),
(132, 101, 'tid_itemmax', '', ''),
(133, 101, 'tid_type', 'ORDER_DATA', ''),
(134, 101, 'tid_emailsubject', '', ''),
(135, 101, 'tid_emailbody', '', '');

DROP TABLE IF EXISTS `#__onepage_moss`;
CREATE TABLE `#__onepage_moss` (
  `id` int(11) NOT NULL,
  `eu_vat_id` varchar(50) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `ipc2` varchar(2) NOT NULL,
  `vm_country` varchar(100) NOT NULL DEFAULT '',
  `payment_country` varchar(100) NOT NULL,
  `vat_response_id` varchar(100) NOT NULL DEFAULT '',
  `vat_error` varchar(500) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `vat_data` text NOT NULL,
  `payment_data` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__onepage_numbering`;
CREATE TABLE `#__onepage_numbering` (
  `id` bigint(20) NOT NULL,
  `ref_idagenda` int(11) NOT NULL COMMENT 'OPC Agenda for Number formatting',
  `ref_idtype` int(11) NOT NULL DEFAULT '0' COMMENT 'A specific order_id or invoice_id or other entity',
  `ref_type` int(11) NOT NULL COMMENT 'Either invoice, order or OPC export theme',
  `ai` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `created` int(11) NOT NULL,
  `created_on` int(11) NOT NULL,
  `result` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__postinstall_messages` VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(4, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(5, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(6, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(7, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(8, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(9, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(10, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1),
(11, 700, 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', 1),
(12, 700, 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', 1, 'message', '', '', '', '', '3.9.0', 1),
(13, 700, 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', 1, 'message', '', '', '', '', '3.9.0', 1),
(14, 700, 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', 1);

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE `#__privacy_consents` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE `#__privacy_requests` (
  `id` int(10) UNSIGNED NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE `#__redirect_links` (
  `id` int(10) UNSIGNED NOT NULL,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__revslider_css`;
CREATE TABLE `#__revslider_css` (
  `id` int(10) UNSIGNED NOT NULL,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_css` VALUES
(1, '.tp-caption.medium_grey', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"padding\":\"2px 4px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#888\",\"white-space\":\"nowrap\"}'),
(2, '.tp-caption.small_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"14px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(3, '.tp-caption.medium_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(4, '.tp-caption.large_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(5, '.tp-caption.very_large_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"letter-spacing\":\"-2px\"}'),
(6, '.tp-caption.very_big_white', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"padding\":\"0px 4px\",\"padding-top\":\"1px\",\"background-color\":\"#000\"}'),
(7, '.tp-caption.very_big_black', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"padding\":\"0px 4px\",\"padding-top\":\"1px\",\"background-color\":\"#fff\"}'),
(8, '.tp-caption.modern_medium_fat', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(9, '.tp-caption.modern_medium_fat_white', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(10, '.tp-caption.modern_medium_light', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(11, '.tp-caption.modern_big_bluebg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#4e5b6c\",\"letter-spacing\":\"0\"}'),
(12, '.tp-caption.modern_big_redbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"padding-top\":\"1px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#de543e\",\"letter-spacing\":\"0\"}'),
(13, '.tp-caption.modern_small_text_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#555\",\"text-shadow\":\"none\",\"font-size\":\"14px\",\"line-height\":\"22px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(14, '.tp-caption.thinheadline_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"rgba(0,0,0,0.85)\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(15, '.tp-caption.thintext_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"rgba(0,0,0,0.85)\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"16px\",\"line-height\":\"26px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(16, '.tp-caption.largeblackbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#000\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(17, '.tp-caption.largepinkbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#db4360\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(18, '.tp-caption.largewhitebg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#fff\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(19, '.tp-caption.largegreenbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#67ae73\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(20, '.tp-caption.excerpt', NULL, NULL, '{\"font-size\":\"36px\",\"line-height\":\"36px\",\"font-weight\":\"700\",\"font-family\":\"Arial\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"rgba(0, 0, 0, 1)\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"letter-spacing\":\"-1.5px\",\"padding\":\"1px 4px 0px 4px\",\"white-space\":\"normal !important\",\"height\":\"auto\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 255, 255)\",\"border-style\":\"none\"}'),
(21, '.tp-caption.large_bold_grey', NULL, NULL, '{\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"padding\":\"1px 4px 0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(22, '.tp-caption.medium_thin_grey', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(23, '.tp-caption.small_thin_grey', NULL, NULL, '{\"font-size\":\"18px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(117, 117, 117)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(24, '.tp-caption.lightgrey_divider', NULL, NULL, '{\"text-decoration\":\"none\",\"background-color\":\"rgba(235, 235, 235, 1)\",\"width\":\"370px\",\"height\":\"3px\",\"background-position\":\"initial initial\",\"background-repeat\":\"initial initial\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(25, '.tp-caption.large_bold_darkblue', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(26, '.tp-caption.medium_bg_darkblue', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(52, 73, 94)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(27, '.tp-caption.medium_bold_red', NULL, NULL, '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(28, '.tp-caption.medium_light_red', NULL, NULL, '{\"font-size\":\"21px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(29, '.tp-caption.medium_bg_red', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(227, 58, 12)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(30, '.tp-caption.medium_bold_orange', NULL, NULL, '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(243, 156, 18)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(31, '.tp-caption.medium_bg_orange', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(243, 156, 18)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(32, '.tp-caption.large_bold_white', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(33, '.tp-caption.medium_light_white', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(34, '.tp-caption.mediumlarge_light_white', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(35, '.tp-caption.mediumlarge_light_white_center', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px 0px 0px 0px\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(36, '.tp-caption.medium_bg_asbestos', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(127, 140, 141)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(37, '.tp-caption.medium_light_black', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(38, '.tp-caption.large_bold_black', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(39, '.tp-caption.mediumlarge_light_darkblue', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(40, '.tp-caption.small_light_white', NULL, NULL, '{\"font-size\":\"17px\",\"line-height\":\"28px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(41, '.tp-caption.roundedimage', NULL, NULL, '{\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(42, '.tp-caption.large_bg_black', NULL, NULL, '{\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(0, 0, 0)\",\"padding\":\"10px 20px 15px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(43, '.tp-caption.mediumwhitebg', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(255, 255, 255)\",\"padding\":\"5px 15px 10px\",\"text-shadow\":\"none\",\"border-width\":\"0px\",\"border-color\":\"rgb(0, 0, 0)\",\"border-style\":\"none\"}'),
(44, '.tp-caption.custom', '{\"hover\":\"false\"}', '{\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}', '{\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(51, '.tp-caption.customhome', '{\"hover\":\"false\"}', '{\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}', '{\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(45, '.tp-caption.custom_btn', '{\"hover\":\"false\"}', '{\"font-size\":\"24px\",\"line-height\":\"60px\",\"font-weight\":\"300\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(52, 73, 94)\",\"padding\":\"0px 21px\",\"border-radius\":\"4px 4px 4px 4px\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}', '{\"color\":\"#ffffff\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 255, 255)\",\"border-style\":\"none\"}'),
(46, '.tp-caption.custom2', '{\"hover\":\"false\"}', '\"\"', '{\"color\":\"#e74c3c\",\"font-size\":\"16px\",\"line-height\":\"28px\",\"font-weight\":\"300\",\"text-transform\":\"uppercase\",\"text-align\":\"center\",\"background-color\":\"transparent\",\"text-decoration\":\"none\",\"border-width\":\"0px\",\"border-color\":\"rgb(231, 76, 60)\",\"border-style\":\"none\"}'),
(47, '.tp-caption.custom3', '{\"hover\":\"false\"}', '\"\"', '{\"color\":\"#e74c3c\",\"font-size\":\"43px\",\"line-height\":\"46px\",\"font-weight\":\"700\",\"text-transform\":\"uppercase\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(231, 76, 60)\",\"border-style\":\"none\"}'),
(48, '.tp-caption.custom4', '{\"hover\":\"false\"}', '\"\"', '{\"color\":\"#292f38\",\"font-size\":\"43px\",\"line-height\":\"46px\",\"font-weight\":\"900\",\"text-transform\":\"uppercase\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(41, 47, 56)\",\"border-style\":\"none\"}'),
(49, '.tp-caption.custom5', '{\"hover\":\"false\"}', '\"\"', '{\"font-size\":\"43px\",\"line-height\":\"46px\",\"font-weight\":\"700\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"text-transform\":\"uppercase\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 255, 255)\",\"border-style\":\"none\"}'),
(50, '.tp-caption.custom2_2', '{\"hover\":\"false\"}', '\"\"', '{\"font-size\":\"16px\",\"line-height\":\"28px\",\"font-weight\":\"300\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"text-transform\":\"uppercase\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(231, 76, 60)\",\"border-style\":\"none\"}');

DROP TABLE IF EXISTS `#__revslider_layer_animations`;
CREATE TABLE `#__revslider_layer_animations` (
  `id` int(10) UNSIGNED NOT NULL,
  `handle` text NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__revslider_settings`;
CREATE TABLE `#__revslider_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `general` text NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__revslider_sliders`;
CREATE TABLE `#__revslider_sliders` (
  `id` int(10) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_sliders` VALUES
(1, 'Slider', 'Slider', '{\"title\":\"Slider\",\"alias\":\"Slider\",\"shortcode\":\"[rev_slider Slider]\",\"source_type\":\"gallery\",\"post_types\":\"post\",\"post_category\":\"\",\"post_sortby\":\"ID\",\"posts_sort_direction\":\"DESC\",\"max_slider_posts\":\"30\",\"excerpt_limit\":\"55\",\"slider_template_id\":\"\",\"posts_list\":\"\",\"slider_type\":\"fullwidth\",\"fullscreen_offset_container\":\"\",\"fullscreen_offset_size\":\"\",\"fullscreen_min_height\":\"\",\"full_screen_align_force\":\"off\",\"auto_height\":\"off\",\"force_full_width\":\"off\",\"min_height\":\"100px\",\"width\":\"1170\",\"height\":\"400\",\"responsitive_w1\":\"940\",\"responsitive_sw1\":\"770\",\"responsitive_w2\":\"780\",\"responsitive_sw2\":\"500\",\"responsitive_w3\":\"510\",\"responsitive_sw3\":\"310\",\"responsitive_w4\":\"0\",\"responsitive_sw4\":\"0\",\"responsitive_w5\":\"0\",\"responsitive_sw5\":\"0\",\"responsitive_w6\":\"0\",\"responsitive_sw6\":\"0\",\"delay\":\"7000\",\"shuffle\":\"on\",\"lazy_load\":\"on\",\"enable_static_layers\":\"on\",\"next_slide_on_window_focus\":\"off\",\"stop_slider\":\"off\",\"stop_after_loops\":0,\"stop_at_slide\":2,\"show_timerbar\":\"top\",\"loop_slide\":\"loop\",\"position\":\"center\",\"margin_top\":0,\"margin_bottom\":0,\"margin_left\":0,\"margin_right\":0,\"position_behind\":\"false\",\"shadow_type\":\"0\",\"padding\":0,\"background_color\":\"#E9E9E9\",\"background_dotted_overlay\":\"none\",\"show_background_image\":\"false\",\"background_image\":\"\",\"bg_fit\":\"cover\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"stop_on_hover\":\"on\",\"keyboard_navigation\":\"off\",\"navigation_style\":\"square-old\",\"navigaion_type\":\"bullet\",\"navigation_arrows\":\"solo\",\"navigaion_always_on\":\"true\",\"hide_thumbs\":200,\"navigaion_align_hor\":\"center\",\"navigaion_align_vert\":\"bottom\",\"navigaion_offset_hor\":\"0\",\"navigaion_offset_vert\":30,\"leftarrow_align_hor\":\"left\",\"leftarrow_align_vert\":\"center\",\"leftarrow_offset_hor\":20,\"leftarrow_offset_vert\":0,\"rightarrow_align_hor\":\"right\",\"rightarrow_align_vert\":\"center\",\"rightarrow_offset_hor\":20,\"rightarrow_offset_vert\":0,\"thumb_width\":100,\"thumb_height\":50,\"thumb_amount\":5,\"use_spinner\":\"4\",\"spinner_color\":\"#FFFFFF\",\"use_parallax\":\"on\",\"disable_parallax_mobile\":\"on\",\"parallax_type\":\"mouse+scroll\",\"parallax_bg_freeze\":\"on\",\"parallax_level_1\":\"5\",\"parallax_level_2\":\"10\",\"parallax_level_3\":\"15\",\"parallax_level_4\":\"20\",\"parallax_level_5\":\"25\",\"parallax_level_6\":\"30\",\"parallax_level_7\":\"35\",\"parallax_level_8\":\"40\",\"parallax_level_9\":\"45\",\"parallax_level_10\":\"50\",\"touchenabled\":\"on\",\"swipe_velocity\":75,\"swipe_min_touches\":1,\"drag_block_vertical\":\"false\",\"disable_on_mobile\":\"on\",\"disable_kenburns_on_mobile\":\"off\",\"hide_slider_under\":0,\"hide_defined_layers_under\":0,\"hide_all_layers_under\":0,\"hide_arrows_on_mobile\":\"on\",\"hide_bullets_on_mobile\":\"on\",\"hide_thumbs_on_mobile\":\"on\",\"hide_thumbs_under_resolution\":0,\"hide_thumbs_delay_mobile\":1500,\"start_with_slide\":\"1\",\"first_transition_active\":\"false\",\"first_transition_type\":\"fade\",\"first_transition_duration\":300,\"first_transition_slot_amount\":7,\"simplify_ie8_ios4\":\"off\",\"show_alternative_type\":\"off\",\"show_alternate_image\":\"\",\"reset_transitions\":\"\",\"reset_transition_duration\":0,\"0\":\"<xecute settings on all slides\",\"load_googlefont\":\"false\",\"google_font\":[\"<link href=\'http:\\/\\/fonts.googleapis.com\\/css?family=PT+Sans+Narrow:400,700\' rel=\'stylesheet\' type=\'text\\/css\'>\"],\"template\":\"false\"}'),
(2, 'Slider2', 'slider2', '{\"title\":\"Slider2\",\"alias\":\"slider2\",\"shortcode\":\"[rev_slider slider2]\",\"source_type\":\"gallery\",\"post_types\":\"post\",\"post_category\":\"\",\"post_sortby\":\"ID\",\"posts_sort_direction\":\"DESC\",\"max_slider_posts\":\"30\",\"excerpt_limit\":\"55\",\"slider_template_id\":\"\",\"posts_list\":\"\",\"slider_type\":\"fullwidth\",\"fullscreen_offset_container\":\"\",\"fullscreen_offset_size\":\"\",\"fullscreen_min_height\":\"\",\"full_screen_align_force\":\"off\",\"auto_height\":\"off\",\"force_full_width\":\"off\",\"min_height\":\"100px\",\"width\":\"1170\",\"height\":\"600\",\"responsitive_w1\":\"940\",\"responsitive_sw1\":\"770\",\"responsitive_w2\":\"780\",\"responsitive_sw2\":\"500\",\"responsitive_w3\":\"510\",\"responsitive_sw3\":\"310\",\"responsitive_w4\":\"0\",\"responsitive_sw4\":\"0\",\"responsitive_w5\":\"0\",\"responsitive_sw5\":\"0\",\"responsitive_w6\":\"0\",\"responsitive_sw6\":\"0\",\"delay\":\"7000\",\"shuffle\":\"on\",\"lazy_load\":\"on\",\"enable_static_layers\":\"on\",\"next_slide_on_window_focus\":\"off\",\"stop_slider\":\"off\",\"stop_after_loops\":0,\"stop_at_slide\":2,\"show_timerbar\":\"top\",\"loop_slide\":\"loop\",\"position\":\"center\",\"margin_top\":0,\"margin_bottom\":0,\"margin_left\":0,\"margin_right\":0,\"position_behind\":\"false\",\"shadow_type\":\"0\",\"padding\":0,\"background_color\":\"#E9E9E9\",\"background_dotted_overlay\":\"none\",\"show_background_image\":\"false\",\"background_image\":\"\",\"bg_fit\":\"cover\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"stop_on_hover\":\"on\",\"keyboard_navigation\":\"off\",\"navigation_style\":\"square-old\",\"navigaion_type\":\"bullet\",\"navigation_arrows\":\"solo\",\"navigaion_always_on\":\"true\",\"hide_thumbs\":200,\"navigaion_align_hor\":\"center\",\"navigaion_align_vert\":\"bottom\",\"navigaion_offset_hor\":\"0\",\"navigaion_offset_vert\":30,\"leftarrow_align_hor\":\"left\",\"leftarrow_align_vert\":\"center\",\"leftarrow_offset_hor\":20,\"leftarrow_offset_vert\":0,\"rightarrow_align_hor\":\"right\",\"rightarrow_align_vert\":\"center\",\"rightarrow_offset_hor\":20,\"rightarrow_offset_vert\":0,\"thumb_width\":100,\"thumb_height\":50,\"thumb_amount\":5,\"use_spinner\":\"4\",\"spinner_color\":\"#FFFFFF\",\"use_parallax\":\"on\",\"disable_parallax_mobile\":\"on\",\"parallax_type\":\"mouse+scroll\",\"parallax_bg_freeze\":\"on\",\"parallax_level_1\":\"5\",\"parallax_level_2\":\"10\",\"parallax_level_3\":\"15\",\"parallax_level_4\":\"20\",\"parallax_level_5\":\"25\",\"parallax_level_6\":\"30\",\"parallax_level_7\":\"35\",\"parallax_level_8\":\"40\",\"parallax_level_9\":\"45\",\"parallax_level_10\":\"50\",\"touchenabled\":\"on\",\"swipe_velocity\":75,\"swipe_min_touches\":1,\"drag_block_vertical\":\"false\",\"disable_on_mobile\":\"on\",\"disable_kenburns_on_mobile\":\"off\",\"hide_slider_under\":0,\"hide_defined_layers_under\":0,\"hide_all_layers_under\":0,\"hide_arrows_on_mobile\":\"on\",\"hide_bullets_on_mobile\":\"on\",\"hide_thumbs_on_mobile\":\"on\",\"hide_thumbs_under_resolution\":0,\"hide_thumbs_delay_mobile\":1500,\"start_with_slide\":\"1\",\"first_transition_active\":\"false\",\"first_transition_type\":\"fade\",\"first_transition_duration\":300,\"first_transition_slot_amount\":7,\"simplify_ie8_ios4\":\"off\",\"show_alternative_type\":\"off\",\"show_alternate_image\":\"\",\"reset_transitions\":\"\",\"reset_transition_duration\":0,\"0\":\"<xecute settings on all slides\",\"load_googlefont\":\"false\",\"google_font\":[\"<link href=\'http:\\/\\/fonts.googleapis.com\\/css?family=PT+Sans+Narrow:400,700\' rel=\'stylesheet\' type=\'text\\/css\'>\"],\"template\":\"false\"}');

DROP TABLE IF EXISTS `#__revslider_slides`;
CREATE TABLE `#__revslider_slides` (
  `id` int(10) UNSIGNED NOT NULL,
  `slider_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_slides` VALUES
(1, 1, 3, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide1.jpg\",\"title\":\"Slide1\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1900,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\">The New Studiot<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt1_1\\\">Original Headphones<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":80,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1200,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1200,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5800,\"endSpeedFinal\":1200,\"realEndTime\":9000,\"timeLast\":5800,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">Beats by Dr. Dre<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":130,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"sfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$399.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"3\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtorightshort\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"4\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]'),
(9, 2, 3, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide1_wide.jpg\",\"title\":\"Slide1\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1900,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\">The New Studiot<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt1_1\\\">Original Headphones<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":80,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1200,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1200,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5800,\"endSpeedFinal\":1200,\"realEndTime\":9000,\"timeLast\":5800,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">Beats by Dr. Dre<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":130,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"sfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$399.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"3\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtorightshort\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"4\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]'),
(6, 1, 4, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide2.jpg\",\"title\":\"Slide2\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1800,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\"><span>The New<\\/span> Mackbook Air<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">All the power in your hands!<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":100,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$999.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtoright\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"3\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]'),
(7, 1, 5, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide3.jpg\",\"title\":\"Slide3\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1900,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\">Dell XPS 12 Ultrabook<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">All the power in your hands!<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":100,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$960.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtoright\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"3\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]'),
(10, 2, 4, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide2_wide.jpg\",\"title\":\"Slide2\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1800,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\"><span>The New<\\/span> Mackbook Air<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">All the power in your hands!<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":100,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$999.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtoright\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"3\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]'),
(11, 2, 5, '{\"background_type\":\"image\",\"image\":\"images\\/imgsliders\\/slide3_wide.jpg\",\"title\":\"Slide3\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":1900,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"9000\",\"kb_easing\":\"Linear.easeNone\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<span class=\\\"txt1\\\">Dell XPS 12 Ultrabook<\\/span>\\n\",\"type\":\"text\",\"left\":0,\"top\":50,\"loop_animation\":\"rs-pulse\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":781,\"height\":46,\"serial\":\"0\",\"endTimeFinal\":6300,\"endSpeedFinal\":700,\"realEndTime\":9000,\"timeLast\":6300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt2\\\">All the power in your hands!<\\/span>\",\"type\":\"text\",\"left\":0,\"top\":100,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":1700,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"4000\",\"endspeed\":1700,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":333,\"height\":46,\"serial\":\"1\",\"endTimeFinal\":5300,\"endSpeedFinal\":1700,\"realEndTime\":9000,\"timeLast\":5300,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt3\\\">For only <strong>$960.00<\\/strong><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":-20,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"lfl\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":2400,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":2400,\"endanimation\":\"ltr\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":281,\"height\":46,\"serial\":\"2\",\"endTimeFinal\":4600,\"endSpeedFinal\":2400,\"realEndTime\":9000,\"timeLast\":4600,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"},{\"text\":\"<span class=\\\"txt4\\\"><a class=\\\"btn-slider\\\" href=\\\"#\\\">Shop Now!<\\/a><\\/span>\",\"type\":\"text\",\"left\":0,\"top\":60,\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"animation\":\"skewfromleft\",\"easing\":\"easeInOutBack\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"whitespace\":\"nowrap\",\"speed\":3000,\"align_hor\":\"left\",\"align_vert\":\"middle\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"customhome\",\"time\":1500,\"endtime\":\"6000\",\"endspeed\":3000,\"endanimation\":\"skewtoright\",\"endeasing\":\"easeInBack\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"3\",\"endTimeFinal\":4000,\"endSpeedFinal\":3000,\"realEndTime\":9000,\"timeLast\":4000,\"endWithSlide\":true,\"max_height\":\"auto\",\"max_width\":\"auto\",\"2d_rotation\":\"\",\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"link_id\":\"\",\"link_class\":\"\",\"link_title\":\"\",\"link_rel\":\"\",\"static_start\":\"1\",\"static_end\":\"2\"}]');

DROP TABLE IF EXISTS `#__revslider_static_slides`;
CREATE TABLE `#__revslider_static_slides` (
  `id` int(10) UNSIGNED NOT NULL,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_static_slides` VALUES
(1, 1, '{\"background_type\":\"trans\"}', ''),
(2, 2, '{\"background_type\":\"trans\"}', '');

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__schemas` VALUES
(21, '3.5.1'),
(700, '3.9.10-2019-07-09'),
(10276, '3.6.2-2019-08-20');

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__sppagebuilder` VALUES
(1, 144, 'Test Builder', '[{\"id\":1569521300948,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569521300970,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569521300971,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H1. Lorem Ipsum Dolor\",\"heading_selector\":\"h1\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300972,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}},{\"id\":1569521300973,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":40,\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569521300974,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H2. Lorem Ipsum Dolor\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300975,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}},{\"id\":1569521300976,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":40,\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569521300977,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H3. Lorem Ipsum Dolor\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300978,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1569521300979,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":40,\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569521300980,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H4. Lorem Ipsum Dolor\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300981,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}},{\"id\":1569521300982,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":40,\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569521300983,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H5. Lorem Ipsum Dolor\",\"heading_selector\":\"h5\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300984,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}},{\"id\":1569521300985,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":40,\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569521300986,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"H6. Lorem Ipsum Dolor\",\"heading_selector\":\"h6\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_background_type\":\"none\",\"global_use_overlay\":0}},{\"id\":1569521300987,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing<span class=\\\"highlights\\\">amet</span> Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing.</p>\\n<p>Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing</p>\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}}]}]},{\"id\":1569570224685,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"35px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569570224684,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569570224688,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Button Group Addons\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1569570224689,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1569570224690,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569570224677,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Button Appearance Flat and Button Shape Raunded\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569583480099,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\"}]}},{\"id\":1569583480100,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569583480101,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"lg\"}]}},{\"id\":1569583480102,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569583480103,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xlg\"}]}},{\"id\":1569583480104,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569583480105,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"sm\"}]}},{\"id\":1569583480106,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569583480107,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"rounded\",\"size\":\"xs\"}]}}]}]},{\"id\":1569592090396,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1569592090397,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569592090403,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Button Appearance Outline and Button Shape Square\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569592090425,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\"}]}},{\"id\":1569592090426,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090427,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"lg\"}]}},{\"id\":1569592090428,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090429,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xlg\"}]}},{\"id\":1569592090430,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090431,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"sm\"}]}},{\"id\":1569592090432,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090433,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"outline\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"square\",\"size\":\"xs\"}]}}]}]},{\"id\":1569592090411,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1569592090412,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569592090419,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Button Appearance 3D and Button Shape Round\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569592090437,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"}]}},{\"id\":1569592090438,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090439,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"}]}},{\"id\":1569592090440,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090441,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"}]}},{\"id\":1569592090442,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090443,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"}]}},{\"id\":1569592090444,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090445,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"3d\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"}]}}]}]},{\"id\":1569592090413,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1569592090414,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569592090431,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Button Appearance Gradient and Button Shape Round\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569592090449,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\"}]}},{\"id\":1569592090450,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090451,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"lg\"}]}},{\"id\":1569592090452,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090453,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xlg\"}]}},{\"id\":1569592090454,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090455,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"sm\"}]}},{\"id\":1569592090456,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":{\"md\":\"30\",\"sm\":30,\"xs\":20},\"class\":\"\"}},{\"id\":1569592090457,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"alignment\":\"sppb-text-left\",\"margin\":{\"md\":\"4\"},\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"secondary\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"success\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"info\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"warning\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"danger\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"},{\"title\":\"Button\",\"font_style\":\"\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"gradient\",\"background_color\":\"#444444\",\"color\":\"#fff\",\"background_color_hover\":\"#222\",\"color_hover\":\"#fff\",\"button_padding\":\"\",\"url\":\"#\",\"shape\":\"round\",\"size\":\"xs\"}]}}]}]}]}]},{\"id\":1569583480195,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"35px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569583480196,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569583480197,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Accordion Addons\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1569583480198,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1569583480199,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569583480200,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Modern Style \",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569583480201,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-modern\",\"openitem\":\"hide\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":[{\"id\":1515998730372,\"name\":\"text_block\",\"settings\":{\"text\":\"Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor, dapibus eget, elementum vel, cursus eleifend, elit. Aenean auctor wisi et urna.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":[{\"id\":1516002839444,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":[{\"id\":1516002840630,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]}],\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1569583480202,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Faq Style \",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569583480203,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-faq\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":[{\"id\":1515998730372,\"name\":\"text_block\",\"settings\":{\"text\":\"Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor, dapibus eget, elementum vel, cursus eleifend, elit. Aenean auctor wisi et urna.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":[{\"id\":1516002839444,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":[{\"id\":1516002840630,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]}]}}]},{\"id\":1569583480204,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569583480205,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Default Style \",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569583480206,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-default\",\"openitem\":\"hide\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":[{\"id\":1515998730372,\"name\":\"text_block\",\"settings\":{\"text\":\"Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor, dapibus eget, elementum vel, cursus eleifend, elit. Aenean auctor wisi et urna.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":[{\"id\":1516002839444,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":[{\"id\":1516002840630,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]}],\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1569583480207,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Primary Style \",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569583480208,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-primary\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":[{\"id\":1515998730372,\"name\":\"text_block\",\"settings\":{\"text\":\"Donec sit amet eros. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor, dapibus eget, elementum vel, cursus eleifend, elit. Aenean auctor wisi et urna.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":[{\"id\":1516002839444,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]},{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":[{\"id\":1516002840630,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skat eboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\",\"dropcap\":0,\"alignment\":\"sppb-text-left\"}}]}]}}]}]}]}]},{\"id\":1569577604352,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"35px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569577604353,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569577604354,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tabs Addons\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1569577604355,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1569577604356,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569577604359,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tabs default style\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569577604360,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"tabs\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Tab 1\",\"icon\":\"\",\"content\":[{\"id\":1516004653288,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 2\",\"icon\":\"\",\"content\":[{\"id\":1516006868912,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 3\",\"icon\":\"\",\"content\":[{\"id\":1516006869676,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]}],\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1569577604375,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tabs pills style\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569577604376,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"pills\",\"active_tab_bg\":\"#f34f55\",\"active_tab_color\":\"#fff\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Tab 1\",\"icon\":\"\",\"content\":[{\"id\":1516004653288,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 2\",\"icon\":\"\",\"content\":[{\"id\":1516006868912,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 3\",\"icon\":\"\",\"content\":[{\"id\":1516006869676,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]}],\"show_boxshadow\":0}}]},{\"id\":1569577604361,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569577604366,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tabs modern style\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\"}},{\"id\":1569577604368,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"modern\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Tab 1\",\"icon\":\"\",\"content\":[{\"id\":1516004653288,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 2\",\"icon\":\"\",\"content\":[{\"id\":1516006868912,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 3\",\"icon\":\"\",\"content\":[{\"id\":1516006869676,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]}],\"show_boxshadow\":0,\"text_align\":\"sppb-text-left\",\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1569577604382,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tabs lines style\",\"heading_selector\":\"h4\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\"}},{\"id\":1569577604383,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"lines\",\"active_tab_bg\":\"#ffa371\",\"active_tab_color\":\"#ffa371\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Tab 1\",\"icon\":\"\",\"content\":[{\"id\":1516004653288,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 2\",\"icon\":\"\",\"content\":[{\"id\":1516006868912,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]},{\"title\":\"Tab 3\",\"icon\":\"\",\"content\":[{\"id\":1516006869676,\"name\":\"text_block\",\"settings\":{\"text\":\"Interactively procrastinate high-payoff content without backward compatible data. Quickly cultivate optimal processes and tactical architectures. <br />Completely iterate covalent strategic theme areas via accurate e-markets. Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications clicks-and-mortar catalysts.\",\"dropcap\":0}}]}]}}]}]}]}]},{\"id\":1569580162975,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"35px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569580162976,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569580162977,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Icon Box\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1569580162978,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"2,2,2,2,2,2\",\"visibility\":true,\"columns\":[{\"id\":1569580162979,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569580162911,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-home\",\"link\":\"\",\"size\":{\"md\":\"18\"},\"width\":{\"md\":\"20\"},\"height\":{\"md\":\"20\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#f34f55\"}}]},{\"id\":1569580162984,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162913,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-align-center\",\"link\":\"\",\"size\":{\"md\":\"24\"},\"width\":{\"md\":\"26\"},\"height\":{\"md\":\"26\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#ffa371\"}}]},{\"id\":1569580163026,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162915,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-pencil\",\"link\":\"\",\"size\":{\"md\":\"30\"},\"width\":{\"md\":\"32\"},\"height\":{\"md\":\"32\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#d0e7f1\"}}]},{\"id\":1569580163027,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162917,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-pencil-square-o\",\"link\":\"\",\"size\":{\"md\":\"36\"},\"width\":{\"md\":\"38\"},\"height\":{\"md\":\"38\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#1abc9c\"}}]},{\"id\":1569580163028,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162919,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-paint-brush\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"50\"},\"height\":{\"md\":\"50\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#c159db\"}}]},{\"id\":1569580163029,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162921,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-magic\",\"link\":\"\",\"size\":{\"md\":\"60\"},\"width\":{\"md\":\"62\"},\"height\":{\"md\":\"62\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#4e4ca0\"}}]}]},{\"id\":1569580163030,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"2,2,2,2,2,2\",\"visibility\":true,\"columns\":[{\"id\":1569580163031,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569580162924,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-bug\",\"link\":\"\",\"size\":{\"md\":\"18\"},\"width\":{\"md\":\"30\"},\"height\":{\"md\":\"30\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"background\":\"#4e4ca0\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"}}}]},{\"id\":1569580163034,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162926,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-drupal\",\"link\":\"\",\"size\":{\"md\":\"24\"},\"width\":{\"md\":\"40\"},\"height\":{\"md\":\"40\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#4e4ca0\"}}]},{\"id\":1569580163035,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162928,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-fire-extinguisher\",\"link\":\"\",\"size\":{\"md\":\"30\"},\"width\":{\"md\":\"50\"},\"height\":{\"md\":\"50\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#4e4ca0\"}}]},{\"id\":1569580163036,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162930,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-umbrella\",\"link\":\"\",\"size\":{\"md\":\"36\"},\"width\":{\"md\":\"56\"},\"height\":{\"md\":\"56\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#4e4ca0\"}}]},{\"id\":1569580163037,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162932,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-moon-o\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"background\":\"#4e4ca0\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"}}}]},{\"id\":1569580163038,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162934,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-codepen\",\"link\":\"\",\"size\":{\"md\":\"60\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"80\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#4e4ca0\"}}]}]},{\"id\":1569580163041,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"2,2,2,2,2,2\",\"visibility\":true,\"columns\":[{\"id\":1569580163042,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569580162937,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-graduation-cap\",\"link\":\"\",\"size\":{\"md\":\"18\"},\"width\":{\"md\":\"30\"},\"height\":{\"md\":\"30\"},\"use_hover\":1,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"background\":\"#1abc9c\",\"border_radius\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"hover_background\":\"#82c7ea\"}}]},{\"id\":1569580163047,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162939,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-percent\",\"link\":\"\",\"size\":{\"md\":\"24\"},\"width\":{\"md\":\"40\"},\"height\":{\"md\":\"40\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#f34f55\"}}]},{\"id\":1569580163048,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162941,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-bell\",\"link\":\"\",\"size\":{\"md\":\"30\"},\"width\":{\"md\":\"50\"},\"height\":{\"md\":\"50\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#ffa371\"}}]},{\"id\":1569580163049,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162943,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-wrench\",\"link\":\"\",\"size\":{\"md\":\"36\"},\"width\":{\"md\":\"56\"},\"height\":{\"md\":\"56\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#2e3131\",\"border_radius\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#d0e7f1\"}}]},{\"id\":1569580163050,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162945,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-magnet\",\"link\":\"\",\"size\":{\"md\":\"28\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#c159db\",\"background\":\"#fff\",\"border_radius\":{\"md\":\"70\",\"sm\":\"\",\"xs\":\"\"},\"border_color\":\"#c159db\"}}]},{\"id\":1569580163051,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162947,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-star\",\"link\":\"\",\"size\":{\"md\":\"30\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"80\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#fff\",\"border_radius\":{\"md\":\"80\",\"sm\":\"\",\"xs\":\"\"},\"background\":\"#1abc9c\",\"border_width\":{\"md\":\"4\",\"sm\":\"\",\"xs\":\"\"},\"border_color\":\"#2e3131\"}}]}]}]}]},{\"id\":1569580163154,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"35px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1569580162966,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1569580162967,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Animated Number Addons\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"line\"}},{\"id\":1569580162968,\"type\":\"inner_row\",\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_top_shape\":0,\"show_bottom_shape\":0},\"layout\":\"3,3,3,3\",\"visibility\":true,\"columns\":[{\"id\":1569580162969,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162970,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"2005\",\"text\":\"\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Company Established\",\"title_font_size\":{\"md\":\"14\"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\",\"bordercolor\":\"\",\"bgcolor\":\"#fff\",\"global_user_border\":1,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"20px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_radius\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"\"},\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"},\"global_border_color\":\"#42474c\",\"global_boder_style\":\"solid\"}}]},{\"id\":1569580162971,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162972,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"315\",\"text\":\"\",\"duration\":\"500\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Projects Done\",\"title_font_size\":{\"md\":\"14\"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#fff\",\"color2\":\"#fff\",\"bordercolor\":\"\",\"bgcolor\":\"\",\"global_user_border\":1,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"20px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_background_type\":\"color\",\"global_background_color\":\"#a255c4\",\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\"},\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"},\"global_border_color\":\"#a255c4\",\"global_boder_style\":\"dotted\"}}]},{\"id\":1569580162973,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162974,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"25\",\"text\":\"+\",\"duration\":\"200\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Business Parthners\",\"title_font_size\":{\"md\":\"14\"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#fff\",\"color2\":\"#fff\",\"bordercolor\":\"\",\"bgcolor\":\"\",\"global_user_border\":1,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"20px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"color\",\"global_background_color\":\"#41bedd\",\"global_border_color\":\"#41bedd\",\"global_boder_style\":\"dotted\"}}]},{\"id\":1569580162975,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162976,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"1510\",\"text\":\"\",\"duration\":\"800\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Happy Clients\",\"title_font_size\":{\"md\":\"14\"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\",\"bgcolor\":\"#fff\",\"bordercolor\":\"\",\"global_user_border\":1,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"20px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_radius\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"\"},\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"},\"global_border_color\":\"#42474c\",\"global_boder_style\":\"solid\"}}]}]},{\"id\":1569580162977,\"type\":\"inner_row\",\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"30px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_top_shape\":0,\"show_bottom_shape\":0},\"layout\":\"3,3,3,3\",\"visibility\":true,\"columns\":[{\"id\":1569580162978,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162979,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"2003\",\"text\":\"\",\"duration\":\"1500\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Company Established\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162980,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162981,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"150\",\"text\":\"\",\"duration\":\"1500\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Projects Done\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162982,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162983,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"98\",\"text\":\"+\",\"duration\":\"980\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Business Parthners\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162984,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162985,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"1307\",\"text\":\"\",\"duration\":\"1310\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Happy Clients\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]}]},{\"id\":1569580162986,\"type\":\"inner_row\",\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_top_shape\":0,\"show_bottom_shape\":0},\"layout\":\"3,3,3,3\",\"visibility\":true,\"columns\":[{\"id\":1569580162987,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162988,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-clock-o\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"48\"},\"height\":{\"md\":\"48\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"0px 0px 18px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#f34f55\"}},{\"id\":1569580162989,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"137\",\"text\":\"\",\"duration\":\"1800\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Projects Done\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162990,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162991,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-filter\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"48\"},\"height\":{\"md\":\"48\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"0px 0px 18px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#ffa371\"}},{\"id\":1569580162992,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"237\",\"text\":\"\",\"duration\":\"1800\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Projects Done\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162993,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162994,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-puzzle-piece\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"48\"},\"height\":{\"md\":\"48\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"0px 0px 18px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#1abc9c\"}},{\"id\":1569580162995,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"53\",\"text\":\"+\",\"duration\":\"530\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Business Parthners\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]},{\"id\":1569580162996,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162997,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-heart\",\"link\":\"\",\"size\":{\"md\":\"48\"},\"width\":{\"md\":\"48\"},\"height\":{\"md\":\"48\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"margin\":{\"md\":\"0px 0px 18px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#c159db\"}},{\"id\":1569580162998,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"1836\",\"text\":\"\",\"duration\":\"1836\",\"font_size\":{\"md\":\"48\"},\"counter_title\":\"Happy Clients\",\"title_font_size\":{\"md\":18},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"color\":\"#42474c\",\"color2\":\"#42474c\"}}]}]}]}]},{\"id\":1569580163149,\"type\":\"inner_row\",\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"show_top_shape\":0,\"show_bottom_shape\":0,\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#464848\",\"color2\":\"#42474c\",\"type\":\"radial\",\"pos\":\"43\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"background_color\":\"#464848\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1569580162949,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1569580162950,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Company Statistics\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\